/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.PrefixedSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorSerializationException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PrefixedSerializerTest {
    private final String str;
    public static UUID prefixUUID = UUID.randomUUID();

    public PrefixedSerializerTest(String str) {
        this.str = str;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{{""}, {null}, {"123"}, {"QWER"}, {"!@#$#$^%&^*fdghdfghdfgh%^&*"}, {new String("\u05e9".getBytes(), "utf-8")}};
        return Arrays.asList(data);
    }

    @Test
    public void test() {
        UUIDSerializer ue = new UUIDSerializer();
        StringSerializer se = new StringSerializer();
        PrefixedSerializer pe = new PrefixedSerializer((Object)prefixUUID, (Serializer)ue, (Serializer)se);
        Assert.assertEquals((Object)this.str, (Object)pe.fromByteBuffer(pe.toByteBuffer((Object)this.str)));
    }

    @Test
    public void testBadPrefix() {
        if (this.str == null) {
            return;
        }
        UUIDSerializer ue = new UUIDSerializer();
        StringSerializer se = new StringSerializer();
        PrefixedSerializer pe1 = new PrefixedSerializer((Object)prefixUUID, (Serializer)ue, (Serializer)se);
        UUID testUUID = UUID.randomUUID();
        Assert.assertNotSame((Object)prefixUUID, (Object)testUUID);
        PrefixedSerializer pe2 = new PrefixedSerializer((Object)testUUID, (Serializer)ue, (Serializer)se);
        String result = (String)pe2.fromByteBuffer(pe1.toByteBuffer((Object)this.str));
        Assert.assertNull((String)"Different prefixes should fail comparison", (Object)result);
    }

    @Test
    public void testNoPrefix() {
        if (this.str == null) {
            return;
        }
        UUIDSerializer ue = new UUIDSerializer();
        StringSerializer se = new StringSerializer();
        PrefixedSerializer pe1 = new PrefixedSerializer((Object)prefixUUID, (Serializer)ue, (Serializer)se);
        UUID testUUID = UUID.randomUUID();
        Assert.assertNotSame((Object)prefixUUID, (Object)testUUID);
        PrefixedSerializer pe2 = new PrefixedSerializer((Object)testUUID, (Serializer)ue, (Serializer)se);
        try {
            ByteBuffer bb = pe1.toByteBuffer((Object)this.str);
            bb.limit(5);
            pe2.fromByteBuffer(bb);
            Assert.fail((String)"Lack of prefix should raise exception");
        }
        catch (HectorSerializationException e) {
            // empty catch block
        }
    }
}

