/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.Collection;
import junit.framework.Assert;
import me.prettyprint.hector.api.Serializer;
import org.junit.Test;

public abstract class SerializerBaseTest<T> {
    @Test
    public void testRoundTrip() {
        for (T object : this.getTestData()) {
            Assert.assertEquals(object, (Object)this.getSerializer().fromByteBuffer(this.getSerializer().toByteBuffer(object)));
        }
    }

    @Test
    public void testNullObjectRoundTrip() {
        Assert.assertNull((Object)this.getSerializer().fromByteBuffer(this.getSerializer().toByteBuffer(null)));
    }

    @Test
    public void testByteBufferWithSharedBackingArrayIsOk() {
        for (T object : this.getTestData()) {
            byte[] bytes = this.getSerializer().toBytes(object);
            ByteBuffer byteBufferWithSharedBackingArray = this.copyIntoLargerArrayAndWrap(bytes);
            Object deserialized = this.getSerializer().fromByteBuffer(byteBufferWithSharedBackingArray);
            Assert.assertEquals(object, (Object)deserialized);
        }
    }

    private ByteBuffer copyIntoLargerArrayAndWrap(byte[] bytes) {
        int paddingLeft = 5;
        int paddingRight = 5;
        byte[] sharedBytesWithOtherStuff = new byte[bytes.length + paddingLeft + paddingRight];
        for (int i = 0; i < bytes.length; ++i) {
            sharedBytesWithOtherStuff[i + paddingLeft] = bytes[i];
        }
        ByteBuffer byteBufferWithSharedBackingArray = ByteBuffer.wrap(sharedBytesWithOtherStuff, paddingLeft, bytes.length);
        return byteBufferWithSharedBackingArray;
    }

    protected abstract Serializer<T> getSerializer();

    protected abstract Collection<T> getTestData();
}

