/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import me.prettyprint.cassandra.serializers.StringSerializer;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StringSerializerTest {
    private final String str;
    private static final StringSerializer s = StringSerializer.get();

    public StringSerializerTest(String str) {
        this.str = str;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() throws UnsupportedEncodingException {
        Object[][] data = new Object[][]{{""}, {null}, {"123"}, {"QWER"}, {"!@#$#$^%&^*fdghdfghdfgh%^&*"}, {new String("\u05e9".getBytes(), "utf-8")}, {RandomStringUtils.random((int)65536)}};
        return Arrays.asList(data);
    }

    @Test
    public void test() throws Exception {
        Assert.assertEquals((Object)this.str, (Object)s.fromByteBuffer(s.toByteBuffer(this.str)));
        if (this.str != null) {
            Assert.assertEquals((Object)this.str, (Object)ByteBufferUtil.string((ByteBuffer)ByteBufferUtil.bytes((String)this.str)));
        }
        if (this.str != null) {
            UTF8Type.instance.validate(s.toByteBuffer(this.str));
        }
    }
}

