/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import me.prettyprint.cassandra.serializers.SerializerTypeInferer;
import me.prettyprint.cassandra.serializers.TypeInferringSerializer;
import me.prettyprint.hector.api.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class TypeInferringSerializerTest {
    @Test
    public void testConversions() {
        this.test(new SampleObject());
        this.test("Test string");
        this.test(Integer.MAX_VALUE);
        this.test(Long.MIN_VALUE);
    }

    @Test
    public void testByteConversions() {
        TypeInferringSerializer ext = TypeInferringSerializer.get();
        ByteBuffer byteBuffer = ext.toByteBuffer((Object)"bytes".getBytes());
        Assert.assertTrue((byteBuffer != null ? 1 : 0) != 0);
    }

    private void test(Object object) {
        TypeInferringSerializer ext = TypeInferringSerializer.get();
        ByteBuffer bytes = ext.toByteBuffer(object);
        Serializer ser = SerializerTypeInferer.getSerializer(object.getClass());
        Object target = ser.fromByteBuffer(bytes);
        Assert.assertEquals((Object)object, (Object)target);
    }

    private static class SampleObject
    implements Serializable {
        private final String a = "test";
        private final List<Void> b = new ArrayList<Void>();
        private final Calendar c = Calendar.getInstance();

        private SampleObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ("test" == null ? 0 : "test".hashCode());
            result = 31 * result + (this.b == null ? 0 : ((Object)this.b).hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleObject other = (SampleObject)obj;
            if ("test" == null ? other.a != null : !"test".equals(other.a)) {
                return false;
            }
            if (this.b == null ? other.b != null : !((Object)this.b).equals(other.b)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }
    }
}

