/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.BatchMutation;
import me.prettyprint.cassandra.service.BatchSizeHint;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SuperColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BatchMutationTest {
    private List<String> columnFamilies;
    private BatchMutation<String> batchMutate;

    @Before
    public void setup() {
        this.columnFamilies = new ArrayList<String>();
        this.columnFamilies.add("Standard1");
        this.batchMutate = new BatchMutation((Serializer)StringSerializer.get());
    }

    @Test
    public void testAddInsertion() {
        Column column = new Column(StringSerializer.get().toByteBuffer("c_name"));
        column.setValue(StringSerializer.get().toByteBuffer("c_val"));
        column.setTimestamp(System.currentTimeMillis());
        this.batchMutate.addInsertion((Object)"key1", this.columnFamilies, column);
        Map mutationMap = this.batchMutate.getMutationMap();
        Assert.assertEquals((long)1L, (long)((Map)mutationMap.get(StringSerializer.get().toByteBuffer("key1"))).size());
        Column column2 = new Column(StringSerializer.get().toByteBuffer("c_name2"));
        column2.setValue(StringSerializer.get().toByteBuffer("c_val2"));
        column2.setTimestamp(System.currentTimeMillis());
        this.batchMutate.addInsertion((Object)"key1", this.columnFamilies, column2);
        Assert.assertEquals((long)2L, (long)((List)((Map)mutationMap.get(StringSerializer.get().toByteBuffer("key1"))).get("Standard1")).size());
    }

    @Test
    public void testAddInsertionWithHint() {
        BatchMutation batchMutate = new BatchMutation((Serializer)StringSerializer.get(), new BatchSizeHint(1, 50));
        Column column = new Column(StringSerializer.get().toByteBuffer("c_name"));
        column.setValue(StringSerializer.get().toByteBuffer("c_val"));
        column.setTimestamp(System.currentTimeMillis());
        batchMutate.addInsertion((Object)"key1", this.columnFamilies, column);
        Map mutMap = batchMutate.getMutationMap();
        Assert.assertEquals((long)1L, (long)mutMap.size());
        Assert.assertEquals((Object)ByteBuffer.wrap("key1".getBytes()), mutMap.keySet().iterator().next());
        Map cfMutMap = (Map)mutMap.values().iterator().next();
        Assert.assertEquals((long)1L, (long)cfMutMap.size());
        List cfMutList = (List)cfMutMap.values().iterator().next();
        Assert.assertTrue((boolean)(cfMutList instanceof ArrayList));
    }

    @Test
    public void testAddSuperInsertion() {
        Column column = new Column(StringSerializer.get().toByteBuffer("c_name"));
        column.setValue(StringSerializer.get().toByteBuffer("c_val"));
        column.setTimestamp(System.currentTimeMillis());
        SuperColumn sc = new SuperColumn(StringSerializer.get().toByteBuffer("c_name"), Arrays.asList(column));
        this.batchMutate.addSuperInsertion((Object)"key1", this.columnFamilies, sc);
        Assert.assertEquals((long)1L, (long)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).size());
        column = new Column(StringSerializer.get().toByteBuffer("c_name"));
        column.setValue(StringSerializer.get().toByteBuffer("c_val"));
        column.setTimestamp(System.currentTimeMillis());
        SuperColumn sc2 = new SuperColumn(StringSerializer.get().toByteBuffer("c_name2"), Arrays.asList(column));
        this.batchMutate.addSuperInsertion((Object)"key1", this.columnFamilies, sc2);
        Assert.assertEquals((long)2L, (long)((List)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).get("Standard1")).size());
    }

    @Test
    public void testAddDeletion() {
        Deletion deletion = new Deletion().setTimestamp(System.currentTimeMillis());
        SlicePredicate slicePredicate = new SlicePredicate();
        slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("c_name"));
        deletion.setPredicate(slicePredicate);
        this.batchMutate.addDeletion((Object)"key1", this.columnFamilies, deletion);
        Assert.assertEquals((long)1L, (long)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).size());
        deletion = new Deletion().setTimestamp(System.currentTimeMillis());
        slicePredicate = new SlicePredicate();
        slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("c_name2"));
        deletion.setPredicate(slicePredicate);
        this.batchMutate.addDeletion((Object)"key1", this.columnFamilies, deletion);
        Assert.assertEquals((long)2L, (long)((List)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).get("Standard1")).size());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.batchMutate.isEmpty());
        Column c1 = new Column(StringSerializer.get().toByteBuffer("c_name"));
        c1.setValue(StringSerializer.get().toByteBuffer("c_val"));
        c1.setTimestamp(System.currentTimeMillis());
        this.batchMutate.addInsertion((Object)"key1", this.columnFamilies, c1);
        Assert.assertFalse((boolean)this.batchMutate.isEmpty());
        CounterColumn cc1 = new CounterColumn(StringSerializer.get().toByteBuffer("c_name"), 13L);
        this.batchMutate.addCounterInsertion((Object)"key1", this.columnFamilies, cc1);
        Assert.assertFalse((boolean)this.batchMutate.isEmpty());
    }

    @Test
    public void testAddCounterInsertion() {
        CounterColumn cc1 = new CounterColumn(StringSerializer.get().toByteBuffer("c_name"), 222L);
        this.batchMutate.addCounterInsertion((Object)"key1", this.columnFamilies, cc1);
        Map mutationMap = this.batchMutate.getMutationMap();
        Assert.assertEquals((long)1L, (long)((Map)mutationMap.get(StringSerializer.get().toByteBuffer("key1"))).size());
        CounterColumn cc2 = new CounterColumn(StringSerializer.get().toByteBuffer("c_name2"), 44L);
        this.batchMutate.addCounterInsertion((Object)"key1", this.columnFamilies, cc2);
        Assert.assertEquals((long)2L, (long)((List)((Map)mutationMap.get(StringSerializer.get().toByteBuffer("key1"))).get("Standard1")).size());
    }

    @Test
    public void testAddCounterDeletion() {
        Deletion counterDeletion = new Deletion();
        SlicePredicate slicePredicate = new SlicePredicate();
        slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("c_name"));
        counterDeletion.setPredicate(slicePredicate);
        this.batchMutate.addDeletion((Object)"key1", this.columnFamilies, counterDeletion);
        Assert.assertEquals((long)1L, (long)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).size());
        counterDeletion = new Deletion();
        slicePredicate = new SlicePredicate();
        slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("c_name2"));
        counterDeletion.setPredicate(slicePredicate);
        this.batchMutate.addDeletion((Object)"key1", this.columnFamilies, counterDeletion);
        Assert.assertEquals((long)2L, (long)((List)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).get("Standard1")).size());
    }

    @Test
    public void testAddSuperCounterInsertion() {
        CounterSuperColumn csc1 = new CounterSuperColumn(StringSerializer.get().toByteBuffer("c_name"), Arrays.asList(new CounterColumn(StringSerializer.get().toByteBuffer("c_name"), 123L)));
        this.batchMutate.addSuperCounterInsertion((Object)"key1", this.columnFamilies, csc1);
        Assert.assertEquals((long)1L, (long)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).size());
        CounterSuperColumn csc2 = new CounterSuperColumn(StringSerializer.get().toByteBuffer("c_name2"), Arrays.asList(new CounterColumn(StringSerializer.get().toByteBuffer("c_name"), 456L)));
        this.batchMutate.addSuperCounterInsertion((Object)"key1", this.columnFamilies, csc2);
        Assert.assertEquals((long)2L, (long)((List)((Map)this.batchMutate.getMutationMap().get(StringSerializer.get().toByteBuffer("key1"))).get("Standard1")).size());
    }
}

