/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.model.QuorumAllConsistencyLevelPolicy;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.KeyspaceServiceImpl;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.cassandra.utils.StringUtils;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HNotFoundException;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.testutils.EmbeddedServerHelper;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class CassandraAuthTest {
    private static final String TMP = "tmp";
    private static EmbeddedServerHelper embedded;
    private static Map<String, String> user1Credentials;
    private static Map<String, String> user2Credentials;
    private static Map<String, String> user1CredentialsBad;
    private CassandraHostConfigurator cassandraHostConfigurator;
    private HConnectionManager connectionManager;
    private String clusterName = "TestCluster";

    @BeforeClass
    public static void setup() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        System.setProperty("passwd.properties", "tmp/passwd.properties");
        System.setProperty("access.properties", "tmp/access.properties");
        embedded = new EmbeddedServerHelper("/cassandra-auth.yaml");
        embedded.setup();
        CassandraAuthTest.copy("/passwd.properties", TMP);
        CassandraAuthTest.copy("/access.properties", TMP);
        user1Credentials.put("username", "user1");
        user1Credentials.put("password", "password1");
        user2Credentials.put("username", "user2");
        user2Credentials.put("password", "password2");
        user1CredentialsBad.put("username", "user1");
        user1CredentialsBad.put("password", "badpassword");
    }

    @AfterClass
    public static void teardown() throws IOException {
        EmbeddedServerHelper.teardown();
        embedded = null;
    }

    @Before
    public void setupCase() throws TTransportException, TException, IllegalArgumentException, NotFoundException, UnknownHostException, Exception {
        this.cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170");
        this.connectionManager = new HConnectionManager(this.clusterName, this.cassandraHostConfigurator);
    }

    @Test
    public void testDescribeKeyspaces() throws Exception {
        ThriftCluster cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator, user1Credentials);
        List keyspaces = cassandraCluster.describeKeyspaces();
        Assert.assertEquals((long)2L, (long)keyspaces.size());
    }

    @Test
    public void testDescribeKeyspacesBadAuth() throws Exception {
        ThriftCluster cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator, user1CredentialsBad);
        try {
            cassandraCluster.describeKeyspaces();
            Assert.fail((String)"Should have gotten a wrapped AuthenticationException");
        }
        catch (HectorException he) {
            Assert.assertTrue((boolean)(he.getCause() instanceof AuthenticationException));
        }
    }

    @Test
    public void testDescribeKeyspace() throws Exception {
        ThriftCluster cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator, user1Credentials);
        KeyspaceDefinition keyspaceDetail = cassandraCluster.describeKeyspace("Keyspace1");
        Assert.assertNotNull((Object)keyspaceDetail);
        Assert.assertEquals((long)22L, (long)keyspaceDetail.getCfDefs().size());
    }

    @Test
    public void testAddDropColumnFamily() throws Exception {
        ThriftCluster cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator, user1Credentials);
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"Keyspace1", (String)"DynCf");
        cassandraCluster.addColumnFamily(cfDef);
        String cfid2 = cassandraCluster.dropColumnFamily("Keyspace1", "DynCf");
        Assert.assertNotNull((Object)cfid2);
    }

    @Test
    public void testAddDropKeyspace() throws Exception {
        ThriftCluster cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator, user1Credentials);
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"DynKeyspace", (String)"DynCf");
        cassandraCluster.addKeyspace((KeyspaceDefinition)new ThriftKsDef("DynKeyspace", "org.apache.cassandra.locator.SimpleStrategy", 1, Arrays.asList(cfDef)));
        String ksid2 = cassandraCluster.dropKeyspace("DynKeyspace");
        Assert.assertNotNull((Object)ksid2);
    }

    @Test
    public void testInsertAndGetAndRemove() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, HNotFoundException, Exception {
        int i;
        KeyspaceServiceImpl keyspace = new KeyspaceServiceImpl("Keyspace1", (ConsistencyLevelPolicy)new QuorumAllConsistencyLevelPolicy(), this.connectionManager, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE, user1Credentials);
        ColumnPath cp = new ColumnPath("Standard1");
        cp.setColumn(StringUtils.bytes((String)"testInsertAndGetAndRemove"));
        for (i = 0; i < 100; ++i) {
            keyspace.insert("testInsertAndGetAndRemove_" + i, cp, StringSerializer.get().toByteBuffer("testInsertAndGetAndRemove_value_" + i));
        }
        for (i = 0; i < 100; ++i) {
            Column col = keyspace.getColumn("testInsertAndGetAndRemove_" + i, cp);
            Assert.assertNotNull((Object)col);
            String value = StringUtils.string((byte[])col.getValue());
            Assert.assertEquals((Object)("testInsertAndGetAndRemove_value_" + i), (Object)value);
        }
        for (i = 0; i < 100; ++i) {
            keyspace.remove("testInsertAndGetAndRemove_" + i, cp);
        }
        for (i = 0; i < 100; ++i) {
            try {
                keyspace.getColumn("testInsertAndGetAndRemove_" + i, cp);
                Assert.fail((String)"the value should already being deleted");
                continue;
            }
            catch (HNotFoundException e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testInsertAndGetAndRemoveBadAuth() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, HNotFoundException, Exception {
        KeyspaceServiceImpl keyspace = new KeyspaceServiceImpl("Keyspace1", (ConsistencyLevelPolicy)new QuorumAllConsistencyLevelPolicy(), this.connectionManager, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE, user1CredentialsBad);
        try {
            ColumnPath cp = new ColumnPath("Standard1");
            cp.setColumn(StringUtils.bytes((String)"testInsertAndGetAndRemove"));
            for (int i = 0; i < 100; ++i) {
                keyspace.insert("testInsertAndGetAndRemove_" + i, cp, StringSerializer.get().toByteBuffer("testInsertAndGetAndRemove_value_" + i));
            }
            Assert.fail((String)"Should have gotten a wrapped AuthenticationException");
        }
        catch (HectorException he) {
            Assert.assertTrue((boolean)(he.getCause() instanceof AuthenticationException));
        }
    }

    private static void copy(String resource, String directory) throws IOException {
        int len;
        FileUtils.createDirectory((String)directory);
        InputStream is = CassandraAuthTest.class.getResourceAsStream(resource);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        File file = new File(directory + System.getProperty("file.separator") + fileName);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        is.close();
    }

    static {
        user1Credentials = new HashMap<String, String>();
        user2Credentials = new HashMap<String, String>();
        user1CredentialsBad = new HashMap<String, String>();
    }
}

