/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.model.BasicColumnDefinition;
import me.prettyprint.cassandra.model.BasicColumnFamilyDefinition;
import me.prettyprint.cassandra.model.BasicKeyspaceDefinition;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCfDef;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.ddl.ColumnDefinition;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class CassandraClusterTest
extends BaseEmbededServerSetupTest {
    private ThriftCluster cassandraCluster;
    private CassandraHostConfigurator cassandraHostConfigurator;

    @Before
    public void setupCase() throws TTransportException, TException, IllegalArgumentException, NotFoundException, UnknownHostException, Exception {
        this.cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170");
        this.cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator);
    }

    @Test
    public void testDescribeKeyspaces() throws Exception {
        List keyspaces = this.cassandraCluster.describeKeyspaces();
        Assert.assertEquals((long)4L, (long)keyspaces.size());
    }

    @Test
    public void testDescribeClusterName() throws Exception {
        Assert.assertEquals((Object)"Test Cluster", (Object)this.cassandraCluster.describeClusterName());
    }

    @Test
    @Ignore
    public void testDescribeThriftVersion() throws Exception {
        Assert.assertEquals((Object)"19.35.0", (Object)this.cassandraCluster.describeThriftVersion());
    }

    @Test
    public void testDescribeRing() throws Exception {
        List ring = this.cassandraCluster.describeRing("Keyspace1");
        Assert.assertEquals((long)1L, (long)ring.size());
    }

    @Test
    public void testDescribeKeyspace() throws Exception {
        KeyspaceDefinition keyspaceDetail = this.cassandraCluster.describeKeyspace("Keyspace1");
        Assert.assertNotNull((Object)keyspaceDetail);
        Assert.assertEquals((long)22L, (long)keyspaceDetail.getCfDefs().size());
    }

    @Test
    public void testDescribePartitioner() throws Exception {
        String partitioner = this.cassandraCluster.describePartitioner();
        Assert.assertEquals((Object)"org.apache.cassandra.dht.OrderPreservingPartitioner", (Object)partitioner);
    }

    @Test
    public void testAddDropColumnFamily() throws Exception {
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"Keyspace1", (String)"DynCf");
        this.cassandraCluster.addColumnFamily(cfDef);
        String cfid2 = this.cassandraCluster.dropColumnFamily("Keyspace1", "DynCf");
        Assert.assertNotNull((Object)cfid2);
        this.cassandraCluster.addColumnFamily(cfDef, true);
        cfid2 = this.cassandraCluster.dropColumnFamily("Keyspace1", "DynCf", true);
        Assert.assertNotNull((Object)cfid2);
    }

    @Test
    public void testTruncateColumnFamily() throws Exception {
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"Keyspace1", (String)"TruncateableCf");
        this.cassandraCluster.addColumnFamily(cfDef);
        Keyspace workingKeyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cassandraCluster);
        Mutator mutator = HFactory.createMutator((Keyspace)workingKeyspace, (Serializer)StringSerializer.get());
        mutator.insert((Object)"mykey", "TruncateableCf", HFactory.createStringColumn((String)"mycolname", (String)"myval"));
        ColumnQuery q = HFactory.createColumnQuery((Keyspace)workingKeyspace, (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        q.setKey((Object)"mykey").setName((Object)"mycolname").setColumnFamily("TruncateableCf");
        Assert.assertEquals((Object)"myval", (Object)((HColumn)q.execute().get()).getValue());
        this.cassandraCluster.truncate("Keyspace1", "TruncateableCf");
        Assert.assertNull((Object)q.execute().get());
    }

    @Test
    public void testAddDropKeyspace() throws Exception {
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"DynKeyspace", (String)"DynCf");
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)new ThriftKsDef("DynKeyspace", "org.apache.cassandra.locator.SimpleStrategy", 1, Arrays.asList(cfDef)));
        String ksid2 = this.cassandraCluster.dropKeyspace("DynKeyspace");
        Assert.assertNotNull((Object)ksid2);
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)new ThriftKsDef("DynKeyspace", "org.apache.cassandra.locator.SimpleStrategy", 1, Arrays.asList(cfDef)), true);
        ksid2 = this.cassandraCluster.dropKeyspace("DynKeyspace", true);
        Assert.assertNotNull((Object)ksid2);
    }

    @Test
    public void testAddKeyspaceNTS() throws Exception {
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"DynKeyspaceNTS", (String)"DynCf");
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)new ThriftKsDef("DynKeyspaceNTS", "org.apache.cassandra.locator.NetworkTopologyStrategy", 1, Arrays.asList(cfDef)));
    }

    @Test
    public void testEditKeyspace() throws Exception {
        BasicColumnFamilyDefinition columnFamilyDefinition = new BasicColumnFamilyDefinition();
        columnFamilyDefinition.setKeyspaceName("DynKeyspace2");
        columnFamilyDefinition.setName("DynamicCF");
        ThriftCfDef cfDef = new ThriftCfDef((ColumnFamilyDefinition)columnFamilyDefinition);
        KeyspaceDefinition keyspaceDefinition = HFactory.createKeyspaceDefinition((String)"DynKeyspace2", (String)"org.apache.cassandra.locator.SimpleStrategy", (int)1, Arrays.asList(cfDef));
        this.cassandraCluster.addKeyspace(keyspaceDefinition);
        keyspaceDefinition = HFactory.createKeyspaceDefinition((String)"DynKeyspace2", (String)"org.apache.cassandra.locator.SimpleStrategy", (int)2, null);
        this.cassandraCluster.updateKeyspace(keyspaceDefinition);
        KeyspaceDefinition fromCluster = this.cassandraCluster.describeKeyspace("DynKeyspace2");
        Assert.assertEquals((long)2L, (long)fromCluster.getReplicationFactor());
        this.cassandraCluster.dropKeyspace("DynKeyspace2");
    }

    @Test
    public void testAddColumnDefinitionWhenNoneOnConstructor() {
        ColumnFamilyDefinition cfDef = HFactory.createColumnFamilyDefinition((String)"blah-ks", (String)"blah-cf", (ComparatorType)ComparatorType.BYTESTYPE);
        Assert.assertSame(Collections.emptyList(), (Object)cfDef.getColumnMetadata());
        BasicColumnDefinition cd = new BasicColumnDefinition();
        cd.setName(ByteBuffer.wrap("colname".getBytes()));
        cd.setValidationClass("org.apache.cassandra.db.marshal.UTF8Type");
        cfDef.addColumnDefinition((ColumnDefinition)cd);
        Assert.assertEquals((long)1L, (long)cfDef.getColumnMetadata().size());
        Assert.assertEquals((Object)cd, cfDef.getColumnMetadata().get(0));
    }

    @Test
    public void testEditColumnFamily() throws Exception {
        BasicColumnFamilyDefinition columnFamilyDefinition = new BasicColumnFamilyDefinition();
        columnFamilyDefinition.setKeyspaceName("DynKeyspace3");
        columnFamilyDefinition.setName("DynamicCF");
        ThriftCfDef cfDef = new ThriftCfDef((ColumnFamilyDefinition)columnFamilyDefinition);
        KeyspaceDefinition keyspaceDefinition = HFactory.createKeyspaceDefinition((String)"DynKeyspace3", (String)"org.apache.cassandra.locator.SimpleStrategy", (int)1, Arrays.asList(cfDef));
        this.cassandraCluster.addKeyspace(keyspaceDefinition);
        KeyspaceDefinition fromCluster = this.cassandraCluster.describeKeyspace("DynKeyspace3");
        cfDef = (ColumnFamilyDefinition)fromCluster.getCfDefs().get(0);
        columnFamilyDefinition = new BasicColumnFamilyDefinition((ColumnFamilyDefinition)cfDef);
        BasicColumnDefinition columnDefinition = new BasicColumnDefinition();
        columnDefinition.setName(StringSerializer.get().toByteBuffer("birthdate"));
        columnDefinition.setIndexName("birthdate_idx");
        columnDefinition.setIndexType(ColumnIndexType.KEYS);
        columnDefinition.setValidationClass(ComparatorType.LONGTYPE.getClassName());
        columnFamilyDefinition.addColumnDefinition((ColumnDefinition)columnDefinition);
        columnDefinition = new BasicColumnDefinition();
        columnDefinition.setName(StringSerializer.get().toByteBuffer("nonindexed_field"));
        columnDefinition.setValidationClass(ComparatorType.LONGTYPE.getClassName());
        columnFamilyDefinition.addColumnDefinition((ColumnDefinition)columnDefinition);
        this.cassandraCluster.updateColumnFamily((ColumnFamilyDefinition)new ThriftCfDef((ColumnFamilyDefinition)columnFamilyDefinition));
        fromCluster = this.cassandraCluster.describeKeyspace("DynKeyspace3");
        Assert.assertEquals((Object)"birthdate", (Object)StringSerializer.get().fromByteBuffer(((ColumnDefinition)((ColumnFamilyDefinition)fromCluster.getCfDefs().get(0)).getColumnMetadata().get(0)).getName()));
        Assert.assertEquals((Object)"birthdate_idx", (Object)((ColumnDefinition)((ColumnFamilyDefinition)fromCluster.getCfDefs().get(0)).getColumnMetadata().get(0)).getIndexName());
        Assert.assertEquals((Object)"nonindexed_field", (Object)StringSerializer.get().fromByteBuffer(((ColumnDefinition)((ColumnFamilyDefinition)fromCluster.getCfDefs().get(0)).getColumnMetadata().get(1)).getName()));
    }

    @Test
    public void testAddEmptyKeyspace() throws Exception {
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)new ThriftKsDef("DynKeyspaceEmpty"));
        Assert.assertNotNull((Object)this.cassandraCluster.describeKeyspace("DynKeyspaceEmpty"));
        String ksid2 = this.cassandraCluster.dropKeyspace("DynKeyspaceEmpty");
        Assert.assertNotNull((Object)ksid2);
    }

    @Test
    public void testAddEmptyBasicKeyspaceDefinition() throws Exception {
        BasicKeyspaceDefinition ksDef = new BasicKeyspaceDefinition();
        ksDef.setName("DynKeyspaceEmpty");
        ksDef.setReplicationFactor(1);
        ksDef.setStrategyClass("SimpleStrategy");
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)ksDef);
        Assert.assertNotNull((Object)this.cassandraCluster.describeKeyspace("DynKeyspaceEmpty"));
        String ksid2 = this.cassandraCluster.dropKeyspace("DynKeyspaceEmpty");
        Assert.assertNotNull((Object)ksid2);
    }

    @Test
    public void testEditBasicKeyspaceDefinition() throws Exception {
        BasicKeyspaceDefinition ksDef = new BasicKeyspaceDefinition();
        ksDef.setName("DynKeyspace4");
        ksDef.setReplicationFactor(1);
        ksDef.setStrategyClass("SimpleStrategy");
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)ksDef);
        Assert.assertNotNull((Object)this.cassandraCluster.describeKeyspace("DynKeyspace4"));
        ksDef.setReplicationFactor(2);
        this.cassandraCluster.updateKeyspace((KeyspaceDefinition)ksDef);
        KeyspaceDefinition fromCluster = this.cassandraCluster.describeKeyspace("DynKeyspace4");
        Assert.assertEquals((long)2L, (long)fromCluster.getReplicationFactor());
        this.cassandraCluster.dropKeyspace("DynKeyspace4");
    }

    @Test
    public void testAddDropBasicColumnFamilyDefinition() throws Exception {
        BasicColumnFamilyDefinition cfDef = new BasicColumnFamilyDefinition();
        cfDef.setName("DynCf");
        cfDef.setKeyspaceName("Keyspace1");
        this.cassandraCluster.addColumnFamily((ColumnFamilyDefinition)cfDef);
        String cfid2 = this.cassandraCluster.dropColumnFamily("Keyspace1", "DynCf");
        Assert.assertNotNull((Object)cfid2);
    }

    @Test
    public void testEditBasicColumnFamilyDefinition() throws Exception {
        BasicKeyspaceDefinition ksDef = new BasicKeyspaceDefinition();
        ksDef.setName("Keyspace2");
        ksDef.setReplicationFactor(1);
        ksDef.setStrategyClass("SimpleStrategy");
        this.cassandraCluster.addKeyspace((KeyspaceDefinition)ksDef);
        BasicColumnFamilyDefinition cfDef = new BasicColumnFamilyDefinition();
        cfDef.setName("DynCf2");
        cfDef.setKeyspaceName("Keyspace2");
        this.cassandraCluster.addColumnFamily((ColumnFamilyDefinition)cfDef);
        KeyspaceDefinition fromCluster = this.cassandraCluster.describeKeyspace("Keyspace2");
        cfDef = new BasicColumnFamilyDefinition((ColumnFamilyDefinition)fromCluster.getCfDefs().get(0));
        cfDef.setDefaultValidationClass(ComparatorType.LONGTYPE.getClassName());
        this.cassandraCluster.updateColumnFamily((ColumnFamilyDefinition)cfDef);
        String cfid2 = this.cassandraCluster.dropColumnFamily("Keyspace2", "DynCf2");
        Assert.assertNotNull((Object)cfid2);
    }
}

