/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import me.prettyprint.cassandra.connection.factory.HKerberosSecuredThriftClientFactoryImpl;
import me.prettyprint.cassandra.connection.factory.HThriftClientFactoryImpl;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.ClockResolution;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CassandraHostConfiguratorTest {
    @Before
    public void setup() {
    }

    @Test
    public void testSimpleCassandraHostSetup() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170");
        CassandraHost[] cassandraHosts = cassandraHostConfigurator.buildCassandraHosts();
        Assert.assertEquals((long)1L, (long)cassandraHosts.length);
    }

    @Test
    public void testCassandraHostSetupSplit() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170,localhost:9171,localhost:9172");
        CassandraHost[] cassandraHosts = cassandraHostConfigurator.buildCassandraHosts();
        Assert.assertEquals((long)3L, (long)cassandraHosts.length);
        Assert.assertEquals((long)9172L, (long)cassandraHosts[2].getPort());
    }

    @Test
    public void testConfigValuesPropogated() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170,localhost:9171,localhost:9172");
        cassandraHostConfigurator.setMaxActive(20);
        cassandraHostConfigurator.setCassandraThriftSocketTimeout(3000);
        cassandraHostConfigurator.setMaxWaitTimeWhenExhausted(4000L);
        CassandraHost[] cassandraHosts = cassandraHostConfigurator.buildCassandraHosts();
        Assert.assertEquals((long)20L, (long)cassandraHosts[1].getMaxActive());
        Assert.assertEquals((long)20L, (long)cassandraHosts[0].getMaxActive());
        Assert.assertEquals((long)4000L, (long)cassandraHosts[1].getMaxWaitTimeWhenExhausted());
        Assert.assertEquals((long)3000L, (long)cassandraHosts[2].getCassandraThriftSocketTimeout());
        Assert.assertEquals((long)3000L, (long)cassandraHosts[0].getCassandraThriftSocketTimeout());
    }

    @Test
    public void testApplyConfig() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170");
        cassandraHostConfigurator.setMaxActive(15);
        cassandraHostConfigurator.setMaxConnectTimeMillis(30000L);
        cassandraHostConfigurator.setMaxLastSuccessTimeMillis(40000L);
        CassandraHost extraHost = new CassandraHost("localhost:9171");
        cassandraHostConfigurator.applyConfig(extraHost);
        Assert.assertEquals((long)15L, (long)extraHost.getMaxActive());
        Assert.assertEquals((long)30000L, (long)extraHost.getMaxConnectTimeMillis());
        Assert.assertEquals((long)40000L, (long)extraHost.getMaxLastSuccessTimeMillis());
    }

    @Test
    public void testHostnameOnlyDefaultPort() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost");
        CassandraHost[] cassandraHosts = cassandraHostConfigurator.buildCassandraHosts();
        Assert.assertEquals((long)9160L, (long)cassandraHosts[0].getPort());
    }

    @Test
    public void testHostnameOnlyDefaultPortMultipleHosts() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("h1,h2,h3:1111");
        CassandraHost[] cassandraHosts = cassandraHostConfigurator.buildCassandraHosts();
        Assert.assertEquals((long)9160L, (long)cassandraHosts[0].getPort());
        Assert.assertEquals((long)9160L, (long)cassandraHosts[1].getPort());
        Assert.assertEquals((long)1111L, (long)cassandraHosts[2].getPort());
    }

    @Test
    public void testConfiguratorPort() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost");
        cassandraHostConfigurator.setPort(9177);
        CassandraHost[] cassandraHosts = cassandraHostConfigurator.buildCassandraHosts();
        Assert.assertEquals((long)9177L, (long)cassandraHosts[0].getPort());
    }

    @Test
    public void testConfiguratorClockResolution() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost");
        class SequentialClockResolution
        implements ClockResolution {
            SequentialClockResolution() {
            }

            public long createClock() {
                return System.currentTimeMillis() * -1L;
            }
        }
        CassandraHostConfigurator.setClockResolution((ClockResolution)new SequentialClockResolution());
        Assert.assertNotSame((Object)CassandraHostConfigurator.DEF_CLOCK_RESOLUTION, (Object)cassandraHostConfigurator.getClockResolution());
    }

    @Test
    public void testSerialization() throws Exception {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9876");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(cassandraHostConfigurator);
        out.close();
        byte[] serializedByteArray = bos.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(serializedByteArray);
        ObjectInputStream in = new ObjectInputStream(bin);
        CassandraHostConfigurator cassandraHostConfiguratorDeserialized = (CassandraHostConfigurator)in.readObject();
    }

    @Test
    public void testSettingCorrectClientFactory() {
        CassandraHostConfigurator chc = new CassandraHostConfigurator("localhost");
        chc.setClientFactoryClass(HKerberosSecuredThriftClientFactoryImpl.class.getSimpleName());
        Assert.assertEquals((Object)chc.getClientFactoryClass(), HKerberosSecuredThriftClientFactoryImpl.class);
        chc.setClientFactoryClass(HThriftClientFactoryImpl.class.getCanonicalName());
        Assert.assertEquals((Object)chc.getClientFactoryClass(), HThriftClientFactoryImpl.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingNotFoundClientFactory() {
        CassandraHostConfigurator chc = new CassandraHostConfigurator("localhost");
        chc.setClientFactoryClass("NotARealClass");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingInvalidExistingClassClientFactory() {
        CassandraHostConfigurator chc = new CassandraHostConfigurator("localhost");
        chc.setClientFactoryClass(CassandraHostConfigurator.class.getCanonicalName());
    }
}

