/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.ClearCounterRow;
import me.prettyprint.cassandra.service.SliceCounterIterator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HCounterColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceCounterQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClearCounterRowTest
extends BaseEmbededServerSetupTest {
    private static final StringSerializer ss = new StringSerializer();
    private static final String cf = "Counter1";
    private static final String key = "key";
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setUp() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)ss);
    }

    @After
    public void tearDown() {
        this.keyspace = null;
        this.cluster = null;
    }

    @Test
    public void testClear() {
        long expected;
        HCounterColumn column;
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)ss);
        for (int i = 1; i <= 10; ++i) {
            mutator.addCounter((Object)key, cf, HFactory.createCounterColumn((String)("" + i), (long)i));
        }
        mutator.execute();
        SliceCounterQuery query = HFactory.createCounterSliceQuery((Keyspace)this.keyspace, (Serializer)ss, (Serializer)ss);
        query.setColumnFamily(cf);
        query.setKey((Object)key);
        SliceCounterIterator iterator = new SliceCounterIterator(query, null, (Object)null, false, 10);
        while (iterator.hasNext()) {
            column = iterator.next();
            expected = Long.parseLong((String)column.getName());
            Assert.assertEquals((long)expected, (long)column.getValue());
        }
        new ClearCounterRow(this.keyspace, (Serializer)ss, (Serializer)ss).setColumnFamily(cf).setRowKey((Object)key).clear();
        iterator = new SliceCounterIterator(query, null, (Object)null, false, 10);
        while (iterator.hasNext()) {
            column = iterator.next();
            expected = 0L;
            Assert.assertEquals((long)expected, (long)column.getValue());
        }
    }
}

