/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.UUID;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.ColumnFamilyRowCopy;
import me.prettyprint.cassandra.service.ColumnSliceIterator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnFamilyRowCopyTest
extends BaseEmbededServerSetupTest {
    private static final UUIDSerializer us = new UUIDSerializer();
    private static final ByteBufferSerializer bs = ByteBufferSerializer.get();
    private static final StringSerializer ss = new StringSerializer();
    private static final String CF = "Standard1";
    private static final String SOURCE_KEY = "source";
    private static final String DESTINATION_KEY = "destination";
    private Cluster cluster;
    private Keyspace keyspace;
    private int columns = 1000;

    @Before
    public void setUp() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)ss);
        for (int i = 0; i < this.columns; ++i) {
            m.addInsertion((Object)SOURCE_KEY, CF, HFactory.createColumn((Object)UUID.randomUUID(), (Object)String.valueOf(i), (Serializer)us, (Serializer)ss));
        }
        m.execute();
    }

    @After
    public void tearDown() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)ss);
        m.addDeletion((Object)SOURCE_KEY, CF);
        m.addDeletion((Object)DESTINATION_KEY, CF);
        m.execute();
    }

    @Test
    public void testCopy() {
        new ColumnFamilyRowCopy(this.keyspace, (Serializer)ss).setColumnFamily(CF).setRowKey((Object)SOURCE_KEY).setDestinationKey((Object)DESTINATION_KEY).setMutateInterval(150).copy();
        SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)ss, (Serializer)bs, (Serializer)ss).setKey((Object)DESTINATION_KEY).setColumnFamily(CF);
        ColumnSliceIterator it = new ColumnSliceIterator(query, bs.fromBytes(new byte[0]), bs.fromBytes(new byte[0]), false, 100);
        int total = 0;
        while (it.hasNext()) {
            it.next();
            ++total;
        }
        Assert.assertEquals((long)this.columns, (long)total);
    }
}

