/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.ColumnSliceIterator;
import me.prettyprint.cassandra.service.template.SliceFilter;
import me.prettyprint.cassandra.utils.TimeUUIDUtils;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnSliceIteratorTest
extends BaseEmbededServerSetupTest {
    private static final UUIDSerializer us = UUIDSerializer.get();
    private static final StringSerializer se = new StringSerializer();
    private static final String CF = "Standard1";
    private static final String KEY = "key";
    private static final ColumnSliceIterator.ColumnSliceFinish<UUID> FINISH = new ColumnSliceIterator.ColumnSliceFinish<UUID>(){

        public UUID function() {
            return TimeUUIDUtils.getUniqueTimeUUIDinMillis();
        }
    };
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setUp() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i = 0; i < 1000; ++i) {
            m.addInsertion((Object)KEY, CF, HFactory.createColumn((Object)TimeUUIDUtils.getUniqueTimeUUIDinMillis(), (Object)String.valueOf(i), (Serializer)us, (Serializer)se));
        }
        m.execute();
    }

    @After
    public void tearDown() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        m.addDeletion((Object)KEY, CF);
        m.execute();
    }

    @Test
    public void testIterator() {
        SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se).setKey((Object)KEY).setColumnFamily(CF);
        ColumnSliceIterator it = new ColumnSliceIterator(query, null, FINISH, false, 100);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            HColumn c = it.next();
            results.put(c.getName(), c.getValue());
        }
        Assert.assertEquals((long)1000L, (long)results.size());
    }

    @Test
    public void testModificationIterator() {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se).setKey((Object)KEY).setColumnFamily(CF);
        ColumnSliceIterator it = new ColumnSliceIterator(query, null, FINISH, false, 100);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            HColumn c = it.next();
            results.put(c.getName(), c.getValue());
            mutator.addDeletion((Object)KEY, CF, c.getName(), (Serializer)us);
            mutator.execute();
        }
        Assert.assertEquals((long)1000L, (long)results.size());
    }

    @Test
    public void testFilter() {
        this.cluster.truncate(this.keyspace.getKeyspaceName(), CF);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i = 0; i < 500; ++i) {
            m.addInsertion((Object)KEY, CF, HFactory.createColumn((Object)("a" + i), (Object)String.valueOf(i), (Serializer)se, (Serializer)se));
            m.addInsertion((Object)KEY, CF, HFactory.createColumn((Object)("b" + i), (Object)String.valueOf(i), (Serializer)se, (Serializer)se));
            m.addInsertion((Object)KEY, CF, HFactory.createColumn((Object)("c" + i), (Object)String.valueOf(i), (Serializer)se, (Serializer)se));
        }
        m.execute();
        SliceQuery query = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se).setKey((Object)KEY).setColumnFamily(CF);
        ColumnSliceIterator it = new ColumnSliceIterator(query, (Object)"a", (Object)"d", false, 2).setFilter((SliceFilter)new SliceFilter<HColumn<String, String>>(){

            public boolean accept(HColumn<String, String> column) {
                return !((String)column.getName()).startsWith("b");
            }
        });
        ArrayList<String> results = new ArrayList<String>(1000);
        while (it.hasNext()) {
            HColumn c = it.next();
            String name = (String)c.getName();
            Assert.assertFalse((boolean)name.equals("b"));
            results.add(name);
        }
        Assert.assertEquals((long)1000L, (long)results.size());
    }
}

