/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.KeyIterator;
import me.prettyprint.cassandra.service.StringKeyIterator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyIteratorTest
extends BaseEmbededServerSetupTest {
    private static final StringSerializer se = new StringSerializer();
    private static final IntegerSerializer is = IntegerSerializer.get();
    private static final String CF = "Standard1";
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
    }

    @After
    public void teardownCase() {
        this.keyspace = null;
        this.cluster = null;
    }

    @Test
    public void testIterator() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i = 1; i <= 9; ++i) {
            m.addInsertion((Object)("k" + i), CF, HFactory.createColumn((Object)new Integer(i), (Object)new Integer(i), (Serializer)is, (Serializer)is));
        }
        m.execute();
        this.assertKeys(5, "k5", null);
        this.assertKeys(9, null, null);
        this.assertKeys(7, null, "k7");
        this.assertStringKeys(5, "k5", null);
        this.assertStringKeys(9, null, null);
        this.assertStringKeys(7, null, "k7");
        this.assertKeys(5, "k5", 1);
        this.assertKeys(9, null, 2);
        this.assertKeys(9, null, 5);
        this.assertKeys(8, "k2", 7);
        this.assertKeys(7, "k3", 10);
    }

    private void assertKeys(int expected, String start, String end) {
        KeyIterator it = new KeyIterator.Builder(this.keyspace, CF, (Serializer)se).start((Object)start).end((Object)end).build();
        int tot = 0;
        for (String key : it) {
            ++tot;
        }
        Assert.assertEquals((long)expected, (long)tot);
    }

    private void assertStringKeys(int expected, String start, String end) {
        StringKeyIterator sk = new StringKeyIterator.Builder(this.keyspace, CF).start(start).end(end).build();
        int tot = 0;
        for (String key : sk) {
            ++tot;
        }
        Assert.assertEquals((long)expected, (long)tot);
    }

    private void assertKeys(int expected, String start, int count) {
        KeyIterator it = new KeyIterator.Builder(this.keyspace, CF, (Serializer)se).start((Object)start).maxRowCount(count).build();
        int tot = 0;
        for (String key : it) {
            ++tot;
        }
        Assert.assertEquals((long)expected, (long)tot);
    }
}

