/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.model.QuorumAllConsistencyLevelPolicy;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.BatchMutation;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.service.KeyspaceServiceImpl;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.cassandra.utils.StringUtils;
import me.prettyprint.hector.api.ConsistencyLevelPolicy;
import me.prettyprint.hector.api.HConsistencyLevel;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HNotFoundException;
import me.prettyprint.hector.api.exceptions.HPoolExhaustedException;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyspaceTest
extends BaseEmbededServerSetupTest {
    private KeyspaceService keyspace;
    private static final StringSerializer se = new StringSerializer();

    @Before
    public void setupCase() throws IllegalStateException, HPoolExhaustedException, Exception {
        super.setupClient();
        this.keyspace = new KeyspaceServiceImpl("Keyspace1", (ConsistencyLevelPolicy)new QuorumAllConsistencyLevelPolicy(), this.connectionManager, FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE);
    }

    @Test
    public void testInsertAndGetAndRemove() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, HNotFoundException, Exception {
        int i;
        ColumnPath cp = new ColumnPath("Standard1");
        cp.setColumn(StringUtils.bytes((String)"testInsertAndGetAndRemove"));
        for (i = 0; i < 100; ++i) {
            this.keyspace.insert("testInsertAndGetAndRemove_" + i, cp, StringSerializer.get().toByteBuffer("testInsertAndGetAndRemove_value_" + i));
        }
        for (i = 0; i < 100; ++i) {
            Column col = this.keyspace.getColumn("testInsertAndGetAndRemove_" + i, cp);
            Assert.assertNotNull((Object)col);
            String value = StringUtils.string((byte[])col.getValue());
            Assert.assertEquals((Object)("testInsertAndGetAndRemove_value_" + i), (Object)value);
        }
        for (i = 0; i < 100; ++i) {
            this.keyspace.remove("testInsertAndGetAndRemove_" + i, cp);
        }
        for (i = 0; i < 100; ++i) {
            try {
                this.keyspace.getColumn("testInsertAndGetAndRemove_" + i, cp);
                Assert.fail((String)"the value should already being deleted");
                continue;
            }
            catch (HNotFoundException hNotFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testInsertAndGetAndRemoveCounter() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, HNotFoundException, Exception {
        StringSerializer ss = StringSerializer.get();
        ColumnParent cp = new ColumnParent("Counter1");
        this.keyspace.addCounter("testInsertAndGetAndRemoveCounter_key1", cp, this.createCounterColumn("A", 5L));
        this.keyspace.addCounter("testInsertAndGetAndRemoveCounter_key1", cp, this.createCounterColumn("A", -1L));
        this.keyspace.addCounter("testInsertAndGetAndRemoveCounter_key1", cp, this.createCounterColumn("B", 10L));
        ColumnPath cph = new ColumnPath("Counter1");
        cph.setColumn(ss.toByteBuffer("A"));
        CounterColumn counter = this.keyspace.getCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((long)4L, (long)counter.value);
        cph.setColumn(ss.toByteBuffer("B"));
        counter = this.keyspace.getCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        Assert.assertNotNull((Object)counter);
        Assert.assertEquals((long)10L, (long)counter.value);
        this.keyspace.removeCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        try {
            this.keyspace.getCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        }
        catch (HNotFoundException e) {
            // empty catch block
        }
        cph.setColumn(ss.toByteBuffer("A"));
        counter = this.keyspace.getCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        Assert.assertNotNull((Object)counter);
        cph.column = null;
        this.keyspace.removeCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        try {
            cph.setColumn(ss.toByteBuffer("A"));
            counter = this.keyspace.getCounter("testInsertAndGetAndRemoveCounter_key1", cph);
        }
        catch (HNotFoundException e) {
            // empty catch block
        }
    }

    private CounterColumn createCounterColumn(String name, long value) {
        CounterColumn cc = new CounterColumn();
        cc.setName(StringSerializer.get().toByteBuffer(name));
        cc.setValue(value);
        return cc;
    }

    @Test
    public void testInsertSuper() throws IllegalArgumentException, NoSuchElementException, IllegalStateException, HNotFoundException, Exception {
        ColumnParent columnParent = new ColumnParent("Super1");
        columnParent.setSuper_column(StringSerializer.get().toByteBuffer("testInsertSuper_super"));
        Column column = new Column(StringSerializer.get().toByteBuffer("testInsertSuper_column"));
        column.setValue(StringSerializer.get().toByteBuffer("testInsertSuper_value"));
        column.setTimestamp(this.connectionManager.createClock());
        this.keyspace.insert(StringSerializer.get().toByteBuffer("testInsertSuper_key"), columnParent, column);
        column.setName(StringSerializer.get().toByteBuffer("testInsertSuper_column2"));
        this.keyspace.insert(StringSerializer.get().toByteBuffer("testInsertSuper_key"), columnParent, column);
        ColumnPath cp2 = new ColumnPath("Super1");
        cp2.setSuper_column(StringUtils.bytes((String)"testInsertSuper_super"));
        SuperColumn sc = this.keyspace.getSuperColumn("testInsertSuper_key", cp2);
        Assert.assertNotNull((Object)sc);
        Assert.assertEquals((Object)"testInsertSuper_super", (Object)StringUtils.string((byte[])sc.getName()));
        Assert.assertEquals((long)2L, (long)sc.getColumns().size());
        Assert.assertEquals((Object)"testInsertSuper_value", (Object)StringUtils.string((byte[])((Column)sc.getColumns().get(0)).getValue()));
        this.keyspace.remove("testInsertSuper_super", cp2);
    }

    @Test
    public void testBatchInsertColumn() throws HectorException {
    }

    @Test
    public void testBatchMutate() throws HectorException {
        ColumnPath cp;
        int i;
        HashMap outerMutationMap = new HashMap();
        for (i = 0; i < 10; ++i) {
            HashMap mutationMap = new HashMap();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(10);
            for (int j = 0; j < 10; ++j) {
                Column col = new Column(StringSerializer.get().toByteBuffer("testBatchMutateColumn_" + j));
                col.setValue(StringSerializer.get().toByteBuffer("testBatchMutateColumn_value_" + j));
                col.setTimestamp(this.connectionManager.createClock());
                ColumnOrSuperColumn cosc = new ColumnOrSuperColumn();
                cosc.setColumn(col);
                Mutation mutation = new Mutation();
                mutation.setColumn_or_supercolumn(cosc);
                mutations.add(mutation);
            }
            mutationMap.put("Standard1", mutations);
            outerMutationMap.put("testBatchMutateColumn_" + i, mutationMap);
        }
        this.keyspace.batchMutate(se.toBytesMap(outerMutationMap));
        outerMutationMap.clear();
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                cp = new ColumnPath("Standard1");
                cp.setColumn(StringUtils.bytes((String)("testBatchMutateColumn_" + j)));
                Column col = this.keyspace.getColumn("testBatchMutateColumn_" + i, cp);
                Assert.assertNotNull((Object)col);
                String value = StringUtils.string((byte[])col.getValue());
                Assert.assertEquals((Object)("testBatchMutateColumn_value_" + j), (Object)value);
            }
        }
        for (i = 0; i < 10; ++i) {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(10);
            HashMap<String, ArrayList<Mutation>> mutationMap = new HashMap<String, ArrayList<Mutation>>();
            SlicePredicate slicePredicate = new SlicePredicate();
            for (int j = 0; j < 10; ++j) {
                slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("testBatchMutateColumn_" + j));
            }
            Mutation mutation = new Mutation();
            Deletion deletion = new Deletion().setTimestamp(this.connectionManager.createClock());
            deletion.setPredicate(slicePredicate);
            mutation.setDeletion(deletion);
            mutations.add(mutation);
            mutationMap.put("Standard1", mutations);
            outerMutationMap.put("testBatchMutateColumn_" + i, mutationMap);
        }
        this.keyspace.batchMutate(se.toBytesMap(outerMutationMap));
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                cp = new ColumnPath("Standard1");
                cp.setColumn(StringUtils.bytes((String)("testBatchMutateColumn_" + j)));
                try {
                    this.keyspace.getColumn("testBatchMutateColumn_" + i, cp);
                    Assert.fail();
                    continue;
                }
                catch (HNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testBatchMutateBatchMutation() throws HectorException {
        ColumnPath cp;
        int j;
        int i;
        BatchMutation batchMutation = new BatchMutation((Serializer)StringSerializer.get());
        List<String> columnFamilies = Arrays.asList("Standard1");
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                Column col = new Column(StringSerializer.get().toByteBuffer("testBatchMutateColumn_" + j));
                col.setValue(StringSerializer.get().toByteBuffer("testBatchMutateColumn_value_" + j));
                col.setTimestamp(this.connectionManager.createClock());
                batchMutation.addInsertion((Object)("testBatchMutateColumn_" + i), columnFamilies, col);
            }
        }
        this.keyspace.batchMutate(batchMutation);
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                cp = new ColumnPath("Standard1");
                cp.setColumn(StringUtils.bytes((String)("testBatchMutateColumn_" + j)));
                Column col = this.keyspace.getColumn("testBatchMutateColumn_" + i, cp);
                Assert.assertNotNull((Object)col);
                String value = StringUtils.string((byte[])col.getValue());
                Assert.assertEquals((Object)("testBatchMutateColumn_value_" + j), (Object)value);
            }
        }
        batchMutation = new BatchMutation((Serializer)StringSerializer.get());
        for (i = 0; i < 10; ++i) {
            SlicePredicate slicePredicate = new SlicePredicate();
            for (int j2 = 0; j2 < 10; ++j2) {
                slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("testBatchMutateColumn_" + j2));
            }
            Deletion deletion = new Deletion().setTimestamp(this.connectionManager.createClock());
            deletion.setPredicate(slicePredicate);
            batchMutation.addDeletion((Object)("testBatchMutateColumn_" + i), columnFamilies, deletion);
        }
        this.keyspace.batchMutate(batchMutation);
        for (i = 0; i < 10; ++i) {
            for (int j3 = 0; j3 < 10; ++j3) {
                cp = new ColumnPath("Standard1");
                cp.setColumn(StringUtils.bytes((String)("testBatchMutateColumn_" + j3)));
                try {
                    this.keyspace.getColumn("testBatchMutateColumn_" + i, cp);
                    Assert.fail();
                    continue;
                }
                catch (HNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testBatchUpdateInsertAndDelOnSame() throws HectorException {
        ColumnPath sta1 = new ColumnPath("Standard1");
        sta1.setColumn(StringUtils.bytes((String)"deleteThroughInserBatch_col"));
        this.keyspace.insert("deleteThroughInserBatch_key", sta1, StringSerializer.get().toByteBuffer("deleteThroughInserBatch_val"));
        Column found = this.keyspace.getColumn("deleteThroughInserBatch_key", sta1);
        Assert.assertNotNull((Object)found);
        BatchMutation batchMutation = new BatchMutation((Serializer)StringSerializer.get());
        List<String> columnFamilies = Arrays.asList("Standard1");
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                Column col = new Column(StringSerializer.get().toByteBuffer("testBatchMutateColumn_" + j));
                col.setValue(StringSerializer.get().toByteBuffer("testBatchMutateColumn_value_" + j));
                col.setTimestamp(this.connectionManager.createClock());
                batchMutation.addInsertion((Object)("testBatchMutateColumn_" + i), columnFamilies, col);
            }
        }
        SlicePredicate slicePredicate = new SlicePredicate();
        slicePredicate.addToColumn_names(StringSerializer.get().toByteBuffer("deleteThroughInserBatch_col"));
        Deletion deletion = new Deletion().setTimestamp(this.connectionManager.createClock());
        deletion.setPredicate(slicePredicate);
        batchMutation.addDeletion((Object)"deleteThroughInserBatch_key", columnFamilies, deletion);
        this.keyspace.batchMutate(batchMutation);
        try {
            this.keyspace.getColumn("deleteThroughInserBatch_key", sta1);
            Assert.fail((String)"Should not have found a value here");
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                ColumnPath cp = new ColumnPath("Standard1");
                cp.setColumn(StringUtils.bytes((String)("testBatchMutateColumn_" + j)));
                Column col = this.keyspace.getColumn("testBatchMutateColumn_" + i, cp);
                Assert.assertNotNull((Object)col);
                String value = StringUtils.string((byte[])col.getValue());
                Assert.assertEquals((Object)("testBatchMutateColumn_value_" + j), (Object)value);
            }
        }
    }

    @Test
    public void testGetSuperColumn() throws HectorException {
    }

    @Test
    public void testGetSlice() throws HectorException {
        ArrayList<String> columnnames = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            ColumnPath cp = new ColumnPath("Standard1");
            cp.setColumn(StringUtils.bytes((String)("testGetSlice_" + i)));
            this.keyspace.insert("testGetSlice", cp, StringSerializer.get().toByteBuffer("testGetSlice_Value_" + i));
            columnnames.add("testGetSlice_" + i);
        }
        ColumnParent clp = new ColumnParent("Standard1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        List cols = this.keyspace.getSlice("testGetSlice", clp, sp);
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((long)100L, (long)cols.size());
        Collections.sort(columnnames);
        ArrayList<String> gotlist = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            gotlist.add(StringUtils.string((byte[])((Column)cols.get(i)).getName()));
        }
        Assert.assertEquals(columnnames, gotlist);
        ColumnPath cp = new ColumnPath("Standard1");
        this.keyspace.remove("testGetSlice_", cp);
        this.keyspace.remove("testGetSlice", cp);
    }

    @Test
    public void testGetCounterSlice() throws HectorException {
        ArrayList<ByteBuffer> columnnames = new ArrayList<ByteBuffer>(50);
        StringSerializer ss = StringSerializer.get();
        for (int i = 0; i < 100; ++i) {
            ColumnParent cp = new ColumnParent("Counter1");
            this.keyspace.addCounter("testGetCounterSlice", cp, this.createCounterColumn("testGetCounterSlice_" + i, i));
            if (i >= 50) continue;
            columnnames.add(ss.toByteBuffer("testGetCounterSlice_" + i));
        }
        ColumnParent clp = new ColumnParent("Counter1");
        SlicePredicate sp = new SlicePredicate();
        sp.setColumn_names(columnnames);
        List cols = this.keyspace.getCounterSlice("testGetCounterSlice", clp, sp);
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((long)50L, (long)cols.size());
        Collections.sort(columnnames);
        ArrayList<ByteBuffer> gotlist = new ArrayList<ByteBuffer>(50);
        for (int i = 0; i < 50; ++i) {
            CounterColumn cc = (CounterColumn)cols.get(i);
            gotlist.add(cc.name.duplicate());
            Assert.assertEquals((long)this.getValueFromName(ss.fromByteBuffer(cc.name.duplicate())), (long)cc.getValue());
        }
        Assert.assertEquals(columnnames, gotlist);
        ColumnPath cp = new ColumnPath("Counter1");
        this.keyspace.removeCounter("testGetCounterSlice", cp);
    }

    private long getValueFromName(String counterName) {
        return Long.valueOf(counterName.substring(counterName.indexOf("_") + 1));
    }

    @Test
    public void testGetSuperSlice() throws HectorException {
        for (int i = 0; i < 100; ++i) {
            ColumnPath cp = new ColumnPath("Super1");
            cp.setSuper_column(StringUtils.bytes((String)"SuperColumn_1"));
            cp.setColumn(StringUtils.bytes((String)("testGetSuperSlice_" + i)));
            ColumnPath cp2 = new ColumnPath("Super1");
            cp2.setSuper_column(StringUtils.bytes((String)"SuperColumn_2"));
            cp2.setColumn(StringUtils.bytes((String)("testGetSuperSlice_" + i)));
            this.keyspace.insert("testGetSuperSlice", cp, StringSerializer.get().toByteBuffer("testGetSuperSlice_Value_" + i));
            this.keyspace.insert("testGetSuperSlice", cp2, StringSerializer.get().toByteBuffer("testGetSuperSlice_Value_" + i));
        }
        ColumnParent clp = new ColumnParent("Super1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        List cols = this.keyspace.getSuperSlice("testGetSuperSlice", clp, sp);
        Assert.assertNotNull((Object)cols);
        Assert.assertEquals((long)2L, (long)cols.size());
        ColumnPath cp = new ColumnPath("Super1");
        this.keyspace.remove("testGetSuperSlice", cp);
    }

    @Test
    public void testMultigetColumn() throws HectorException {
        int i;
        ColumnPath cp = new ColumnPath("Standard1");
        cp.setColumn(StringUtils.bytes((String)"testMultigetColumn"));
        ArrayList<String> keys = new ArrayList<String>(100);
        for (i = 0; i < 100; ++i) {
            this.keyspace.insert("testMultigetColumn_" + i, cp, StringSerializer.get().toByteBuffer("testMultigetColumn_value_" + i));
            keys.add("testMultigetColumn_" + i);
        }
        for (i = 0; i < 100; ++i) {
            this.keyspace.remove("testMultigetColumn_" + i, cp);
        }
    }

    @Test
    public void testMultigetSuperColumn() throws HectorException {
    }

    @Test
    public void testMultigetSlice() throws HectorException {
        int i;
        ColumnPath cp = new ColumnPath("Standard1");
        cp.setColumn(StringUtils.bytes((String)"testMultigetSlice"));
        ArrayList<String> keys = new ArrayList<String>(100);
        for (int i2 = 0; i2 < 100; ++i2) {
            this.keyspace.insert("testMultigetSlice_" + i2, cp, StringSerializer.get().toByteBuffer("testMultigetSlice_value_" + i2));
            keys.add("testMultigetSlice_" + i2);
        }
        ColumnParent clp = new ColumnParent("Standard1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        Map ms = se.fromBytesMap(this.keyspace.multigetSlice(se.toBytesList(keys), clp, sp));
        for (i = 0; i < 100; ++i) {
            List cl = (List)ms.get(keys.get(i));
            Assert.assertNotNull((Object)cl);
            Assert.assertEquals((long)1L, (long)cl.size());
            Assert.assertTrue((boolean)StringUtils.string((byte[])((Column)cl.get(0)).getValue()).startsWith("testMultigetSlice_"));
        }
        for (i = 0; i < 100; ++i) {
            this.keyspace.remove("testMultigetSlice_" + i, cp);
        }
    }

    @Test
    public void testMultigetSlice_1() throws HectorException {
    }

    @Test
    public void testMultigetSuperSlice() throws HectorException {
    }

    @Test
    public void testGetCount() throws HectorException {
        ColumnPath cp;
        for (int i = 0; i < 100; ++i) {
            cp = new ColumnPath("Standard1");
            cp.setColumn(StringUtils.bytes((String)("testInsertAndGetAndRemove_" + i)));
            this.keyspace.insert("testGetCount", cp, StringSerializer.get().toByteBuffer("testInsertAndGetAndRemove_value_" + i));
        }
        ColumnParent clp = new ColumnParent("Standard1");
        cp = new ColumnPath("Standard1");
        this.keyspace.remove("testGetCount", cp);
    }

    @Test
    public void testGetRangeSlice() throws HectorException {
        for (int i = 0; i < 10; ++i) {
            ColumnPath cp = new ColumnPath("Standard1");
            cp.setColumn(StringUtils.bytes((String)("testGetRangeSlice_" + i)));
            this.keyspace.insert("testGetRangeSlice0", cp, StringSerializer.get().toByteBuffer("testGetRangeSlice_Value_" + i));
            this.keyspace.insert("testGetRangeSlice1", cp, StringSerializer.get().toByteBuffer("testGetRangeSlice_Value_" + i));
            this.keyspace.insert("testGetRangeSlice2", cp, StringSerializer.get().toByteBuffer("testGetRangeSlice_Value_" + i));
        }
        ColumnParent clp = new ColumnParent("Standard1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        ColumnPath cp = new ColumnPath("Standard1");
        this.keyspace.remove("testGetRanageSlice0", cp);
        this.keyspace.remove("testGetRanageSlice1", cp);
        this.keyspace.remove("testGetRanageSlice2", cp);
    }

    @Test
    public void testGetRangeSlices() throws HectorException {
        for (int i = 0; i < 10; ++i) {
            ColumnPath cp = new ColumnPath("Standard1");
            cp.setColumn(StringUtils.bytes((String)("testGetRangeSlices_" + i)));
            this.keyspace.insert("testGetRangeSlices0", cp, StringSerializer.get().toByteBuffer("testGetRangeSlices_Value_" + i));
            this.keyspace.insert("testGetRangeSlices1", cp, StringSerializer.get().toByteBuffer("testGetRangeSlices_Value_" + i));
            this.keyspace.insert("testGetRangeSlices2", cp, StringSerializer.get().toByteBuffer("testGetRangeSlices_Value_" + i));
        }
        ColumnParent clp = new ColumnParent("Standard1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        KeyRange range = new KeyRange();
        range.setStart_key("".getBytes());
        range.setEnd_key("".getBytes());
        Map keySlices = se.fromBytesMap(this.keyspace.getRangeSlices(clp, sp, range));
        Assert.assertNotNull((Object)keySlices);
        Assert.assertNotNull((String)"testGetRangeSlices1 is null", keySlices.get("testGetRangeSlices1"));
        Assert.assertEquals((Object)"testGetRangeSlices_Value_0", (Object)StringUtils.string((byte[])((Column)((List)keySlices.get("testGetRangeSlices1")).get(0)).getValue()));
        Assert.assertEquals((long)10L, (long)((List)keySlices.get("testGetRangeSlices1")).size());
        ColumnPath cp = new ColumnPath("Standard1");
        this.keyspace.remove("testGetRanageSlices0", cp);
        this.keyspace.remove("testGetRanageSlices1", cp);
        this.keyspace.remove("testGetRanageSlices2", cp);
    }

    @Test
    public void testGetSuperRangeSlice() throws HectorException {
        for (int i = 0; i < 10; ++i) {
            ColumnPath cp = new ColumnPath("Super1");
            cp.setSuper_column(StringUtils.bytes((String)"SuperColumn_1"));
            cp.setColumn(StringUtils.bytes((String)("testGetSuperRangeSlice_" + i)));
            this.keyspace.insert("testGetSuperRangeSlice0", cp, StringSerializer.get().toByteBuffer("testGetSuperRangeSlice_Value_" + i));
            this.keyspace.insert("testGetSuperRangeSlice1", cp, StringSerializer.get().toByteBuffer("testGetSuperRangeSlice_Value_" + i));
        }
        ColumnParent clp = new ColumnParent("Super1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        ColumnPath cp = new ColumnPath("Super1");
        this.keyspace.remove("testGetSuperRangeSlice0", cp);
        this.keyspace.remove("testGetSuperRangeSlice1", cp);
    }

    @Test
    public void testGetSuperRangeSlices() throws HectorException {
        for (int i = 0; i < 10; ++i) {
            ColumnPath cp = new ColumnPath("Super1");
            cp.setSuper_column(StringUtils.bytes((String)"SuperColumn_1"));
            cp.setColumn(StringUtils.bytes((String)("testGetSuperRangeSlices_" + i)));
            this.keyspace.insert("testGetSuperRangeSlices0", cp, StringSerializer.get().toByteBuffer("testGetSuperRangeSlices_Value_" + i));
            this.keyspace.insert("testGetSuperRangeSlices1", cp, StringSerializer.get().toByteBuffer("testGetSuperRangeSlices_Value_" + i));
        }
        ColumnParent clp = new ColumnParent("Super1");
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        KeyRange range = new KeyRange();
        range.setStart_key("".getBytes());
        range.setEnd_key("".getBytes());
        Map keySlices = se.fromBytesMap(this.keyspace.getSuperRangeSlices(clp, sp, range));
        Assert.assertNotNull((Object)keySlices);
        Assert.assertNotNull((String)"testGetSuperRangSlices0 is null", keySlices.get("testGetSuperRangeSlices0"));
        Assert.assertEquals((Object)"testGetSuperRangeSlices_Value_0", (Object)StringUtils.string((byte[])((Column)((SuperColumn)((List)keySlices.get("testGetSuperRangeSlices0")).get(0)).getColumns().get(0)).getValue()));
        Assert.assertEquals((long)1L, (long)((List)keySlices.get("testGetSuperRangeSlices1")).size());
        Assert.assertEquals((long)10L, (long)((SuperColumn)((List)keySlices.get("testGetSuperRangeSlices1")).get(0)).getColumns().size());
        ColumnPath cp = new ColumnPath("Super1");
        this.keyspace.remove("testGetSuperRangeSlices0", cp);
        this.keyspace.remove("testGetSuperRangeSlices1", cp);
    }

    @Test
    public void testMultigetCount() {
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 25; ++i) {
                ColumnPath cp = new ColumnPath("Standard1");
                cp.setColumn(StringSerializer.get().toByteBuffer("testMultigetCount_column_" + i));
                this.keyspace.insert("testMultigetCount_key_" + j, cp, StringSerializer.get().toByteBuffer("testMultigetCount_value_" + i));
            }
            if (j % 2 != 0) continue;
            keys.add(StringSerializer.get().toByteBuffer("testMultigetCount_key_" + j));
        }
        ColumnParent clp = new ColumnParent("Standard1");
        SlicePredicate slicePredicate = new SlicePredicate();
        SliceRange sr = new SliceRange(ByteBuffer.wrap(new byte[0]), ByteBuffer.wrap(new byte[0]), false, 150);
        slicePredicate.setSlice_range(sr);
        Map counts = this.keyspace.multigetCount(keys, clp, slicePredicate);
        Assert.assertEquals((long)5L, (long)counts.size());
        Assert.assertEquals((Object)new Integer(25), counts.entrySet().iterator().next().getValue());
        slicePredicate.setSlice_range(new SliceRange(StringSerializer.get().toByteBuffer(""), StringSerializer.get().toByteBuffer(""), false, 5));
        counts = this.keyspace.multigetCount(keys, clp, slicePredicate);
        Assert.assertEquals((long)5L, (long)counts.size());
        Assert.assertEquals((Object)new Integer(5), counts.entrySet().iterator().next().getValue());
    }

    @Test
    public void testGetConsistencyLevel() {
        Assert.assertEquals((Object)HConsistencyLevel.QUORUM, (Object)this.keyspace.getConsistencyLevel(OperationType.READ));
    }

    @Test
    public void testGetKeyspaceName() {
        Assert.assertEquals((Object)"Keyspace1", (Object)this.keyspace.getName());
    }
}

