/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.ColumnSliceIterator;
import me.prettyprint.cassandra.service.MultigetSliceIterator;
import me.prettyprint.cassandra.utils.TimeUUIDUtils;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiGetSliceIteratorTest
extends BaseEmbededServerSetupTest {
    private static final UUIDSerializer us = UUIDSerializer.get();
    private static final StringSerializer se = new StringSerializer();
    private static final String CF = "Standard1";
    private static final String KEY = "key";
    private static final ColumnSliceIterator.ColumnSliceFinish<UUID> FINISH = new ColumnSliceIterator.ColumnSliceFinish<UUID>(){

        public UUID function() {
            return TimeUUIDUtils.getUniqueTimeUUIDinMillis();
        }
    };
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setUp() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int j = 0; j < 100; ++j) {
            for (int i = 0; i < 1000; ++i) {
                m.addInsertion((Object)(KEY + j), CF, HFactory.createColumn((Object)TimeUUIDUtils.getUniqueTimeUUIDinMillis(), (Object)String.valueOf(i), (Serializer)us, (Serializer)se));
            }
        }
        m.execute();
    }

    @After
    public void tearDown() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int j = 0; j < 100; ++j) {
            m.addDeletion((Object)(KEY + j), CF);
        }
        m.execute();
    }

    @Test
    public void testIterator() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        MultigetSliceIterator it = new MultigetSliceIterator(false, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, 1, 10, 1000);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
            }
        }
        Assert.assertEquals((long)100000L, (long)results.size());
    }

    @Test
    public void testModificationIterator() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        MultigetSliceIterator it = new MultigetSliceIterator(false, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, 1, 10, 1000);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
                mutator.addDeletion(r.getKey(), CF, c.getName(), (Serializer)us);
                mutator.execute();
            }
        }
        Assert.assertEquals((long)100000L, (long)results.size());
    }

    @Test
    public void testGetHostsUsed() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        MultigetSliceIterator it = new MultigetSliceIterator(false, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, 1, 10, 10);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
            }
        }
        Assert.assertEquals((Object)"127.0.0.1(127.0.0.1):9170", (Object)it.getHostsUsed());
    }

    @Test
    public void testGetThreadCountUsed() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        Random randomGen = new Random();
        int threadCount = randomGen.nextInt(8);
        int maxRowCountPerQuery = randomGen.nextInt(50);
        int maxColumnCountPerRow = 100;
        MultigetSliceIterator it = new MultigetSliceIterator(false, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, threadCount, maxRowCountPerQuery, maxColumnCountPerRow);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
            }
        }
        if (it.getThreadCountUsed() <= threadCount) {
            Assert.assertTrue((String)("Threads used:" + it.getThreadCountUsed()), (boolean)true);
        } else {
            Assert.assertFalse((String)"Threads used count is more than maxThreadCount specified", (boolean)true);
        }
    }

    @Test
    public void testGetRowCountPerQueryUsed() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        Random randomGen = new Random();
        int threadCount = randomGen.nextInt(8) + 1;
        int maxRowCountPerQuery = randomGen.nextInt(50) + 1;
        int maxColumnCountPerRow = 100;
        MultigetSliceIterator it = new MultigetSliceIterator(false, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, threadCount, maxRowCountPerQuery, maxColumnCountPerRow);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
            }
        }
        if (it.getRowCountPerQueryUsed() <= maxRowCountPerQuery) {
            Assert.assertTrue((String)("RowCountPerQueryUsed:" + it.getRowCountPerQueryUsed()), (boolean)true);
        } else {
            Assert.assertFalse((String)"getRowCountPerQueryUsed() is more than specified parameter maxRowCountPerQuery", (boolean)true);
        }
    }

    @Test
    public void testIteratorWithoutRowKeyLimit() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        int maxColumnCountPerRow = 100;
        MultigetSliceIterator it = new MultigetSliceIterator(false, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, maxColumnCountPerRow);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
            }
        }
        if (it.getRowCountPerQueryUsed() == KEYS.size()) {
            Assert.assertTrue((String)"Queried all rowkeys at once", (boolean)true);
        } else {
            Assert.assertFalse((String)"Did not query all keys at once when no maxRowCountPerQuery is specified", (boolean)true);
        }
    }

    public void testIteratorWithoutThreading() {
        LinkedList<String> KEYS = new LinkedList<String>();
        for (int j = 0; j < 100; ++j) {
            KEYS.add(KEY + j);
        }
        Random randomGen = new Random();
        int maxRowCountPerQuery = randomGen.nextInt(50) + 1;
        int maxColumnCountPerRow = 100;
        MultigetSliceIterator it = new MultigetSliceIterator(false, maxRowCountPerQuery, this.keyspace, (Serializer)se, (Serializer)us, (Serializer)se, CF, KEYS, null, null, maxColumnCountPerRow);
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        while (it.hasNext()) {
            Row r = it.next();
            for (HColumn c : r.getColumnSlice().getColumns()) {
                results.put(c.getName(), c.getValue());
            }
        }
        if (it.getThreadCountUsed() == 0 && it.getRowCountPerQueryUsed() <= maxRowCountPerQuery) {
            Assert.assertTrue((String)"No Threading", (boolean)true);
        } else {
            Assert.assertFalse((String)"Either using threads when no thread count is specified or not respecting maxRowCountPerQuery parameter", (boolean)true);
        }
    }
}

