/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.RangeSlicesIterator;
import me.prettyprint.cassandra.service.template.SliceFilter;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RangeSlicesIteratorTest
extends BaseEmbededServerSetupTest {
    private static final StringSerializer se = new StringSerializer();
    private static final IntegerSerializer is = IntegerSerializer.get();
    private static final String CF = "Standard1";
    private static Cluster cluster;
    private static Keyspace keyspace;

    @BeforeClass
    public static void setupClass() {
        cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)cluster);
    }

    @AfterClass
    public static void teardownClass() {
        keyspace = null;
        cluster = null;
    }

    @Before
    public void setupCase() {
        Mutator m = HFactory.createMutator((Keyspace)keyspace, (Serializer)se);
        for (int i = 1; i <= 21; ++i) {
            m.addInsertion((Object)("k" + i), CF, HFactory.createColumn((Object)new Integer(i), (Object)new Integer(i), (Serializer)is, (Serializer)is));
        }
        m.execute();
    }

    @Test
    public void testIterator() {
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)se, (Serializer)is, (Serializer)is);
        query.setColumnFamily(CF);
        query.setRange(null, null, false, 10);
        this.assertKeys(query, 3, null, "k11", null);
        this.assertKeys(query, 10, "k2", null, null);
        this.assertKeys(query, 21, null, null, null);
    }

    @Test
    public void testFilter() {
        RangeSlicesQuery query = HFactory.createRangeSlicesQuery((Keyspace)keyspace, (Serializer)se, (Serializer)is, (Serializer)is);
        query.setColumnFamily(CF);
        query.setRange(null, null, false, 10);
        SliceFilter<Row<String, Integer, Integer>> filter = new SliceFilter<Row<String, Integer, Integer>>(){

            public boolean accept(Row<String, Integer, Integer> row) {
                return Integer.parseInt(((String)row.getKey()).replaceAll("^k", "")) < 10;
            }
        };
        this.assertKeys(query, 9, null, null, filter);
    }

    private void assertKeys(RangeSlicesQuery query, int expected, String start, String end, SliceFilter<Row<String, Integer, Integer>> filter) {
        RangeSlicesIterator iterator = new RangeSlicesIterator(query, (Object)start, (Object)end).setFilter(filter);
        int total = 0;
        while (iterator.hasNext()) {
            iterator.next().getKey();
            ++total;
        }
        Assert.assertEquals((long)expected, (long)total);
    }
}

