/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.SliceCounterIterator;
import me.prettyprint.cassandra.service.template.SliceFilter;
import me.prettyprint.cassandra.utils.TimeUUIDUtils;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HCounterColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceCounterQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SliceCounterIteratorTest
extends BaseEmbededServerSetupTest {
    private static final UUIDSerializer us = UUIDSerializer.get();
    private static final StringSerializer se = new StringSerializer();
    private static final String CF = "Counter1";
    private static final String KEY = "key";
    private static final SliceCounterIterator.SliceCounterFinish<UUID> FINISH = new SliceCounterIterator.SliceCounterFinish<UUID>(){

        public UUID function() {
            return TimeUUIDUtils.getUniqueTimeUUIDinMillis();
        }
    };
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setUp() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i = 0; i < 1000; ++i) {
            m.addCounter((Object)KEY, CF, HFactory.createCounterColumn((Object)TimeUUIDUtils.getUniqueTimeUUIDinMillis(), (long)1L, (Serializer)us));
        }
        m.execute();
    }

    @After
    public void tearDown() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        m.addDeletion((Object)KEY, CF);
        m.execute();
    }

    @Test
    public void testIterator() {
        SliceCounterQuery query = HFactory.createCounterSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)us).setKey((Object)KEY).setColumnFamily(CF);
        SliceCounterIterator it = new SliceCounterIterator(query, null, FINISH, false, 100);
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        while (it.hasNext()) {
            HCounterColumn c = it.next();
            results.put(c.getName(), c.getValue());
        }
        Assert.assertEquals((long)1000L, (long)results.size());
    }

    @Test
    public void testModificationIterator() {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        SliceCounterQuery query = HFactory.createCounterSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)us).setKey((Object)KEY).setColumnFamily(CF);
        SliceCounterIterator it = new SliceCounterIterator(query, null, FINISH, false, 100);
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        while (it.hasNext()) {
            HCounterColumn c = it.next();
            results.put(c.getName(), c.getValue());
            mutator.addDeletion((Object)KEY, CF, c.getName(), (Serializer)us);
            mutator.execute();
        }
        Assert.assertEquals((long)1000L, (long)results.size());
    }

    @Test
    public void testFilter() {
        this.cluster.truncate(this.keyspace.getKeyspaceName(), CF);
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i = 0; i < 500; ++i) {
            m.addCounter((Object)KEY, CF, HFactory.createCounterColumn((Object)("a" + i), (long)1L, (Serializer)se));
            m.addCounter((Object)KEY, CF, HFactory.createCounterColumn((Object)("b" + i), (long)1L, (Serializer)se));
            m.addCounter((Object)KEY, CF, HFactory.createCounterColumn((Object)("c" + i), (long)1L, (Serializer)se));
        }
        m.execute();
        SliceCounterQuery query = HFactory.createCounterSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se).setKey((Object)KEY).setColumnFamily(CF);
        SliceCounterIterator it = new SliceCounterIterator(query, (Object)"a", (Object)"d", false, 100).setFilter((SliceFilter)new SliceFilter<HCounterColumn<String>>(){

            public boolean accept(HCounterColumn<String> column) {
                return !((String)column.getName()).startsWith("b");
            }
        });
        ArrayList<String> results = new ArrayList<String>(1000);
        while (it.hasNext()) {
            HCounterColumn c = it.next();
            String name = (String)c.getName();
            Assert.assertFalse((boolean)name.equals("b"));
            results.add(name);
        }
        Assert.assertEquals((long)1000L, (long)results.size());
    }
}

