/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.service.template.BaseColumnFamilyTemplateTest;
import me.prettyprint.cassandra.service.template.ColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ColumnFamilyRowMapper;
import me.prettyprint.cassandra.service.template.ColumnFamilyUpdater;
import me.prettyprint.cassandra.service.template.IndexedSlicesPredicate;
import me.prettyprint.cassandra.service.template.MappedColumnFamilyResult;
import me.prettyprint.cassandra.service.template.ThriftColumnFamilyTemplate;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import org.apache.cassandra.thrift.IndexOperator;
import org.junit.Assert;
import org.junit.Test;

public class ColumnFamilyTemplateTest
extends BaseColumnFamilyTemplateTest {
    @Test
    public void testCreateSelect() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"key1");
        updater.setString((Object)"column1", "value1");
        template.update(updater);
        template.addColumn((Object)"column1", (Serializer)se);
        ColumnFamilyResult wrapper = template.queryColumns((Object)"key1");
        Assert.assertEquals((Object)"value1", (Object)wrapper.getString((Object)"column1"));
    }

    @Test
    public void testCreateSelectMultiColumn() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"cskey1");
        updater.setString((Object)"stringval", "value1");
        Date date = new Date();
        updater.setDate((Object)"curdate", date);
        updater.setLong((Object)"longval", Long.valueOf(5L));
        template.update(updater);
        template.addColumn((Object)"stringval", (Serializer)se);
        template.addColumn((Object)"curdate", (Serializer)DateSerializer.get());
        template.addColumn((Object)"longval", (Serializer)LongSerializer.get());
        ColumnFamilyResult wrapper = template.queryColumns((Object)"cskey1");
        Assert.assertEquals((Object)"value1", (Object)wrapper.getString((Object)"stringval"));
        Assert.assertEquals((Object)date, (Object)wrapper.getDate((Object)"curdate"));
        Assert.assertEquals((Object)new Long(5L), (Object)wrapper.getLong((Object)"longval"));
        Assert.assertEquals((long)3L, (long)wrapper.getColumnNames().size());
    }

    @Test
    public void testCreateSelectSpecifiedColumn() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"csskey1");
        updater.setString((Object)"col1", "value1");
        updater.setString((Object)"col2", "value2");
        updater.setString((Object)"col3", "value3");
        updater.setString((Object)"col4", "value4");
        updater.setString((Object)"col5", "value5");
        template.update(updater);
        template.addColumn((Object)"stringval", (Serializer)se);
        template.addColumn((Object)"curdate", (Serializer)DateSerializer.get());
        template.addColumn((Object)"longval", (Serializer)LongSerializer.get());
        ColumnFamilyResult wrapper = template.queryColumns((Object)"csskey1", Arrays.asList("col1", "col3", "col5"));
        Assert.assertEquals((Object)"value1", (Object)wrapper.getString((Object)"col1"));
        Assert.assertNull((Object)wrapper.getString((Object)"col2"));
        Assert.assertEquals((Object)"value3", (Object)wrapper.getString((Object)"col3"));
        Assert.assertNull((Object)wrapper.getString((Object)"col4"));
        Assert.assertEquals((Object)"value5", (Object)wrapper.getString((Object)"col5"));
        Assert.assertEquals((long)3L, (long)wrapper.getColumnNames().size());
    }

    @Test
    public void testCompareClocks() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        long ts1 = 1001L;
        long ts2 = 1002L;
        long ts3 = 1003L;
        ColumnFamilyUpdater updater = template.createUpdater((Object)"compare_clock_key1");
        updater.setClock(ts1);
        updater.setString((Object)"stringval", "value1");
        Date date = new Date();
        updater.setClock(ts2);
        updater.setDate((Object)"curdate", date);
        updater.setClock(ts3);
        updater.setLong((Object)"longval", Long.valueOf(5L));
        template.update(updater);
        template.addColumn((Object)"stringval", (Serializer)se);
        template.addColumn((Object)"curdate", (Serializer)DateSerializer.get());
        template.addColumn((Object)"longval", (Serializer)LongSerializer.get());
        ColumnFamilyResult wrapper = template.queryColumns((Object)"compare_clock_key1");
        Assert.assertEquals((long)ts1, (long)wrapper.getColumn((Object)"stringval").getClock());
        Assert.assertEquals((long)ts2, (long)wrapper.getColumn((Object)"curdate").getClock());
        Assert.assertEquals((long)ts3, (long)wrapper.getColumn((Object)"longval").getClock());
        Assert.assertEquals((long)3L, (long)wrapper.getColumnNames().size());
    }

    @Test
    public void testTtl() throws InterruptedException {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"test_ttl_key1");
        updater.setString((Object)"expired_string", "value1", 1);
        updater.setString((Object)"unexpired_string", "value2");
        updater.setBoolean((Object)"unexpired_bool", Boolean.valueOf(true));
        updater.setBoolean((Object)"expired_bool", Boolean.valueOf(true), 1);
        template.update(updater);
        Thread.sleep(1000L);
        ColumnFamilyResult wrapper = template.queryColumns((Object)"test_ttl_key1");
        HColumn col = wrapper.getColumn((Object)"unexpired_string");
        Assert.assertNotNull((Object)col);
        Assert.assertNotNull((Object)col.getValue());
        HColumn expiredStringCol = wrapper.getColumn((Object)"expired_string");
        Assert.assertNull((Object)expiredStringCol);
        HColumn expiredBooleanCol = wrapper.getColumn((Object)"expired_bool");
        Assert.assertNull((Object)expiredBooleanCol);
    }

    @Test
    public void testCreateSelectTemplate() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"key1");
        updater.setString((Object)"column1", "value1");
        template.update(updater);
        template.setCount(10);
        String value = (String)template.queryColumns((Object)"key1", (ColumnFamilyRowMapper)new ColumnFamilyRowMapper<String, String, String>(){

            public String mapRow(ColumnFamilyResult<String, String> results) {
                return results.getString((Object)"column1");
            }
        });
        Assert.assertEquals((Object)"value1", (Object)value);
    }

    @Test
    public void testOverloadedMapRowCallback() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"key1");
        updater.setString((Object)"column1", "value1");
        updater.addKey((Object)"key2");
        updater.setString((Object)"column1", "value2");
        template.update(updater);
        template.setCount(10);
        MappedColumnFamilyResult result = template.queryColumns(Arrays.asList("key1", "key2"), (ColumnFamilyRowMapper)new ColumnFamilyRowMapper<String, String, String>(){

            public String mapRow(ColumnFamilyResult<String, String> results) {
                return results.getString((Object)"column1");
            }
        });
        Assert.assertEquals((Object)"key1", (Object)result.getKey());
        Assert.assertEquals((Object)"value1", (Object)result.getRow());
        result.next();
        Assert.assertEquals((Object)"key2", (Object)result.getKey());
        Assert.assertEquals((Object)"value2", (Object)result.getRow());
    }

    @Test
    public void testQueryMultiget() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"mg_key1");
        updater.setString((Object)"column1", "value1");
        updater.addKey((Object)"mg_key2");
        updater.setString((Object)"column1", "value2");
        updater.addKey((Object)"mg_key3");
        updater.setString((Object)"column1", "value3");
        template.update(updater);
        template.addColumn((Object)"column1", (Serializer)se);
        ColumnFamilyResult wrapper = template.queryColumns(Arrays.asList("mg_key1", "mg_key2", "mg_key3"));
        Assert.assertEquals((Object)"value1", (Object)wrapper.getString((Object)"column1"));
        wrapper.next();
        Assert.assertEquals((Object)"value2", (Object)wrapper.getString((Object)"column1"));
        wrapper.next();
        Assert.assertEquals((Object)"value3", (Object)wrapper.getString((Object)"column1"));
    }

    @Test
    public void testQueryMultigetSpecificColumns() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"mgs_key1");
        updater.setString((Object)"column1", "value1-1");
        updater.setString((Object)"column2", "value2-1");
        updater.setString((Object)"column3", "value3-1");
        updater.addKey((Object)"mgs_key2");
        updater.setString((Object)"column1", "value1-2");
        updater.setString((Object)"column2", "value2-2");
        updater.setString((Object)"column3", "value3-2");
        updater.addKey((Object)"mgs_key3");
        updater.setString((Object)"column1", "value1-3");
        updater.setString((Object)"column2", "value2-3");
        updater.setString((Object)"column3", "value3-3");
        template.update(updater);
        template.addColumn((Object)"column1", (Serializer)se);
        template.addColumn((Object)"column2", (Serializer)se);
        template.addColumn((Object)"column3", (Serializer)se);
        ColumnFamilyResult wrapper = template.queryColumns(Arrays.asList("mgs_key1", "mgs_key2", "mgs_key3"), Arrays.asList("column1", "column3"));
        Assert.assertEquals((Object)"value1-1", (Object)wrapper.getString((Object)"column1"));
        Assert.assertNull((Object)wrapper.getString((Object)"column2"));
        Assert.assertEquals((Object)"value3-1", (Object)wrapper.getString((Object)"column3"));
        wrapper.next();
        Assert.assertEquals((Object)"value1-2", (Object)wrapper.getString((Object)"column1"));
        Assert.assertNull((Object)wrapper.getString((Object)"column2"));
        Assert.assertEquals((Object)"value3-2", (Object)wrapper.getString((Object)"column3"));
        wrapper.next();
        Assert.assertEquals((Object)"value1-3", (Object)wrapper.getString((Object)"column1"));
        Assert.assertNull((Object)wrapper.getString((Object)"column2"));
        Assert.assertEquals((Object)"value3-3", (Object)wrapper.getString((Object)"column3"));
    }

    @Test
    public void testHasNoResults() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        Assert.assertFalse((boolean)template.queryColumns((Object)"noresults").hasResults());
        Assert.assertFalse((boolean)template.queryColumns((Object)"noresults").hasNext());
        Assert.assertEquals((Object)"noresults", (Object)template.queryColumns((Object)"noresults").getKey());
    }

    @Test
    public void testGetKeyTwiceCall() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyResult results = template.queryColumns((Object)"noresults");
        Assert.assertEquals((Object)"noresults", (Object)results.getKey());
        Assert.assertEquals((Object)"noresults", (Object)results.getKey());
        Assert.assertEquals((Object)"noresults", (Object)results.getKey());
    }

    @Test
    public void testQueryIndexedSlices() {
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Indexed1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"index_key1");
        updater.setLong((Object)"birthyear", Long.valueOf(1974L));
        updater.setLong((Object)"birthmonth", Long.valueOf(4L));
        updater.addKey((Object)"index_key2");
        updater.setLong((Object)"birthyear", Long.valueOf(1975L));
        updater.setLong((Object)"birthmonth", Long.valueOf(4L));
        updater.addKey((Object)"index_key3");
        updater.setLong((Object)"birthyear", Long.valueOf(1975L));
        updater.setLong((Object)"birthmonth", Long.valueOf(5L));
        updater.addKey((Object)"index_key4");
        updater.setLong((Object)"birthyear", Long.valueOf(1975L));
        updater.setLong((Object)"birthmonth", Long.valueOf(6L));
        updater.addKey((Object)"index_key5");
        updater.setLong((Object)"birthyear", Long.valueOf(1975L));
        updater.setLong((Object)"birthmonth", Long.valueOf(7L));
        updater.addKey((Object)"index_key6");
        updater.setLong((Object)"birthyear", Long.valueOf(1976L));
        updater.setLong((Object)"birthmonth", Long.valueOf(6L));
        template.update(updater);
        IndexedSlicesPredicate predicate = new IndexedSlicesPredicate((Serializer)se, (Serializer)se, (Serializer)LongSerializer.get());
        predicate.startKey((Object)"");
        predicate.addExpression((Object)"birthyear", IndexOperator.EQ, (Object)1975L);
        ColumnFamilyResult result = template.queryColumns(predicate);
        int cnt = result.getColumnNames().size();
        while (result.hasNext()) {
            cnt += ((ColumnFamilyResult)result.next()).getColumnNames().size();
        }
        Assert.assertEquals((long)8L, (long)cnt);
        result = template.queryColumns(predicate, Arrays.asList("birthmonth"));
        cnt = result.getColumnNames().size();
        while (result.hasNext()) {
            cnt += ((ColumnFamilyResult)result.next()).getColumnNames().size();
        }
        Assert.assertEquals((long)4L, (long)cnt);
    }

    @Test
    public void testColumnValueTypes() {
        float EPSILON = 1.0E-7f;
        ThriftColumnFamilyTemplate template = new ThriftColumnFamilyTemplate(this.keyspace, "Standard1", (Serializer)se, (Serializer)se);
        ColumnFamilyUpdater updater = template.createUpdater((Object)"key1");
        updater.setString((Object)"column1", "string value");
        updater.setUUID((Object)"column2", UUID.fromString("cf316d50-f7c0-11e1-a21f-0800200c9a66"));
        updater.setLong((Object)"column3", Long.valueOf(829398278497234L));
        updater.setInteger((Object)"column4", Integer.valueOf(27344));
        updater.setFloat((Object)"column5", (float)Math.PI);
        updater.setDouble((Object)"column6", Double.valueOf(Math.PI));
        updater.setBoolean((Object)"column7", Boolean.valueOf(true));
        updater.setByteArray((Object)"column8", new byte[]{97, 91, 99});
        Date date = new Date();
        updater.setDate((Object)"column9", date);
        template.update(updater);
        ColumnFamilyResult wrapper = template.queryColumns((Object)"key1");
        Assert.assertEquals((Object)"string value", (Object)wrapper.getString((Object)"column1"));
        Assert.assertEquals((Object)UUID.fromString("cf316d50-f7c0-11e1-a21f-0800200c9a66"), (Object)wrapper.getUUID((Object)"column2"));
        Assert.assertEquals((Object)829398278497234L, (Object)wrapper.getLong((Object)"column3"));
        Assert.assertEquals((Object)27344, (Object)wrapper.getInteger((Object)"column4"));
        Assert.assertEquals((double)3.1415927410125732, (double)wrapper.getFloat((Object)"column5").floatValue(), (double)1.0E-7f);
        Assert.assertEquals((double)Math.PI, (double)wrapper.getDouble((Object)"column6"), (double)1.0E-7f);
        Assert.assertEquals((Object)true, (Object)wrapper.getBoolean((Object)"column7"));
        Assert.assertArrayEquals((byte[])new byte[]{97, 91, 99}, (byte[])wrapper.getByteArray((Object)"column8"));
        Assert.assertEquals((Object)date, (Object)wrapper.getDate((Object)"column9"));
        Assert.assertEquals((long)9L, (long)wrapper.getColumnNames().size());
    }
}

