/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service.template;

import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import me.prettyprint.cassandra.service.template.BaseColumnFamilyTemplateTest;
import me.prettyprint.cassandra.service.template.SuperCfResult;
import me.prettyprint.cassandra.service.template.SuperCfUpdater;
import me.prettyprint.cassandra.service.template.ThriftSuperCfTemplate;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import org.junit.Assert;
import org.junit.Test;

public class SuperCfTemplateTest
extends BaseColumnFamilyTemplateTest {
    @Test
    public void testSuperCfInsertReadTemplate() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey1", (Object)"super1");
        sUpdater.setString((Object)"sub_col_1", "sub_val_1");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumn((Object)"skey1", (Object)"super1");
        Assert.assertEquals((Object)"sub_val_1", (Object)result.getString((Object)"super1", (Object)"sub_col_1"));
        sUpdater.deleteSuperColumn();
        sTemplate.update(sUpdater);
        Assert.assertEquals((Object)"super1", (Object)sUpdater.getCurrentSuperColumn());
        result = sTemplate.querySuperColumn((Object)"skey1", (Object)"super1");
        Assert.assertFalse((boolean)result.hasResults());
    }

    @Test
    public void testSuperCfMultiSc() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey2", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sUpdater.addSuperColumn((Object)"super2");
        sUpdater.setString((Object)"sub2_col_1", "sub2_val_1");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumns((Object)"skey2", Arrays.asList("super1", "super2"));
        Assert.assertEquals((long)2L, (long)result.getSuperColumns().size());
    }

    @Test
    public void testQuerySingleSubColumn() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey3", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sTemplate.update(sUpdater);
        HColumn myCol = sTemplate.querySingleSubColumn((Object)"skey3", (Object)"super1", (Object)"sub1_col_1", (Serializer)se);
        Assert.assertEquals((Object)"sub1_val_1", (Object)myCol.getValue());
    }

    @Test
    public void testQuerySingleSubColumnExtractSuper() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey3", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sUpdater.setString((Object)"sub1_col_2", "sub1_val_2");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumns((Object)"skey3");
        HSuperColumn superColumn = result.getSuperColumn((Object)"super1");
        Assert.assertNotNull((Object)superColumn);
        Assert.assertEquals((Object)"super1", (Object)superColumn.getName());
        Assert.assertEquals((long)2L, (long)superColumn.getColumns().size());
    }

    @Test
    public void testQuerySingleSubColumnEmpty() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey3", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sTemplate.update(sUpdater);
        HColumn myCol = sTemplate.querySingleSubColumn((Object)"skey3", (Object)"super2", (Object)"sub1_col_1", (Serializer)se);
        Assert.assertNull((Object)myCol);
    }

    @Test
    public void testSuperCfInsertReadMultiKey() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"s_multi_key1", (Object)"super1");
        sUpdater.setString((Object)"sub_col_1", "sub_val_1");
        sUpdater.addKey((Object)"s_multi_key2");
        sUpdater.addSuperColumn((Object)"super1");
        sUpdater.setString((Object)"sub_col_1", "sub_val_2");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumns(Arrays.asList("s_multi_key1", "s_multi_key2"), Arrays.asList("super1"));
        Assert.assertTrue((boolean)result.hasResults());
        Assert.assertEquals((Object)"sub_val_2", (Object)result.getString((Object)"super1", (Object)"sub_col_1"));
        Assert.assertEquals((Object)"sub_val_1", (Object)result.next().getString((Object)"super1", (Object)"sub_col_1"));
    }

    @Test
    public void testSuperCfInsertReadMultiKeyNoSc() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"s_multi_key1", (Object)"super1");
        sUpdater.setString((Object)"sub_col_1", "sub_val_1");
        sUpdater.addKey((Object)"s_multi_key2");
        sUpdater.addSuperColumn((Object)"super1");
        sUpdater.setString((Object)"sub_col_1", "sub_val_2");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumns(Arrays.asList("s_multi_key1", "s_multi_key2"));
        Assert.assertTrue((boolean)result.hasResults());
        Assert.assertEquals((Object)"sub_val_2", (Object)result.getString((Object)"super1", (Object)"sub_col_1"));
        Assert.assertEquals((Object)"sub_val_1", (Object)result.next().getString((Object)"super1", (Object)"sub_col_1"));
    }

    @Test
    public void testSuperCfKeyOnly() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey1", (Object)"super1");
        sUpdater.setString((Object)"sub_col_1", "sub_val_1");
        sUpdater.addSuperColumn((Object)"super2");
        sUpdater.setString((Object)"sub_col_1", "sub_val_2");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumns((Object)"skey1");
        Assert.assertEquals((long)2L, (long)result.getSuperColumns().size());
        Assert.assertTrue((boolean)result.hasResults());
        result = sTemplate.querySuperColumns((Object)"skey1-non-existing-key");
        Assert.assertNull((Object)result.getActiveSuperColumn());
    }

    @Test
    public void testSuperCfNoResults() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        Assert.assertFalse((boolean)sTemplate.querySuperColumns((Object)"no_results").hasResults());
    }

    @Test
    public void testDeleteSubColumns() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey3", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sUpdater.setString((Object)"sub1_col_2", "sub1_val_2");
        sUpdater.setString((Object)"sub1_col_3", "sub1_val_3");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumn((Object)"skey3", (Object)"super1");
        Assert.assertEquals((long)3L, (long)result.getColumnNames().size());
        sUpdater.deleteSubColumn((Object)"sub1_col_1");
        sTemplate.update(sUpdater);
        result = sTemplate.querySuperColumn((Object)"skey3", (Object)"super1");
        Assert.assertEquals((long)2L, (long)result.getColumnNames().size());
    }

    @Test
    public void testTemplateLevelDeleteSuper() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey_del_super", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumn((Object)"skey_del_super", (Object)"super1");
        Assert.assertEquals((long)1L, (long)result.getColumnNames().size());
        sTemplate.deleteColumn((Object)"skey_del_super", (Object)"super1");
        result = sTemplate.querySuperColumn((Object)"skey_del_super", (Object)"super1");
        Assert.assertFalse((boolean)result.hasResults());
        Assert.assertEquals((long)0L, (long)result.getColumnNames().size());
    }

    @Test
    public void testTemplateLevelDeleteRow() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey_row_del", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumn((Object)"skey_row_del", (Object)"super1");
        Assert.assertEquals((long)1L, (long)result.getColumnNames().size());
        sTemplate.deleteRow((Object)"skey_row_del");
        result = sTemplate.querySuperColumns((Object)"skey_row_del");
        Assert.assertFalse((boolean)result.hasResults());
        Assert.assertEquals((long)0L, (long)result.getSuperColumns().size());
    }

    @Test
    public void testTemplateLevelDeleteMiss() {
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey_row_del_miss", (Object)"super1");
        sUpdater.setString((Object)"sub1_col_1", "sub1_val_1");
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumn((Object)"skey_row_del_miss", (Object)"super1");
        Assert.assertEquals((long)1L, (long)result.getColumnNames().size());
        sTemplate.deleteRow((Object)"skey_row_miss_foo");
        sTemplate.deleteColumn((Object)"skey_row_del", (Object)"foo");
        result = sTemplate.querySuperColumns((Object)"skey_row_del_miss");
        Assert.assertTrue((boolean)result.hasResults());
        Assert.assertEquals((long)1L, (long)result.getSuperColumns().size());
    }

    @Test
    public void testSuperCfColumnValueTypes() {
        float EPSILON = 1.0E-7f;
        ThriftSuperCfTemplate sTemplate = new ThriftSuperCfTemplate(this.keyspace, "Super1", (Serializer)se, (Serializer)se, (Serializer)se);
        SuperCfUpdater sUpdater = sTemplate.createUpdater((Object)"skey1", (Object)"super1");
        sUpdater.setString((Object)"subcolumn1", "string value");
        sUpdater.setUUID((Object)"subcolumn2", UUID.fromString("cf316d50-f7c0-11e1-a21f-0800200c9a66"));
        sUpdater.setLong((Object)"subcolumn3", Long.valueOf(829398278497234L));
        sUpdater.setInteger((Object)"subcolumn4", Integer.valueOf(27344));
        sUpdater.setFloat((Object)"subcolumn5", Float.valueOf((float)Math.PI));
        sUpdater.setDouble((Object)"subcolumn6", Double.valueOf(Math.PI));
        sUpdater.setBoolean((Object)"subcolumn7", Boolean.valueOf(true));
        sUpdater.setByteArray((Object)"subcolumn8", new byte[]{97, 91, 99});
        Date date = new Date();
        sUpdater.setDate((Object)"subcolumn9", date);
        sTemplate.update(sUpdater);
        SuperCfResult result = sTemplate.querySuperColumn((Object)"skey1", (Object)"super1");
        Assert.assertEquals((Object)"string value", (Object)result.getString((Object)"subcolumn1"));
        Assert.assertEquals((Object)UUID.fromString("cf316d50-f7c0-11e1-a21f-0800200c9a66"), (Object)result.getUUID((Object)"subcolumn2"));
        Assert.assertEquals((Object)829398278497234L, (Object)result.getLong((Object)"subcolumn3"));
        Assert.assertEquals((Object)27344, (Object)result.getInteger((Object)"subcolumn4"));
        Assert.assertEquals((double)3.1415927410125732, (double)result.getFloat((Object)"subcolumn5").floatValue(), (double)1.0E-7f);
        Assert.assertEquals((double)Math.PI, (double)result.getDouble((Object)"subcolumn6"), (double)1.0E-7f);
        Assert.assertEquals((Object)true, (Object)result.getBoolean((Object)"subcolumn7"));
        Assert.assertArrayEquals((byte[])new byte[]{97, 91, 99}, (byte[])result.getByteArray((Object)"subcolumn8"));
        Assert.assertEquals((Object)date, (Object)result.getDate((Object)"subcolumn9"));
    }
}

