/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import me.prettyprint.cassandra.utils.ByteBufferOutputStream;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufferOutputStreamTest {
    @Test
    public void testWriteByteArray() throws IOException {
        List<Integer> sizes = Arrays.asList(0, 1, 100, 1000, 255, 256, 257, 2560);
        for (int bufferSize : sizes) {
            this.testWriteLByteArray(bufferSize);
        }
    }

    private void testWriteLByteArray(int bufferSize) throws IOException {
        ByteBufferOutputStream sink = new ByteBufferOutputStream();
        byte[] written = new byte[bufferSize];
        new Random().nextBytes(written);
        sink.write(written);
        Assert.assertEquals((long)0L, (long)ByteBufferUtil.compare((ByteBuffer)sink.getByteBuffer(), (byte[])written));
    }

    @Test
    public void testWriteByteArraySeveralSteps() throws IOException {
        ByteBufferOutputStream sink = new ByteBufferOutputStream();
        byte[] written = new byte[8192];
        new Random().nextBytes(written);
        for (int i = 0; i < 32; ++i) {
            sink.write(written, i * 256, 256);
        }
        Assert.assertEquals((long)0L, (long)ByteBufferUtil.compare((ByteBuffer)sink.getByteBuffer(), (byte[])written));
    }

    @Test
    public void testWriteLargeByteBuffer() throws IOException {
        ByteBufferOutputStream sink = new ByteBufferOutputStream();
        byte[] written = new byte[32000];
        new Random().nextBytes(written);
        sink.write(ByteBuffer.wrap(written));
        Assert.assertEquals((long)0L, (long)ByteBufferUtil.compare((ByteBuffer)sink.getByteBuffer(), (byte[])written));
    }
}

