/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.utils;

import com.eaio.uuid.UUID;
import com.eaio.uuid.UUIDGen;
import java.nio.ByteBuffer;
import java.util.Date;
import me.prettyprint.cassandra.service.clock.MicrosecondsClockResolution;
import me.prettyprint.cassandra.service.clock.MicrosecondsSyncClockResolution;
import me.prettyprint.cassandra.utils.TimeUUIDUtils;
import me.prettyprint.hector.api.ClockResolution;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUUIDUtilsTest {
    private static Logger log = LoggerFactory.getLogger(TimeUUIDUtilsTest.class);

    @Test
    public void testTimeUUIDWithClockResolution() throws Exception {
        MicrosecondsClockResolution clock = new MicrosecondsClockResolution();
        long time = clock.createClock();
        Assert.assertEquals((Object)TimeUUIDUtils.getTimeUUID((long)time), (Object)java.util.UUID.fromString(new UUID(UUIDGen.createTime((long)time), UUIDGen.getClockSeqAndNode()).toString()));
        clock = new MicrosecondsSyncClockResolution();
        java.util.UUID first = TimeUUIDUtils.getTimeUUID((ClockResolution)clock);
        java.util.UUID second = TimeUUIDUtils.getTimeUUID((ClockResolution)clock);
        Assert.assertTrue((second.compareTo(first) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTimeUUIDAsByteArray() {
        java.util.UUID uuid = TimeUUIDUtils.getUniqueTimeUUIDinMillis();
        java.util.UUID uuidAfterConversion = TimeUUIDUtils.toUUID((byte[])TimeUUIDUtils.asByteArray((java.util.UUID)uuid));
        Assert.assertEquals((Object)uuid, (Object)uuidAfterConversion);
        long timeInUUID = TimeUUIDUtils.getTimeFromUUID((byte[])TimeUUIDUtils.asByteArray((java.util.UUID)uuid));
        Assert.assertEquals((long)((uuid.timestamp() - 122192928000000000L) / 10000L), (long)timeInUUID);
    }

    @Test
    public void testTimeUUIDAsByteBuffer() {
        java.util.UUID expectedUuid = TimeUUIDUtils.getUniqueTimeUUIDinMillis();
        java.util.UUID actualUuid = TimeUUIDUtils.uuid((ByteBuffer)TimeUUIDUtils.asByteBuffer((java.util.UUID)expectedUuid));
        Assert.assertEquals((Object)expectedUuid, (Object)actualUuid);
    }

    @Test
    public void testDateUUIDConversion() {
        long originalTime = System.currentTimeMillis();
        Date originalDate = new Date(originalTime);
        java.util.UUID originalUUID = TimeUUIDUtils.getTimeUUID((long)originalTime);
        long currentTime = TimeUUIDUtils.getTimeFromUUID((java.util.UUID)originalUUID);
        Assert.assertEquals((long)originalTime, (long)currentTime);
        Assert.assertEquals((Object)originalDate, (Object)new Date(currentTime));
    }

    @Test
    public void testTimestampConsistency() {
        long originalTime = System.currentTimeMillis();
        log.info("Original Time: " + originalTime);
        log.info("----");
        java.util.UUID u1 = TimeUUIDUtils.getTimeUUID((long)originalTime);
        log.info("Java UUID: " + u1);
        log.info("Java UUID timestamp: " + u1.timestamp());
        log.info("Date: " + new Date(u1.timestamp()));
        log.info("----");
        UUID u = new UUID(originalTime, 0L);
        log.info("eaio UUID: " + u);
        log.info("eaio UUID timestamp: " + u.getTime());
        log.info("Date: " + new Date(u.getTime()));
        log.info("----");
        long actual1 = TimeUUIDUtils.getTimeFromUUID((byte[])TimeUUIDUtils.asByteArray((java.util.UUID)u1));
        log.info("Java UUID to bytes to time: " + actual1);
        log.info("Java UUID to bytes time to Date: " + new Date(actual1));
        log.info("----");
        long actual2 = TimeUUIDUtils.getTimeFromUUID((java.util.UUID)u1);
        log.info("Java UUID to time: " + actual2);
        log.info("Java UUID to time to Date: " + new Date(actual2));
        Assert.assertEquals((long)originalTime, (long)actual1);
        Assert.assertEquals((long)originalTime, (long)actual2);
    }
}

