/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.beans.CounterRow;
import me.prettyprint.hector.api.beans.CounterSlice;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HCounterColumn;
import me.prettyprint.hector.api.beans.HCounterSuperColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.beans.OrderedCounterRows;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.beans.OrderedSuperRows;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.beans.Rows;
import me.prettyprint.hector.api.beans.SuperRow;
import me.prettyprint.hector.api.beans.SuperRows;
import me.prettyprint.hector.api.beans.SuperSlice;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.MutationResult;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.CountQuery;
import me.prettyprint.hector.api.query.CounterQuery;
import me.prettyprint.hector.api.query.MultigetSliceQuery;
import me.prettyprint.hector.api.query.MultigetSubSliceQuery;
import me.prettyprint.hector.api.query.MultigetSuperSliceQuery;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesQuery;
import me.prettyprint.hector.api.query.RangeSubSlicesCounterQuery;
import me.prettyprint.hector.api.query.RangeSubSlicesQuery;
import me.prettyprint.hector.api.query.RangeSuperSlicesQuery;
import me.prettyprint.hector.api.query.SliceCounterQuery;
import me.prettyprint.hector.api.query.SliceQuery;
import me.prettyprint.hector.api.query.SubColumnQuery;
import me.prettyprint.hector.api.query.SubCountQuery;
import me.prettyprint.hector.api.query.SubSliceCounterQuery;
import me.prettyprint.hector.api.query.SubSliceQuery;
import me.prettyprint.hector.api.query.SuperColumnQuery;
import me.prettyprint.hector.api.query.SuperCountQuery;
import me.prettyprint.hector.api.query.SuperSliceQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiV2SystemTest
extends BaseEmbededServerSetupTest {
    static final Logger log = LoggerFactory.getLogger(ApiV2SystemTest.class);
    static final String KEYSPACE = "Keyspace1";
    static final String COUNTER_CF = "Counter1";
    static final StringSerializer se = new StringSerializer();
    Cluster cluster;
    Keyspace ko;

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.ko = HFactory.createKeyspace((String)KEYSPACE, (Cluster)this.cluster);
    }

    @After
    public void teardownCase() {
        this.ko = null;
        this.cluster = null;
    }

    @Test
    public void testInsertGetRemoveCounter() {
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        MutationResult mr = m.insertCounter((Object)"testInsertGetRemoveCounter", COUNTER_CF, HFactory.createCounterColumn((String)"testInsertGetRemoveCounter_name", (long)25L));
        log.debug("insert execution time: {}", (Object)mr.getExecutionTimeMicro());
        CounterQuery q = HFactory.createCounterColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        q.setColumnFamily(COUNTER_CF).setName((Object)"testInsertGetRemoveCounter_name").setKey((Object)"testInsertGetRemoveCounter");
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        HCounterColumn c = (HCounterColumn)r.get();
        Assert.assertNotNull((Object)c);
        Long value = c.getValue();
        Assert.assertEquals((long)25L, (long)value);
        String name = (String)c.getName();
        Assert.assertEquals((Object)"testInsertGetRemoveCounter_name", (Object)name);
        Assert.assertEquals((Object)q, (Object)r.getQuery());
        m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        m.deleteCounter((Object)"testInsertGetRemoveCounter", COUNTER_CF, (Object)"testInsertGetRemoveCounter_name", (Serializer)se);
        CounterQuery q2 = HFactory.createCounterColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        q2.setName((Object)"testInsertGetRemoveCounter_name").setColumnFamily(COUNTER_CF);
        QueryResult r2 = q2.setKey((Object)"testInsertGetRemoveCounter").execute();
        Assert.assertNotNull((Object)r2);
        Assert.assertNull((String)"Value should have been deleted", (Object)r2.get());
    }

    @Test
    public void testCounterMutation() {
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        m.addCounter((Object)"testCounterMutation", COUNTER_CF, HFactory.createCounterColumn((String)"testCounterMutation_col_name", (long)5L));
        m.execute();
        Assert.assertEquals((Object)new Long(5L), (Object)this.readCounterValue("testCounterMutation", COUNTER_CF, "testCounterMutation_col_name"));
        m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        m.addCounterDeletion((Object)"testCounterMutation", COUNTER_CF);
        m.execute();
        Assert.assertNull((Object)this.readCounterValue("testCounterMutation", COUNTER_CF, "testCounterMutation_col_name"));
    }

    private Long readCounterValue(String key, String cf, String colName) {
        CounterQuery q = HFactory.createCounterColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf).setName((Object)colName).setKey((Object)key);
        HCounterColumn c = (HCounterColumn)q.execute().get();
        if (c == null) {
            return null;
        }
        return c.getValue();
    }

    @Test
    public void testIncrementDecrementCounter() {
        HFactory.createMutator((Keyspace)this.ko, (Serializer)se).incrementCounter((Object)"testIncrementDecrementCounter", COUNTER_CF, (Object)"testIncrementDecrementCounter_name", 7L);
        HFactory.createMutator((Keyspace)this.ko, (Serializer)se).decrementCounter((Object)"testIncrementDecrementCounter", COUNTER_CF, (Object)"testIncrementDecrementCounter_name", 2L);
        CounterQuery q = HFactory.createCounterColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        q.setColumnFamily(COUNTER_CF).setName((Object)"testIncrementDecrementCounter_name");
        QueryResult r = q.setKey((Object)"testIncrementDecrementCounter").execute();
        Assert.assertNotNull((Object)r);
        HCounterColumn c = (HCounterColumn)r.get();
        Assert.assertNotNull((Object)c);
        Long value = c.getValue();
        Assert.assertEquals((long)5L, (long)value);
    }

    @Test
    public void testInsertGetRemove() {
        String cf = "Standard1";
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        MutationResult mr = m.insert((Object)"testInsertGetRemove", cf, HFactory.createColumn((Object)"testInsertGetRemove", (Object)"testInsertGetRemove_value_", (Serializer)se, (Serializer)se));
        log.debug("insert execution time: {}", (Object)mr.getExecutionTimeMicro());
        ColumnQuery q = HFactory.createColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setName((Object)"testInsertGetRemove").setColumnFamily(cf);
        QueryResult r = q.setKey((Object)"testInsertGetRemove").execute();
        Assert.assertNotNull((Object)r);
        HColumn c = (HColumn)r.get();
        Assert.assertNotNull((Object)c);
        String value = (String)c.getValue();
        Assert.assertEquals((Object)"testInsertGetRemove_value_", (Object)value);
        String name = (String)c.getName();
        Assert.assertEquals((Object)"testInsertGetRemove", (Object)name);
        Assert.assertEquals((Object)q, (Object)r.getQuery());
        m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        m.delete((Object)"testInsertGetRemove", cf, (Object)"testInsertGetRemove", (Serializer)se);
        ColumnQuery q2 = HFactory.createColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q2.setName((Object)"testInsertGetRemove").setColumnFamily(cf);
        QueryResult r2 = q2.setKey((Object)"testInsertGetRemove").execute();
        Assert.assertNotNull((Object)r2);
        Assert.assertNull((String)"Value should have been deleted", (Object)r2.get());
    }

    @Test
    public void testBatchInsertGetRemove() {
        int i;
        String cf = "Standard1";
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int i2 = 0; i2 < 5; ++i2) {
            m.addInsertion((Object)("testInsertGetRemove" + i2), cf, HFactory.createColumn((Object)"testInsertGetRemove", (Object)("testInsertGetRemove_value_" + i2), (Serializer)se, (Serializer)se));
        }
        m.execute();
        ColumnQuery q = HFactory.createColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setName((Object)"testInsertGetRemove").setColumnFamily(cf);
        for (i = 0; i < 5; ++i) {
            QueryResult r = q.setKey((Object)("testInsertGetRemove" + i)).execute();
            Assert.assertNotNull((Object)r);
            HColumn c = (HColumn)r.get();
            Assert.assertNotNull((Object)c);
            String value = (String)c.getValue();
            Assert.assertEquals((Object)("testInsertGetRemove_value_" + i), (Object)value);
        }
        m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (i = 0; i < 5; ++i) {
            m.addDeletion((Object)("testInsertGetRemove" + i), cf, (Object)"testInsertGetRemove", (Serializer)se);
        }
        m.execute();
        ColumnQuery q2 = HFactory.createColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q2.setName((Object)"testInsertGetRemove").setColumnFamily(cf);
        for (int i3 = 0; i3 < 5; ++i3) {
            QueryResult r = q2.setKey((Object)("testInsertGetRemove" + i3)).execute();
            Assert.assertNotNull((Object)r);
            Assert.assertNull((String)"Value should have been deleted", (Object)r.get());
        }
    }

    @Test
    public void testSuperInsertGetRemove() {
        String cf = "Super1";
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        List<HColumn> columns = Arrays.asList(HFactory.createColumn((Object)"name1", (Object)"value1", (Serializer)se, (Serializer)se), HFactory.createColumn((Object)"name2", (Object)"value2", (Serializer)se, (Serializer)se));
        m.insert((Object)"testSuperInsertGetRemove", cf, HFactory.createSuperColumn((Object)"testSuperInsertGetRemove", columns, (Serializer)se, (Serializer)se, (Serializer)se));
        SuperColumnQuery q = HFactory.createSuperColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setSuperName((Object)"testSuperInsertGetRemove").setColumnFamily(cf);
        QueryResult r = q.setKey((Object)"testSuperInsertGetRemove").execute();
        Assert.assertNotNull((Object)r);
        HSuperColumn sc = (HSuperColumn)r.get();
        Assert.assertNotNull((Object)sc);
        Assert.assertEquals((long)2L, (long)sc.getSize());
        HColumn c = sc.get(0);
        String value = (String)c.getValue();
        Assert.assertEquals((Object)"value1", (Object)value);
        String name = (String)c.getName();
        Assert.assertEquals((Object)"name1", (Object)name);
        HColumn c2 = sc.get(1);
        Assert.assertEquals((Object)"name2", (Object)c2.getName());
        Assert.assertEquals((Object)"value2", (Object)c2.getValue());
        Iterator it = sc.getColumns().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Assert.assertEquals((String)"The list of columns should be mutable", (long)0L, (long)sc.getColumns().size());
        m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        m.subDelete((Object)"testSuperInsertGetRemove", cf, (Object)"testSuperInsertGetRemove", null, (Serializer)se, (Serializer)se);
        r = q.execute();
        sc = (HSuperColumn)r.get();
        Assert.assertNull((Object)sc);
    }

    @Test
    public void testSubColumnQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 1, "testSubColumnQuery", 1, "testSubColumnQuerySuperColumn");
        SubColumnQuery q = HFactory.createSubColumnQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setSuperColumn((Object)"testSubColumnQuerySuperColumn0").setColumn((Object)"c000").setColumnFamily(cf);
        QueryResult r = q.setKey((Object)"testSubColumnQuery0").execute();
        Assert.assertNotNull((Object)r);
        HColumn c = (HColumn)r.get();
        Assert.assertNotNull((Object)c);
        String value = (String)c.getValue();
        Assert.assertEquals((Object)"v000", (Object)value);
        String name = (String)c.getName();
        Assert.assertEquals((Object)"c000", (Object)name);
        q.setColumn((Object)"column doesn't exist");
        r = q.execute();
        Assert.assertNotNull((Object)r);
        c = (HColumn)r.get();
        Assert.assertNull((Object)c);
        this.deleteColumns(cleanup);
    }

    @Test
    public void testMultigetSliceQuery() {
        String cf = "Standard1";
        TestCleanupDescriptor cleanup = this.insertColumns(cf, 4, "testMultigetSliceQuery", 3, "testMultigetSliceQueryColumn");
        MultigetSliceQuery q = HFactory.createMultigetSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object[])new String[]{"testMultigetSliceQuery1", "testMultigetSliceQuery2"});
        q.setColumnNames((Object[])new String[]{"testMultigetSliceQueryColumn1", "testMultigetSliceQueryColumn2"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        Rows rows = (Rows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)2L, (long)rows.getCount());
        Row row = rows.getByKey((Object)"testMultigetSliceQuery1");
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testMultigetSliceQuery1", (Object)row.getKey());
        ColumnSlice slice = row.getColumnSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)"value11", (Object)slice.getColumnByName((Object)"testMultigetSliceQueryColumn1").getValue());
        Assert.assertEquals((Object)"value12", (Object)slice.getColumnByName((Object)"testMultigetSliceQueryColumn2").getValue());
        Assert.assertNull((Object)slice.getColumnByName((Object)"testMultigetSliceQueryColumn3"));
        List columns = slice.getColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)2L, (long)columns.size());
        q = HFactory.createMultigetSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object[])new String[]{"testMultigetSliceQuery3"});
        q.setRange((Object)"testMultigetSliceQueryColumn1", (Object)"testMultigetSliceQueryColumn3", false, 100);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        rows = (Rows)r.get();
        Assert.assertEquals((long)1L, (long)rows.getCount());
        for (Row row2 : rows) {
            Assert.assertNotNull((Object)row2);
            slice = row2.getColumnSlice();
            Assert.assertNotNull((Object)slice);
            for (HColumn column : slice.getColumns()) {
                if (((String)column.getName()).equals("testMultigetSliceQueryColumn1") || ((String)column.getName()).equals("testMultigetSliceQueryColumn2") || ((String)column.getName()).equals("testMultigetSliceQueryColumn3")) continue;
                Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
            }
        }
        this.deleteColumns(cleanup);
    }

    @Test
    public void testSliceQuery() {
        String cf = "Standard1";
        TestCleanupDescriptor cleanup = this.insertColumns(cf, 1, "testSliceQuery", 4, "testSliceQuery");
        SliceQuery q = HFactory.createSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testSliceQuery0");
        q.setColumnNames((Object[])new String[]{"testSliceQuery1", "testSliceQuery2", "testSliceQuery3"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        ColumnSlice slice = (ColumnSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((long)3L, (long)slice.getColumns().size());
        Assert.assertEquals((Object)"value01", (Object)slice.getColumnByName((Object)"testSliceQuery1").getValue());
        Assert.assertEquals((Object)"value02", (Object)slice.getColumnByName((Object)"testSliceQuery2").getValue());
        Assert.assertEquals((Object)"value03", (Object)slice.getColumnByName((Object)"testSliceQuery3").getValue());
        List columns = slice.getColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        q = HFactory.createSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testSliceQuery0");
        q.setRange((Object)"testSliceQuery2", (Object)"testSliceQuery1", true, 100);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (ColumnSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((long)2L, (long)slice.getColumns().size());
        for (HColumn column : slice.getColumns()) {
            if (((String)column.getName()).equals("testSliceQuery1") || ((String)column.getName()).equals("testSliceQuery2")) continue;
            Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
        }
        this.deleteColumns(cleanup);
    }

    @Test
    public void testCounterSliceQuery() {
        String cf = COUNTER_CF;
        Mutator mutator = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int i = 0; i < 10; ++i) {
            mutator.addCounter((Object)"testCounterSliceQuery_key", cf, HFactory.createCounterColumn((String)("" + i), (long)i));
        }
        mutator.execute();
        SliceCounterQuery q = HFactory.createCounterSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testCounterSliceQuery_key");
        q.setColumnNames((Object[])new String[]{"4", "5", "6"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        CounterSlice slice = (CounterSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((long)3L, (long)slice.getColumns().size());
        Assert.assertEquals((long)4L, (long)slice.getColumnByName((Object)"4").getValue());
        Assert.assertEquals((long)5L, (long)slice.getColumnByName((Object)"5").getValue());
        Assert.assertEquals((long)6L, (long)slice.getColumnByName((Object)"6").getValue());
        List columns = slice.getColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)3L, (long)columns.size());
        mutator.deleteCounter((Object)"testCounterSliceQuery_key", cf, null, (Serializer)se);
        mutator.execute();
    }

    @Test
    public void testSuperSliceQuery() {
        String cf = "Super1";
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int j = 1; j <= 3; ++j) {
            HSuperColumn sc = HFactory.createSuperColumn((Object)("testSuperSliceQuery" + j), Arrays.asList(HFactory.createColumn((Object)"name", (Object)"value", (Serializer)se, (Serializer)se)), (Serializer)se, (Serializer)se, (Serializer)se);
            m.addInsertion((Object)"testSuperSliceQuery", cf, sc);
        }
        MutationResult mr = m.execute();
        log.debug("insert execution time: {}", (Object)mr.getExecutionTimeMicro());
        SuperSliceQuery q = HFactory.createSuperSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testSuperSliceQuery");
        q.setColumnNames((Object[])new String[]{"testSuperSliceQuery1", "testSuperSliceQuery2", "testSuperSliceQuery3"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        SuperSlice slice = (SuperSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((long)3L, (long)slice.getSuperColumns().size());
        Assert.assertEquals((Object)"value", (Object)((HColumn)slice.getColumnByName((Object)"testSuperSliceQuery1").getColumns().get(0)).getValue());
        q = HFactory.createSuperSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testSuperSliceQuery");
        q.setRange((Object)"testSuperSliceQuery1", (Object)"testSuperSliceQuery2", false, 2);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (SuperSlice)r.get();
        Assert.assertNotNull((Object)slice);
        for (HSuperColumn scolumn : slice.getSuperColumns()) {
            if (((String)scolumn.getName()).equals("testSuperSliceQuery1") || ((String)scolumn.getName()).equals("testSuperSliceQuery2")) continue;
            Assert.fail((String)("A columns with unexpected column name returned: " + (String)scolumn.getName()));
        }
        for (int j = 1; j <= 3; ++j) {
            m.addDeletion((Object)"testSuperSliceQuery", cf, (Object)("testSuperSliceQuery" + j), (Serializer)se);
        }
        mr = m.execute();
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (SuperSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertTrue((boolean)slice.getSuperColumns().isEmpty());
    }

    @Test
    public void testSubSliceQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 1, "testSliceQueryOnSubcolumns", 1, "testSliceQueryOnSubcolumns_column");
        SubSliceQuery q = HFactory.createSubSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setSuperColumn((Object)"testSliceQueryOnSubcolumns_column0");
        q.setKey((Object)"testSliceQueryOnSubcolumns0");
        q.setColumnNames((Object[])new String[]{"c000", "c110", "c_doesn't_exist"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        ColumnSlice slice = (ColumnSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((long)2L, (long)slice.getColumns().size());
        Assert.assertEquals((Object)"v000", (Object)slice.getColumnByName((Object)"c000").getValue());
        q = HFactory.createSubSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testSliceQueryOnSubcolumns0");
        q.setSuperColumn((Object)"testSliceQueryOnSubcolumns_column0");
        q.setRange((Object)"c000", (Object)"c110", false, 2);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (ColumnSlice)r.get();
        Assert.assertNotNull((Object)slice);
        for (HColumn column : slice.getColumns()) {
            if (((String)column.getName()).equals("c000") || ((String)column.getName()).equals("c110")) continue;
            Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
        }
        this.deleteColumns(cleanup);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (ColumnSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertTrue((boolean)slice.getColumns().isEmpty());
    }

    @Test
    public void testSubSliceCounterQuery() {
        String cf = "SuperCounter1";
        TestCleanupDescriptor cleanup = this.insertSuperCountColumns(cf, 1, "testSliceCounterQueryOnSubcolumns", 1, "testSliceCounterQueryOnSubcolumns_column");
        SubSliceCounterQuery q = HFactory.createSubSliceCounterQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setSuperColumn((Object)"testSliceCounterQueryOnSubcolumns_column0");
        q.setKey((Object)"testSliceCounterQueryOnSubcolumns0");
        q.setColumnNames((Object[])new String[]{"c000", "c110", "c_doesn't_exist"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        CounterSlice slice = (CounterSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((long)2L, (long)slice.getColumns().size());
        Assert.assertEquals((Object)0L, (Object)slice.getColumnByName((Object)"c000").getValue());
        q = HFactory.createSubSliceCounterQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKey((Object)"testSliceCounterQueryOnSubcolumns0");
        q.setSuperColumn((Object)"testSliceCounterQueryOnSubcolumns_column0");
        q.setRange((Object)"c000", (Object)"c110", false, 2);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (CounterSlice)r.get();
        Assert.assertNotNull((Object)slice);
        for (HCounterColumn column : slice.getColumns()) {
            if (((String)column.getName()).equals("c000") || ((String)column.getName()).equals("c110")) continue;
            Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
        }
        this.deleteColumns(cleanup);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        slice = (CounterSlice)r.get();
        Assert.assertNotNull((Object)slice);
        Assert.assertTrue((boolean)slice.getColumns().isEmpty());
    }

    @Test
    public void testMultigetSuperSliceQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 4, "testSuperMultigetSliceQueryKey", 3, "testSuperMultigetSliceQuery");
        MultigetSuperSliceQuery q = HFactory.createMultigetSuperSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object[])new String[]{"testSuperMultigetSliceQueryKey0", "testSuperMultigetSliceQueryKey3"});
        q.setColumnNames((Object[])new String[]{"testSuperMultigetSliceQuery1", "testSuperMultigetSliceQuery2"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        SuperRows rows = (SuperRows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)2L, (long)rows.getCount());
        SuperRow row = rows.getByKey((Object)"testSuperMultigetSliceQueryKey0");
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testSuperMultigetSliceQueryKey0", (Object)row.getKey());
        SuperSlice slice = row.getSuperSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)"v001", (Object)((HColumn)slice.getColumnByName((Object)"testSuperMultigetSliceQuery1").getColumns().get(0)).getValue());
        Assert.assertNull((Object)slice.getColumnByName((Object)"testSuperMultigetSliceQuery3"));
        this.deleteColumns(cleanup);
    }

    @Test
    public void testMultigetSubSliceQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 3, "testMultigetSubSliceQuery", 1, "testMultigetSubSliceQuery");
        MultigetSubSliceQuery q = HFactory.createMultigetSubSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setSuperColumn((Object)"testMultigetSubSliceQuery0");
        q.setKeys((Object[])new String[]{"testMultigetSubSliceQuery0", "testMultigetSubSliceQuery2"});
        q.setColumnNames((Object[])new String[]{"c000", "c110"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        Rows rows = (Rows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)2L, (long)rows.getCount());
        Row row = rows.getByKey((Object)"testMultigetSubSliceQuery0");
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testMultigetSubSliceQuery0", (Object)row.getKey());
        ColumnSlice slice = row.getColumnSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)"v000", (Object)slice.getColumnByName((Object)"c000").getValue());
        Assert.assertEquals((Object)"v100", (Object)slice.getColumnByName((Object)"c110").getValue());
        List columns = slice.getColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)2L, (long)columns.size());
        q = HFactory.createMultigetSubSliceQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object[])new String[]{"testMultigetSubSliceQuery0"});
        q.setSuperColumn((Object)"testMultigetSubSliceQuery0");
        q.setRange((Object)"c000", (Object)"c110", false, 2);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        rows = (Rows)r.get();
        Assert.assertEquals((long)1L, (long)rows.getCount());
        for (Row row2 : rows) {
            Assert.assertNotNull((Object)row2);
            slice = row2.getColumnSlice();
            Assert.assertNotNull((Object)slice);
            Assert.assertEquals((long)2L, (long)slice.getColumns().size());
            for (HColumn column : slice.getColumns()) {
                if (((String)column.getName()).equals("c000") || ((String)column.getName()).equals("c110")) continue;
                Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
            }
        }
        this.deleteColumns(cleanup);
    }

    @Test
    public void testRangeSlicesQuery() {
        String cf = "Standard1";
        TestCleanupDescriptor cleanup = this.insertColumns(cf, 4, "testRangeSlicesQuery", 3, "testRangeSlicesQueryColumn");
        RangeSlicesQuery q = HFactory.createRangeSlicesQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object)"testRangeSlicesQuery1", (Object)"testRangeSlicesQuery3");
        q.setColumnNames((Object[])new String[]{"testRangeSlicesQueryColumn1", "testRangeSlicesQueryColumn2"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        OrderedRows rows = (OrderedRows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)3L, (long)rows.getCount());
        Row row = (Row)rows.getList().get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testRangeSlicesQuery1", (Object)row.getKey());
        ColumnSlice slice = row.getColumnSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)"value11", (Object)slice.getColumnByName((Object)"testRangeSlicesQueryColumn1").getValue());
        Assert.assertEquals((Object)"value12", (Object)slice.getColumnByName((Object)"testRangeSlicesQueryColumn2").getValue());
        Assert.assertNull((Object)slice.getColumnByName((Object)"testRangeSlicesQueryColumn3"));
        List columns = slice.getColumns();
        Assert.assertNotNull((Object)columns);
        Assert.assertEquals((long)2L, (long)columns.size());
        q.setKeys((Object)"testRangeSlicesQuery1", (Object)"testRangeSlicesQuery5");
        q.setRange((Object)"testRangeSlicesQueryColumn1", (Object)"testRangeSlicesQueryColumn3", false, 100);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        rows = (OrderedRows)r.get();
        Assert.assertEquals((long)3L, (long)rows.getCount());
        for (Row row2 : rows) {
            Assert.assertNotNull((Object)row2);
            slice = row2.getColumnSlice();
            Assert.assertNotNull((Object)slice);
            Assert.assertEquals((long)2L, (long)slice.getColumns().size());
            for (HColumn column : slice.getColumns()) {
                if (((String)column.getName()).equals("testRangeSlicesQueryColumn1") || ((String)column.getName()).equals("testRangeSlicesQueryColumn2")) continue;
                Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
            }
        }
        this.deleteColumns(cleanup);
    }

    @Test
    public void testRangeSuperSlicesQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 4, "testRangeSuperSlicesQuery", 3, "testRangeSuperSlicesQuery");
        RangeSuperSlicesQuery q = HFactory.createRangeSuperSlicesQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object)"testRangeSuperSlicesQuery2", (Object)"testRangeSuperSlicesQuery3");
        q.setColumnNames((Object[])new String[]{"testRangeSuperSlicesQuery1", "testRangeSuperSlicesQuery2"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        OrderedSuperRows rows = (OrderedSuperRows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)2L, (long)rows.getCount());
        SuperRow row = (SuperRow)rows.getList().get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testRangeSuperSlicesQuery2", (Object)row.getKey());
        SuperSlice slice = row.getSuperSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)"v021", (Object)slice.getColumnByName((Object)"testRangeSuperSlicesQuery1").get(0).getValue());
        Assert.assertEquals((Object)"v022", (Object)slice.getColumnByName((Object)"testRangeSuperSlicesQuery2").get(0).getValue());
        Assert.assertNull((Object)slice.getColumnByName((Object)"testRangeSuperSlicesQuery3"));
        q.setKeys((Object)"testRangeSuperSlicesQuery0", (Object)"testRangeSuperSlicesQuery5");
        q.setRange((Object)"testRangeSuperSlicesQuery1", (Object)"testRangeSuperSlicesQuery3", false, 100);
        r = q.execute();
        Assert.assertNotNull((Object)r);
        rows = (OrderedSuperRows)r.get();
        Assert.assertEquals((long)4L, (long)rows.getCount());
        for (SuperRow row2 : rows) {
            Assert.assertNotNull((Object)row2);
            slice = row2.getSuperSlice();
            Assert.assertNotNull((Object)slice);
            Assert.assertEquals((long)2L, (long)slice.getSuperColumns().size());
            for (HSuperColumn column : slice.getSuperColumns()) {
                if (!((String)column.getName()).equals("testRangeSuperSlicesQuery1") && !((String)column.getName()).equals("testRangeSuperSlicesQuery2")) {
                    Assert.fail((String)("A columns with unexpected column name returned: " + (String)column.getName()));
                }
                if (column.getSubColumnByName((Object)"c001") == null) continue;
                Assert.assertEquals((Object)"v001", (Object)column.getSubColumnByName((Object)"c001").getValue());
            }
        }
        Iterator it = rows.getList().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Assert.assertEquals((String)"The list of super rows should be mutable", (long)0L, (long)rows.getList().size());
        this.deleteColumns(cleanup);
    }

    @Test
    public void testRangeSuperSlicesQuery_order() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 4, "testRangeSuperSlicesQuery", 3, "testRangeSuperSlicesQuery");
        RangeSuperSlicesQuery q = HFactory.createRangeSuperSlicesQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object)"testRangeSuperSlicesQuery0", (Object)"testRangeSuperSlicesQuery1");
        q.setColumnNames((Object[])new String[]{"testRangeSuperSlicesQuery1", "testRangeSuperSlicesQuery2"});
        QueryResult r = q.execute();
        OrderedSuperRows rows = (OrderedSuperRows)r.get();
        Assert.assertEquals((long)2L, (long)rows.getCount());
        int i = 0;
        for (SuperRow row : rows.getList()) {
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((Object)("testRangeSuperSlicesQuery" + i), (Object)row.getKey());
            ++i;
        }
        r = q.execute();
        rows = (OrderedSuperRows)r.get();
        Assert.assertEquals((long)2L, (long)rows.getCount());
        i = 0;
        for (SuperRow row : rows) {
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((Object)("testRangeSuperSlicesQuery" + i), (Object)row.getKey());
            ++i;
        }
        this.deleteColumns(cleanup);
    }

    @Test
    public void testRangeSubSlicesQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 4, "testRangeSubSlicesQuery", 3, "testRangeSubSlicesQuery");
        RangeSubSlicesQuery q = HFactory.createRangeSubSlicesQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object)"testRangeSubSlicesQuery2", (Object)"testRangeSubSlicesQuery3");
        q.setSuperColumn((Object)"testRangeSubSlicesQuery1");
        q.setColumnNames((Object[])new String[]{"c021", "c111"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        OrderedRows rows = (OrderedRows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)2L, (long)rows.getCount());
        Row row = (Row)rows.getList().get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testRangeSubSlicesQuery2", (Object)row.getKey());
        ColumnSlice slice = row.getColumnSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)"v021", (Object)slice.getColumnByName((Object)"c021").getValue());
        Assert.assertEquals((Object)"v121", (Object)slice.getColumnByName((Object)"c111").getValue());
        Assert.assertNull((Object)slice.getColumnByName((Object)"c033"));
        this.deleteColumns(cleanup);
    }

    @Test
    public void testRangeSubSlicesCounterQuery() {
        String cf = "SuperCounter1";
        TestCleanupDescriptor cleanup = this.insertSuperCountColumns(cf, 4, "testRangeSubSlicesCounterQuery", 3, "testRangeSubSlicesCounterQuery");
        RangeSubSlicesCounterQuery q = HFactory.createRangeSubSlicesCounterQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        q.setColumnFamily(cf);
        q.setKeys((Object)"testRangeSubSlicesCounterQuery2", (Object)"testRangeSubSlicesCounterQuery3");
        q.setSuperColumn((Object)"testRangeSubSlicesCounterQuery1");
        q.setColumnNames((Object[])new String[]{"c021", "c111"});
        QueryResult r = q.execute();
        Assert.assertNotNull((Object)r);
        OrderedCounterRows rows = (OrderedCounterRows)r.get();
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((long)2L, (long)rows.getCount());
        CounterRow row = (CounterRow)rows.getList().get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"testRangeSubSlicesCounterQuery2", (Object)row.getKey());
        CounterSlice slice = row.getColumnSlice();
        Assert.assertNotNull((Object)slice);
        Assert.assertEquals((Object)3L, (Object)slice.getColumnByName((Object)"c021").getValue());
        Assert.assertEquals((Object)3L, (Object)slice.getColumnByName((Object)"c111").getValue());
        Assert.assertNull((Object)slice.getColumnByName((Object)"c033"));
        this.deleteColumns(cleanup);
    }

    @Test
    public void testCountQuery() {
        String cf = "Standard1";
        TestCleanupDescriptor cleanup = this.insertColumns(cf, 1, "testCountQuery", 10, "testCountQueryColumn");
        CountQuery cq = HFactory.createCountQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        cq.setColumnFamily(cf).setKey((Object)"testCountQuery0");
        cq.setRange((Object)"testCountQueryColumn", (Object)"testCountQueryColumn999", 100);
        QueryResult r = cq.execute();
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)10, (Object)r.get());
        this.deleteColumns(cleanup);
        cq = HFactory.createCountQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        cq.setColumnFamily(cf).setKey((Object)"testCountQuery_nonexisting");
        cq.setRange((Object)"testCountQueryColumn", (Object)"testCountQueryColumn999", 100);
        r = cq.execute();
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)0, (Object)r.get());
    }

    @Test
    public void testSuperCountQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 1, "testSuperCountQuery", 11, "testSuperCountQueryColumn");
        SuperCountQuery cq = HFactory.createSuperCountQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se);
        cq.setColumnFamily(cf).setKey((Object)"testSuperCountQuery0");
        cq.setRange((Object)"testSuperCountQueryColumn", (Object)"testSuperCountQueryColumn999", 100);
        QueryResult r = cq.execute();
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)11, (Object)r.get());
        this.deleteColumns(cleanup);
    }

    @Test
    public void testSubCountQuery() {
        String cf = "Super1";
        TestCleanupDescriptor cleanup = this.insertSuperColumns(cf, 1, "testSubCountQuery", 1, "testSubCountQueryColumn");
        SubCountQuery cq = HFactory.createSubCountQuery((Keyspace)this.ko, (Serializer)se, (Serializer)se, (Serializer)se);
        cq.setRange((Object)"c0", (Object)"c3", 100);
        QueryResult r = cq.setColumnFamily(cf).setKey((Object)"testSubCountQuery0").setSuperColumn((Object)"testSubCountQueryColumn0").execute();
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)2, (Object)r.get());
        this.deleteColumns(cleanup);
    }

    private void deleteColumns(TestCleanupDescriptor cleanup) {
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int i = 0; i < cleanup.rowCount; ++i) {
            for (int j = 0; j < cleanup.columnCount; ++j) {
                m.addDeletion((Object)(cleanup.rowPrefix + i), cleanup.cf, (Object)(cleanup.columnsPrefix + j), (Serializer)se);
            }
        }
        m.execute();
    }

    private TestCleanupDescriptor insertSuperColumns(String cf, int rowCount, String rowPrefix, int scCount, String scPrefix) {
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < scCount; ++j) {
                HSuperColumn sc = HFactory.createSuperColumn((Object)(scPrefix + j), Arrays.asList(HFactory.createColumn((Object)("c0" + i + j), (Object)("v0" + i + j), (Serializer)se, (Serializer)se), HFactory.createColumn((Object)("c11" + j), (Object)("v1" + i + j), (Serializer)se, (Serializer)se)), (Serializer)se, (Serializer)se, (Serializer)se);
                m.addInsertion((Object)(rowPrefix + i), cf, sc);
            }
        }
        m.execute();
        return new TestCleanupDescriptor(cf, rowCount, rowPrefix, scCount, scPrefix);
    }

    private TestCleanupDescriptor insertSuperCountColumns(String cf, int rowCount, String rowPrefix, int scCount, String scPrefix) {
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < scCount; ++j) {
                HCounterSuperColumn sc = HFactory.createCounterSuperColumn((Object)(scPrefix + j), Arrays.asList(HFactory.createCounterColumn((String)("c0" + i + j), (long)(i + j)), HFactory.createCounterColumn((String)("c11" + j), (long)(i + j))), (Serializer)se, (Serializer)se);
                m.addCounter((Object)(rowPrefix + i), cf, sc);
            }
        }
        m.execute();
        return new TestCleanupDescriptor(cf, rowCount, rowPrefix, scCount, scPrefix);
    }

    private TestCleanupDescriptor insertColumns(String cf, int rowCount, String rowPrefix, int columnCount, String columnPrefix) {
        Mutator m = HFactory.createMutator((Keyspace)this.ko, (Serializer)se);
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                m.addInsertion((Object)(rowPrefix + i), cf, HFactory.createColumn((Object)(columnPrefix + j), (Object)("value" + i + j), (Serializer)se, (Serializer)se));
            }
        }
        MutationResult mr = m.execute();
        log.debug("insert execution time: {}", (Object)mr.getExecutionTimeMicro());
        log.debug(mr.toString());
        return new TestCleanupDescriptor(cf, rowCount, rowPrefix, columnCount, columnPrefix);
    }

    private static class TestCleanupDescriptor {
        public final String cf;
        public final int rowCount;
        public final String rowPrefix;
        public final int columnCount;
        public final String columnsPrefix;

        public TestCleanupDescriptor(String cf, int rowCount, String rowPrefix, int scCount, String scPrefix) {
            this.cf = cf;
            this.rowCount = rowCount;
            this.rowPrefix = rowPrefix;
            this.columnCount = scCount;
            this.columnsPrefix = scPrefix;
        }
    }
}

