/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.BigIntegerSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.utils.TimeUUIDUtils;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.AbstractComposite;
import me.prettyprint.hector.api.beans.Composite;
import me.prettyprint.hector.api.beans.DynamicComposite;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.DynamicCompositeType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.junit.Assert;
import org.junit.Test;

public class CompositeTest {
    @Test
    public void testDynamicSerialization() throws Exception {
        DynamicComposite c = new DynamicComposite();
        c.add((Object)"String1");
        ByteBuffer b = c.serialize();
        Assert.assertEquals((long)b.remaining(), (long)12L);
        c.add((Object)"String2");
        b = c.serialize();
        Assert.assertEquals((long)b.remaining(), (long)24L);
        c = new DynamicComposite();
        c.deserialize(b);
        Assert.assertEquals((long)2L, (long)c.size());
        Object o = c.get(0);
        Assert.assertEquals((Object)"String1", (Object)o);
        o = c.get(1);
        Assert.assertEquals((Object)"String2", (Object)o);
        c = new DynamicComposite();
        c.add((Object)new Long(10L));
        b = c.serialize();
        c = new DynamicComposite();
        c.deserialize(b);
        o = c.get(0);
        Assert.assertTrue((boolean)(o instanceof Long));
        c = new DynamicComposite();
        c.add((Object)UUID.randomUUID());
        b = c.serialize();
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        o = c.get(0);
        Assert.assertTrue((boolean)(o instanceof UUID));
        Assert.assertEquals((Object)ComparatorType.UUIDTYPE.getTypeName(), (Object)c.getComponent(0).getComparator());
        c = new DynamicComposite();
        c.add((Object)TimeUUIDUtils.getUniqueTimeUUIDinMillis());
        b = c.serialize();
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        o = c.get(0);
        Assert.assertTrue((boolean)(o instanceof UUID));
        Assert.assertEquals((Object)ComparatorType.UUIDTYPE.getTypeName(), (Object)c.getComponent(0).getComparator());
        b = this.createDynamicCompositeKey("Hello", TimeUUIDUtils.getUniqueTimeUUIDinMillis(), 10, false);
        c = new DynamicComposite();
        c.deserialize(b.slice());
        o = c.get(0);
        Assert.assertTrue((boolean)(o instanceof ByteBuffer));
        Assert.assertEquals((Object)"Hello", (Object)c.get(0, (Serializer)StringSerializer.get()));
        o = c.get(1);
        Assert.assertEquals(UUID.class, o.getClass());
        o = c.get(2);
        Assert.assertEquals(BigInteger.class, o.getClass());
        Assert.assertEquals((Object)BigInteger.valueOf(10L), (Object)o);
        c = new DynamicComposite();
        c.deserialize(b.slice());
        Assert.assertTrue((boolean)(c.get(0, (Serializer)ByteBufferSerializer.get()) instanceof ByteBuffer));
        Assert.assertTrue((boolean)(c.get(1, (Serializer)ByteBufferSerializer.get()) instanceof ByteBuffer));
        Assert.assertTrue((boolean)(c.get(2, (Serializer)ByteBufferSerializer.get()) instanceof ByteBuffer));
        c = new DynamicComposite();
        c.setSerializersByPosition(new Serializer[]{StringSerializer.get(), null, ByteBufferSerializer.get()});
        c.deserialize(b.slice());
        Assert.assertTrue((boolean)(c.get(0) instanceof String));
        Assert.assertTrue((boolean)(c.get(1) instanceof UUID));
        Assert.assertTrue((boolean)(c.get(2) instanceof ByteBuffer));
        b = DynamicComposite.toByteBuffer((Object[])new Object[]{1, "string", TimeUUIDUtils.getUniqueTimeUUIDinMillis()});
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        Assert.assertTrue((boolean)(c.get(0) instanceof BigInteger));
        Assert.assertTrue((boolean)(c.get(1) instanceof String));
        Assert.assertTrue((boolean)(c.get(2) instanceof UUID));
        b = DynamicComposite.toByteBuffer((Object[])new Object[]{1L, "string", TimeUUIDUtils.getUniqueTimeUUIDinMillis()});
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        Assert.assertTrue((boolean)(c.get(0) instanceof Long));
        Assert.assertTrue((boolean)(c.get(1) instanceof String));
        Assert.assertTrue((boolean)(c.get(2) instanceof UUID));
        b = DynamicComposite.toByteBuffer((Object[])new Object[]{(byte)1, "string", UUID.randomUUID()});
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        Assert.assertTrue((boolean)(c.get(0) instanceof BigInteger));
        Assert.assertTrue((boolean)(c.get(1) instanceof String));
        Assert.assertTrue((boolean)(c.get(2) instanceof UUID));
        b = DynamicComposite.toByteBuffer(Arrays.asList(Arrays.asList(0, 1, 2), 3, 4, 5, Arrays.asList(6, 7, 8)));
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        for (int i = 0; i < 9; ++i) {
            o = c.get(i);
            Assert.assertTrue((boolean)(o instanceof BigInteger));
            Assert.assertEquals((long)i, (long)((BigInteger)o).intValue());
        }
        b = DynamicComposite.toByteBuffer((Object[])new Object[]{"foo"});
        c = DynamicComposite.fromByteBuffer((ByteBuffer)b);
        b = c.getComponent(0).getBytes();
        UTF8Type.instance.validate(b);
    }

    @Test
    public void testNullValueSerialization() throws Exception {
        DynamicComposite c = new DynamicComposite();
        try {
            c.addComponent(null, (Serializer)StringSerializer.get());
            Assert.fail((String)"Null values not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testStaticSerialization() throws Exception {
        ByteBuffer b = CompositeTest.createCompositeKey("Hello", TimeUUIDUtils.getUniqueTimeUUIDinMillis(), 10, false);
        Composite c = new Composite();
        c.setSerializersByPosition(new Serializer[]{StringSerializer.get(), UUIDSerializer.get(), BigIntegerSerializer.get()});
        c.deserialize(b.slice());
        Assert.assertTrue((boolean)(c.get(0) instanceof String));
        Assert.assertTrue((boolean)(c.get(1) instanceof UUID));
        Assert.assertTrue((boolean)(c.get(2) instanceof BigInteger));
    }

    @Test
    public void testEmptyStringSerialization() throws Exception {
        ByteBuffer b = CompositeTest.createCompositeKey("", TimeUUIDUtils.getUniqueTimeUUIDinMillis(), 10, false);
        Composite c = new Composite();
        c.setSerializersByPosition(new Serializer[]{StringSerializer.get(), UUIDSerializer.get(), BigIntegerSerializer.get()});
        c.deserialize(b.slice());
        Assert.assertTrue((boolean)(c.get(0) instanceof String));
        Assert.assertTrue((boolean)(c.get(1) instanceof UUID));
        Assert.assertTrue((boolean)(c.get(2) instanceof BigInteger));
    }

    @Test
    public void testEquality() throws Exception {
        DynamicCompositeType instance = this.getDefaultDynamicComparator();
        DynamicComposite c1 = new DynamicComposite(new Object[]{10, "foo"});
        DynamicComposite c2 = new DynamicComposite(new Object[]{10, "foo"});
        Assert.assertEquals((long)0L, (long)instance.compare(c1.serialize(), c2.serialize()));
        c2.setEquality(AbstractComposite.ComponentEquality.GREATER_THAN_EQUAL);
        Assert.assertEquals((long)-1L, (long)instance.compare(c1.serialize(), c2.serialize()));
        c2.setEquality(AbstractComposite.ComponentEquality.LESS_THAN_EQUAL);
        Assert.assertEquals((long)1L, (long)instance.compare(c1.serialize(), c2.serialize()));
        c2.setEquality(AbstractComposite.ComponentEquality.EQUAL);
        Assert.assertEquals((long)0L, (long)instance.compare(c1.serialize(), c2.serialize()));
        c1.setEquality(AbstractComposite.ComponentEquality.LESS_THAN_EQUAL);
        Assert.assertEquals((long)-1L, (long)instance.compare(c1.serialize(), c2.serialize()));
        c1.setEquality(AbstractComposite.ComponentEquality.GREATER_THAN_EQUAL);
        Assert.assertEquals((long)1L, (long)instance.compare(c1.serialize(), c2.serialize()));
    }

    private ByteBuffer createDynamicCompositeKey(String s, UUID uuid, int i, boolean lastIsOne) {
        ByteBuffer bytes = ByteBufferUtil.bytes((String)s);
        int totalSize = 0;
        if (s != null) {
            totalSize += 4 + bytes.remaining() + 1;
            if (uuid != null) {
                totalSize += 21;
                if (i != -1) {
                    totalSize += 2 + "IntegerType".length() + 2 + 1 + 1;
                }
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(totalSize);
        if (s != null) {
            bb.putShort((short)-32670);
            bb.putShort((short)bytes.remaining());
            bb.put(bytes);
            bb.put(uuid == null && lastIsOne ? (byte)1 : 0);
            if (uuid != null) {
                bb.putShort((short)-32652);
                bb.putShort((short)16);
                bb.put(UUIDGen.decompose((UUID)uuid));
                bb.put(i == -1 && lastIsOne ? (byte)1 : 0);
                if (i != -1) {
                    bb.putShort((short)"IntegerType".length());
                    bb.put(ByteBufferUtil.bytes((String)"IntegerType"));
                    bb.putShort((short)1);
                    bb.put((byte)i);
                    bb.put(lastIsOne ? (byte)1 : 0);
                }
            }
        }
        bb.rewind();
        return bb;
    }

    static ByteBuffer createCompositeKey(String s, UUID uuid, int i, boolean lastIsOne) {
        ByteBuffer bytes = ByteBufferUtil.bytes((String)s);
        int totalSize = 0;
        if (s != null) {
            totalSize += 2 + bytes.remaining() + 1;
            if (uuid != null) {
                totalSize += 19;
                if (i != -1) {
                    totalSize += 4;
                }
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(totalSize);
        if (s != null) {
            bb.putShort((short)bytes.remaining());
            bb.put(bytes);
            bb.put(uuid == null && lastIsOne ? (byte)1 : 0);
            if (uuid != null) {
                bb.putShort((short)16);
                bb.put(UUIDGen.decompose((UUID)uuid));
                bb.put(i == -1 && lastIsOne ? (byte)1 : 0);
                if (i != -1) {
                    bb.putShort((short)1);
                    bb.put((byte)i);
                    bb.put(lastIsOne ? (byte)1 : 0);
                }
            }
        }
        bb.rewind();
        return bb;
    }

    public DynamicCompositeType getDefaultDynamicComparator() {
        HashMap<Byte, Object> aliases = new HashMap<Byte, Object>();
        aliases.put((byte)97, AsciiType.instance);
        aliases.put((byte)98, BytesType.instance);
        aliases.put((byte)105, IntegerType.instance);
        aliases.put((byte)120, LexicalUUIDType.instance);
        aliases.put((byte)108, LongType.instance);
        aliases.put((byte)116, TimeUUIDType.instance);
        aliases.put((byte)115, UTF8Type.instance);
        aliases.put((byte)117, UUIDType.instance);
        DynamicCompositeType comparator = DynamicCompositeType.getInstance(aliases);
        return comparator;
    }
}

