/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api;

import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.clock.MicrosecondsClockResolution;
import me.prettyprint.cassandra.service.clock.MicrosecondsSyncClockResolution;
import me.prettyprint.cassandra.service.clock.MillisecondsClockResolution;
import me.prettyprint.cassandra.service.clock.SecondsClockResolution;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import org.junit.Assert;
import org.junit.Test;

public class HFactoryTest {
    @Test
    public void testCreateClockResolution() throws Exception {
        try {
            HFactory.createClockResolution((String)"ItDoesNotExist");
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)(HFactory.createClockResolution((String)"SECONDS") instanceof SecondsClockResolution));
        Assert.assertTrue((boolean)(HFactory.createClockResolution((String)"MILLISECONDS") instanceof MillisecondsClockResolution));
        Assert.assertTrue((boolean)(HFactory.createClockResolution((String)"MICROSECONDS") instanceof MicrosecondsClockResolution));
        Assert.assertTrue((boolean)(HFactory.createClockResolution((String)"MICROSECONDS_SYNC") instanceof MicrosecondsSyncClockResolution));
    }

    @Test
    public void testCreateColumn() {
        long clock = HFactory.createClock();
        HColumn col = HFactory.createColumn((Object)"nameString", (Object)new Long("345"), (long)clock);
        HColumn col2 = HFactory.createColumn((Object)"nameString", (Object)new Long("345"), (long)clock, (Serializer)StringSerializer.get(), (Serializer)LongSerializer.get());
        Assert.assertEquals((Object)col.getName(), (Object)col2.getName());
        Assert.assertEquals((Object)col.getValue(), (Object)col2.getValue());
        Assert.assertEquals((long)col.getClock(), (long)col2.getClock());
    }
}

