/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api;

import java.util.ArrayList;
import java.util.List;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.ThriftColumnDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.ComparatorType;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class KeyspaceCreationTest
extends BaseEmbededServerSetupTest {
    private static final Logger log = LoggerFactory.getLogger(KeyspaceCreationTest.class);
    private static final String KEYSPACE = "Keyspace2";
    private static final StringSerializer se = new StringSerializer();
    private Cluster cluster;
    private static final int colCount = 6;

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"MyCluster", (String)"127.0.0.1:9170");
    }

    @After
    public void teardownCase() {
        this.cluster = null;
    }

    @Test
    public void testCreateKeyspace() throws InvalidRequestException, TException {
        ArrayList<ColumnFamilyDefinition> cf_defs = new ArrayList<ColumnFamilyDefinition>();
        ArrayList<ColumnDef> columns = new ArrayList<ColumnDef>();
        for (int i = 0; i < 6; ++i) {
            String cName = "col" + i;
            log.info("Creating column " + cName);
            columns.add(this.newIndexedColumnDef(cName, "BytesType"));
        }
        List columnMetadata = ThriftColumnDef.fromThriftList(columns);
        ColumnFamilyDefinition cf_def = HFactory.createColumnFamilyDefinition((String)KEYSPACE, (String)"TEST_CF", (ComparatorType)ComparatorType.BYTESTYPE, (List)columnMetadata);
        cf_defs.add(cf_def);
        this.makeKeyspace(KEYSPACE, cf_defs);
        this.checkKeyspaces();
        log.info("Done, all errors to console after this point likely due to shutdown");
    }

    public void checkKeyspaces() {
        List ksDefs = null;
        try {
            ksDefs = this.cluster.describeKeyspaces();
        }
        catch (Exception e) {
            log.error("Unable to describe keyspaces", (Throwable)e);
        }
        if (ksDefs != null) {
            for (KeyspaceDefinition ksDef : ksDefs) {
                log.info(ksDef.getName().toString());
            }
        }
    }

    ColumnDef newIndexedColumnDef(String column_name, String comparer) {
        ColumnDef cd = new ColumnDef(se.toByteBuffer(column_name), comparer);
        cd.setIndex_name(column_name);
        cd.setIndex_type(IndexType.KEYS);
        return cd;
    }

    public void makeKeyspace(String keyspace, List<ColumnFamilyDefinition> cf_defs) throws InvalidRequestException, TException {
        log.info("Creating keyspace: " + keyspace);
        try {
            KeyspaceDefinition ks_def = HFactory.createKeyspaceDefinition((String)keyspace, (String)"org.apache.cassandra.locator.SimpleStrategy", (int)1, cf_defs);
            this.cluster.addKeyspace(ks_def);
            log.info("Created keyspace: " + keyspace);
        }
        catch (Exception e) {
            log.error("Unable to create keyspace " + keyspace, (Throwable)e);
        }
    }
}

