/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api.beans;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.AsciiSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.DynamicCompositeSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.TimeUUIDSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.ColumnSliceIterator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.AbstractComposite;
import me.prettyprint.hector.api.beans.DynamicComposite;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.SliceQuery;
import me.prettyprint.hector.testutils.EmbeddedServerHelper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DynamicCompositeTest {
    private static DynamicCompositeSerializer ds = DynamicCompositeSerializer.get();
    private static StringSerializer ss = StringSerializer.get();
    private static UUIDSerializer us = UUIDSerializer.get();
    private static Serializer<UUID> uss = UUIDSerializer.get();
    private static EmbeddedServerHelper embedded;

    @BeforeClass
    public static void setup() throws Exception {
        embedded = new EmbeddedServerHelper();
        embedded.setup();
    }

    @AfterClass
    public static void teardown() throws Exception {
        EmbeddedServerHelper.teardown();
    }

    @Test
    public void allTypesSerialize() {
        DynamicComposite composite = new DynamicComposite();
        UUID lexUUID = UUID.randomUUID();
        com.eaio.uuid.UUID timeUUID = new com.eaio.uuid.UUID();
        composite.addComponent(0, (Object)"AsciiText", (Serializer)AsciiSerializer.get(), "AsciiType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(1, (Object)new byte[]{0, 1, 2, 3}, (Serializer)BytesArraySerializer.get(), "BytesType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(2, (Object)-1, (Serializer)IntegerSerializer.get(), "IntegerType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(3, (Object)lexUUID, (Serializer)UUIDSerializer.get(), "LexicalUUIDType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(4, (Object)-1L, (Serializer)LongSerializer.get(), "LongType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(5, (Object)timeUUID, (Serializer)TimeUUIDSerializer.get(), "TimeUUIDType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(6, (Object)"UTF8Text", (Serializer)StringSerializer.get(), "UTF8Type", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(7, (Object)lexUUID, (Serializer)UUIDSerializer.get(), "UUIDType", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(8, (Object)"AsciiText", (Serializer)AsciiSerializer.get(), "AsciiType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(9, (Object)new byte[]{0, 1, 2, 3}, (Serializer)BytesArraySerializer.get(), "BytesType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(10, (Object)-1, (Serializer)IntegerSerializer.get(), "IntegerType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(11, (Object)lexUUID, (Serializer)UUIDSerializer.get(), "LexicalUUIDType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(12, (Object)-1L, (Serializer)LongSerializer.get(), "LongType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(13, (Object)timeUUID, (Serializer)TimeUUIDSerializer.get(), "TimeUUIDType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(14, (Object)"UTF8Text", (Serializer)StringSerializer.get(), "UTF8Type(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(15, (Object)lexUUID, (Serializer)UUIDSerializer.get(), "UUIDType(reversed=true)", AbstractComposite.ComponentEquality.EQUAL);
        composite.addComponent(16, (Object)"My element", AbstractComposite.ComponentEquality.EQUAL);
        ByteBuffer buffer = DynamicCompositeSerializer.get().toByteBuffer(composite);
        DynamicComposite parsed = DynamicCompositeSerializer.get().fromByteBuffer(buffer);
        Assert.assertEquals((Object)"AsciiText", (Object)parsed.get(0, (Serializer)AsciiSerializer.get()));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])((byte[])parsed.get(1, (Serializer)BytesArraySerializer.get())));
        Assert.assertEquals((Object)-1, (Object)parsed.get(2, (Serializer)IntegerSerializer.get()));
        Assert.assertEquals((Object)lexUUID, (Object)parsed.get(3, (Serializer)UUIDSerializer.get()));
        Assert.assertEquals((Object)-1L, (Object)parsed.get(4, (Serializer)LongSerializer.get()));
        Assert.assertEquals((Object)timeUUID, (Object)parsed.get(5, (Serializer)TimeUUIDSerializer.get()));
        Assert.assertEquals((Object)"UTF8Text", (Object)parsed.get(6, (Serializer)StringSerializer.get()));
        Assert.assertEquals((Object)lexUUID, (Object)parsed.get(7, (Serializer)UUIDSerializer.get()));
        Assert.assertEquals((Object)"AsciiText", (Object)parsed.get(8, (Serializer)AsciiSerializer.get()));
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2, 3}, (byte[])((byte[])parsed.get(9, (Serializer)BytesArraySerializer.get())));
        Assert.assertEquals((Object)-1, (Object)parsed.get(10, (Serializer)IntegerSerializer.get()));
        Assert.assertEquals((Object)lexUUID, (Object)parsed.get(11, (Serializer)UUIDSerializer.get()));
        Assert.assertEquals((Object)-1L, (Object)parsed.get(12, (Serializer)LongSerializer.get()));
        Assert.assertEquals((Object)timeUUID, (Object)parsed.get(13, (Serializer)TimeUUIDSerializer.get()));
        Assert.assertEquals((Object)"UTF8Text", (Object)parsed.get(14, (Serializer)StringSerializer.get()));
        Assert.assertEquals((Object)lexUUID, (Object)parsed.get(15, (Serializer)UUIDSerializer.get()));
        Assert.assertEquals((Object)"My element", (Object)parsed.get(16, (Serializer)StringSerializer.get()));
    }

    @Test
    public void testUUIDGetAll() {
        Cluster c = HFactory.getOrCreateCluster((String)"MyCluster", (String)"localhost:9170");
        Keyspace ks = HFactory.createKeyspace((String)"Keyspace1", (Cluster)c);
        String key = "rowKey";
        String cf = "DynamicComposite1";
        this.init(ks, key, cf);
        HashSet<UUID> results = new HashSet<UUID>();
        ColumnSliceIterator<String, DynamicComposite, String> iterator = this.getIterator(ks, cf, key, null, null);
        while (iterator.hasNext()) {
            HColumn column = iterator.next();
            DynamicComposite composite = (DynamicComposite)column.getName();
            UUID component1 = (UUID)composite.get(1, (Serializer)us);
            results.add(component1);
        }
        Assert.assertEquals((String)"Failed to retrieve all columns", (long)8L, (long)results.size());
        this.clear(ks, key, cf);
    }

    @Test
    public void testUUIDGetSlice() {
        Cluster c = HFactory.getOrCreateCluster((String)"MyCluster", (String)"localhost:9170");
        Keyspace ks = HFactory.createKeyspace((String)"Keyspace1", (Cluster)c);
        String key = "rowKey";
        String cf = "DynamicComposite1";
        Map<UUID, Set<UUID>> ids = this.init(ks, key, cf);
        for (Map.Entry<UUID, Set<UUID>> entry : ids.entrySet()) {
            UUID component0 = entry.getKey();
            DynamicComposite start = new DynamicComposite();
            start.addComponent((Object)component0, (Serializer)us);
            DynamicComposite end = new DynamicComposite();
            end.addComponent((Object)component0, (Serializer)us, us.getComparatorType().getTypeName(), AbstractComposite.ComponentEquality.GREATER_THAN_EQUAL);
            ColumnSliceIterator<String, DynamicComposite, String> iterator = this.getIterator(ks, cf, key, start, end);
            while (iterator.hasNext()) {
                HColumn column = iterator.next();
                DynamicComposite composite = (DynamicComposite)column.getName();
                Assert.assertEquals((Object)component0, (Object)composite.get(0, (Serializer)us));
                Assert.assertTrue((boolean)ids.get(component0).contains(composite.get(1, (Serializer)us)));
            }
        }
        this.clear(ks, key, cf);
    }

    @Test
    public void testStringGetSlice() {
        Cluster c = HFactory.getOrCreateCluster((String)"MyCluster", (String)"localhost:9170");
        Keyspace ks = HFactory.createKeyspace((String)"Keyspace1", (Cluster)c);
        String key = "rowKey";
        String cf = "DynamicComposite1";
        Mutator mutator = HFactory.createMutator((Keyspace)ks, (Serializer)ss);
        DynamicComposite composite = new DynamicComposite().addComponent((Object)"a", (Serializer)ss).addComponent((Object)"ba", (Serializer)ss).addComponent((Object)"ca", (Serializer)ss).addComponent((Object)"da", (Serializer)ss);
        mutator.addInsertion((Object)key, cf, HFactory.createColumn((Object)composite, (Object)composite.toString(), (Serializer)ds, (Serializer)ss));
        composite = new DynamicComposite().addComponent((Object)"a", (Serializer)ss).addComponent((Object)"bb", (Serializer)ss).addComponent((Object)"cb", (Serializer)ss).addComponent((Object)"db", (Serializer)ss);
        mutator.addInsertion((Object)key, cf, HFactory.createColumn((Object)composite, (Object)composite.toString(), (Serializer)ds, (Serializer)ss));
        composite = new DynamicComposite().addComponent((Object)"b", (Serializer)ss).addComponent((Object)"ba", (Serializer)ss).addComponent((Object)"ca", (Serializer)ss).addComponent((Object)"da", (Serializer)ss);
        mutator.addInsertion((Object)key, cf, HFactory.createColumn((Object)composite, (Object)composite.toString(), (Serializer)ds, (Serializer)ss));
        composite = new DynamicComposite().addComponent((Object)"b", (Serializer)ss).addComponent((Object)"bb", (Serializer)ss).addComponent((Object)"cb", (Serializer)ss).addComponent((Object)"db", (Serializer)ss);
        mutator.addInsertion((Object)key, cf, HFactory.createColumn((Object)composite, (Object)composite.toString(), (Serializer)ds, (Serializer)ss));
        mutator.execute();
        String compType = ss.getComparatorType().getTypeName();
        System.out.println("LESS_THAN_EQUAL");
        DynamicComposite end = new DynamicComposite().addComponent((Object)"b", (Serializer)ss, compType).addComponent((Object)"ba", (Serializer)ss).addComponent((Object)"ca", (Serializer)ss).addComponent((Object)"da", (Serializer)ss, compType, AbstractComposite.ComponentEquality.LESS_THAN_EQUAL);
        ColumnSliceIterator<String, DynamicComposite, String> iterator = this.getIterator(ks, cf, key, null, end);
        while (iterator.hasNext()) {
            System.out.println(iterator.next().getName());
        }
        System.out.println("EQUAL");
        end = new DynamicComposite().addComponent((Object)"b", (Serializer)ss, compType).addComponent((Object)"ba", (Serializer)ss).addComponent((Object)"ca", (Serializer)ss).addComponent((Object)"da", (Serializer)ss, compType, AbstractComposite.ComponentEquality.EQUAL);
        iterator = this.getIterator(ks, cf, key, null, end);
        while (iterator.hasNext()) {
            System.out.println(iterator.next().getName());
        }
        System.out.println("GREATER_THAN_EQUAL");
        end = new DynamicComposite().addComponent((Object)"b", (Serializer)ss, compType).addComponent((Object)"bb", (Serializer)ss, compType, AbstractComposite.ComponentEquality.GREATER_THAN_EQUAL);
        iterator = this.getIterator(ks, cf, key, null, end);
        while (iterator.hasNext()) {
            System.out.println(iterator.next().getName());
        }
    }

    private ColumnSliceIterator<String, DynamicComposite, String> getIterator(Keyspace ks, String cf, String key, DynamicComposite start, DynamicComposite end) {
        SliceQuery query = HFactory.createSliceQuery((Keyspace)ks, (Serializer)ss, (Serializer)ds, (Serializer)ss).setColumnFamily(cf).setKey((Object)key);
        return new ColumnSliceIterator(query, (Object)start, (Object)end, false);
    }

    private Map<UUID, Set<UUID>> init(Keyspace ks, String key, String cf) {
        Mutator mutator = HFactory.createMutator((Keyspace)ks, (Serializer)ss);
        HashMap<UUID, Set<UUID>> ids = new HashMap<UUID, Set<UUID>>();
        ids.put(UUID.randomUUID(), new HashSet());
        ids.put(UUID.randomUUID(), new HashSet());
        for (Map.Entry entry : ids.entrySet()) {
            for (int i = 0; i < 4; ++i) {
                UUID uuid = UUID.randomUUID();
                DynamicComposite composite = new DynamicComposite().addComponent(entry.getKey(), uss).addComponent((Object)uuid, uss);
                mutator.addInsertion((Object)key, cf, HFactory.createColumn((Object)composite, (Object)composite.toString(), (Serializer)ds, (Serializer)ss));
                ((Set)entry.getValue()).add(uuid);
            }
        }
        mutator.execute();
        return ids;
    }

    private void clear(Keyspace ks, String key, String cf) {
        Mutator mutator = HFactory.createMutator((Keyspace)ks, (Serializer)ss);
        mutator.addDeletion((Object)key, cf);
        mutator.execute();
    }
}

