/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.api.ddl;

import me.prettyprint.hector.api.ddl.ComparatorType;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorTypeTest {
    @Test
    public void getByClassNameShouldReturnNullWhenNullClassName() {
        Assert.assertEquals(null, (Object)ComparatorType.getByClassName(null));
    }

    @Test
    public void getByClassNameShouldReturnCorrectCustomComaparator() {
        ComparatorType comparator = ComparatorType.getByClassName((String)"com.custom.Comparator");
        Assert.assertEquals((Object)"com.custom.Comparator", (Object)comparator.getClassName());
        Assert.assertEquals((Object)"com.custom.Comparator", (Object)comparator.getTypeName());
    }

    @Test
    public void getByClassNameShouldReturnCorrectUnknownComaparator() {
        ComparatorType comparator = ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.SomeNewType");
        Assert.assertEquals((Object)"org.apache.cassandra.db.marshal.SomeNewType", (Object)comparator.getClassName());
        Assert.assertEquals((Object)"SomeNewType", (Object)comparator.getTypeName());
    }

    @Test
    public void getByClassNameShouldReturnCorrectKnownComaparators() {
        Assert.assertEquals((Object)ComparatorType.ASCIITYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.AsciiType"));
        Assert.assertEquals((Object)ComparatorType.ASCIITYPE, (Object)ComparatorType.getByClassName((String)"AsciiType"));
        Assert.assertEquals((Object)ComparatorType.BYTESTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.BytesType"));
        Assert.assertEquals((Object)ComparatorType.BYTESTYPE, (Object)ComparatorType.getByClassName((String)"BytesType"));
        Assert.assertEquals((Object)ComparatorType.INTEGERTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.IntegerType"));
        Assert.assertEquals((Object)ComparatorType.INTEGERTYPE, (Object)ComparatorType.getByClassName((String)"IntegerType"));
        Assert.assertEquals((Object)ComparatorType.LEXICALUUIDTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.LexicalUUIDType"));
        Assert.assertEquals((Object)ComparatorType.LEXICALUUIDTYPE, (Object)ComparatorType.getByClassName((String)"LexicalUUIDType"));
        Assert.assertEquals((Object)ComparatorType.LOCALBYPARTITIONERTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.LocalByPartionerType"));
        Assert.assertEquals((Object)ComparatorType.LOCALBYPARTITIONERTYPE, (Object)ComparatorType.getByClassName((String)"LocalByPartionerType"));
        Assert.assertEquals((Object)ComparatorType.LONGTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.LongType"));
        Assert.assertEquals((Object)ComparatorType.LONGTYPE, (Object)ComparatorType.getByClassName((String)"LongType"));
        Assert.assertEquals((Object)ComparatorType.TIMEUUIDTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.TimeUUIDType"));
        Assert.assertEquals((Object)ComparatorType.TIMEUUIDTYPE, (Object)ComparatorType.getByClassName((String)"TimeUUIDType"));
        Assert.assertEquals((Object)ComparatorType.UTF8TYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.UTF8Type"));
        Assert.assertEquals((Object)ComparatorType.UTF8TYPE, (Object)ComparatorType.getByClassName((String)"UTF8Type"));
        Assert.assertEquals((Object)ComparatorType.COMPOSITETYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.CompositeType"));
        Assert.assertEquals((Object)ComparatorType.COMPOSITETYPE, (Object)ComparatorType.getByClassName((String)"CompositeType"));
        Assert.assertEquals((Object)ComparatorType.DYNAMICCOMPOSITETYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.DynamicCompositeType"));
        Assert.assertEquals((Object)ComparatorType.DYNAMICCOMPOSITETYPE, (Object)ComparatorType.getByClassName((String)"DynamicCompositeType"));
        Assert.assertEquals((Object)ComparatorType.UUIDTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.UUIDType"));
        Assert.assertEquals((Object)ComparatorType.UUIDTYPE, (Object)ComparatorType.getByClassName((String)"UUIDType"));
        Assert.assertEquals((Object)ComparatorType.COUNTERTYPE, (Object)ComparatorType.getByClassName((String)"org.apache.cassandra.db.marshal.CounterColumnType"));
        Assert.assertEquals((Object)ComparatorType.COUNTERTYPE, (Object)ComparatorType.getByClassName((String)"CounterColumnType"));
    }
}

