/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.converters;

import java.math.BigInteger;
import me.prettyprint.cassandra.serializers.BigIntegerSerializer;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.converters.Converter;

public class VariableIntegerConverter
implements Converter<Object> {
    @Override
    public Object convertCassTypeToObjType(PropertyMappingDefinition md, byte[] value) {
        BigInteger bigInt = new BigInteger(value);
        Class<?> targetClass = md.getPropDesc().getPropertyType();
        if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
            return bigInt.intValue();
        }
        if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
            return bigInt.longValue();
        }
        if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
            return bigInt.shortValue();
        }
        if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
            return bigInt.byteValue();
        }
        if (targetClass.equals(BigInteger.class)) {
            return bigInt;
        }
        throw new HectorObjectMapperException("Column, " + md.getColName() + ", cannot be converted using " + this.getClass().getSimpleName() + " because POJO property, " + md.getPropDesc().getName() + ", of type " + md.getPropDesc().getPropertyType().getName() + " is not an integer type (in a mathematical context)");
    }

    @Override
    public byte[] convertObjTypeToCassType(Object value) {
        BigInteger bigInt;
        if (value instanceof Byte) {
            bigInt = BigInteger.valueOf(((Byte)value).longValue());
        } else if (value instanceof Short) {
            bigInt = BigInteger.valueOf(((Short)value).longValue());
        } else if (value instanceof Integer) {
            bigInt = BigInteger.valueOf(((Integer)value).longValue());
        } else if (value instanceof Long) {
            bigInt = BigInteger.valueOf((Long)value);
        } else if (value instanceof BigInteger) {
            bigInt = (BigInteger)value;
        } else {
            throw new HectorObjectMapperException("value of type " + value.getClass().getName() + " is not an integer type (in a mathematical context) and cannot be converted to a variable integer type");
        }
        return BigIntegerSerializer.get().toBytes((Object)bigInt);
    }
}

