/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class TeradataSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public TeradataSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.getDialect().getVersion().isSameOrAfter(14)) {
            AbstractSqlAstTranslator.ForUpdateClause forUpdateClause = new AbstractSqlAstTranslator.ForUpdateClause();
            forUpdateClause.merge(this.getLockOptions());
            super.renderForUpdateClause(querySpec, forUpdateClause);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    protected String getForUpdate() {
        return "locking row for write ";
    }

    protected String getForShare(int timeoutMillis) {
        return "locking row for read ";
    }

    protected String getNoWait() {
        return "nowait ";
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.NONE;
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    protected boolean needsRowsToSkip() {
        return true;
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true, true);
        super.visitSqlSelections(selectClause);
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    protected void renderSearchClause(CteStatement cte) {
    }

    protected void renderCycleClause(CteStatement cte) {
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }
}

