/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.jboss.logging.Logger;

public final class Hibernate {
    public static final String ACTION_COMPLETED_TXN = "Execution of action caused managed transaction to be completed";
    private static final Logger log = Logger.getLogger((String)"org.hibernate.orm");

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(Object proxy) throws HibernateException {
        if (proxy == null) {
            return;
        }
        if (proxy instanceof HibernateProxy) {
            ((HibernateProxy)proxy).getHibernateLazyInitializer().initialize();
        } else if (proxy instanceof PersistentCollection) {
            ((PersistentCollection)proxy).forceInitialization();
        }
    }

    public static boolean isInitialized(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return !((HibernateProxy)proxy).getHibernateLazyInitializer().isUninitialized();
        }
        if (proxy instanceof PersistentCollection) {
            return ((PersistentCollection)proxy).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return ((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return proxy.getClass();
    }

    public static LobCreator getLobCreator(Session session) {
        return Hibernate.getLobCreator((SessionImplementor)session);
    }

    public static LobCreator getLobCreator(SharedSessionContractImplementor session) {
        return session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
    }

    public static LobCreator getLobCreator(SessionImplementor session) {
        return session.getFactory().getServiceRegistry().getService(JdbcServices.class).getLobCreator(session);
    }

    @Deprecated
    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object proxy, String propertyName) {
        PersistentAttributeInterceptor interceptor;
        Object entity;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return false;
            }
            entity = li.getImplementation();
        } else {
            entity = proxy;
        }
        if (entity instanceof PersistentAttributeInterceptable && (interceptor = ((PersistentAttributeInterceptable)entity).$$_hibernate_getInterceptor()) != null && interceptor instanceof LazyAttributeLoadingInterceptor) {
            return ((LazyAttributeLoadingInterceptor)interceptor).isAttributeLoaded(propertyName);
        }
        return true;
    }

    public static Object unproxy(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)proxy;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            return initializer.getImplementation();
        }
        return proxy;
    }

    public static <T> T unproxy(T proxy, Class<T> entityClass) {
        return entityClass.cast(Hibernate.unproxy(proxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <F extends SessionFactory, S extends Session> void inSession(F sessionfactory, Consumer<S> action) {
        log.trace((Object)"#inSession(factory,action)");
        try (Session session = sessionfactory.openSession();){
            log.trace((Object)"Session opened, calling action");
            action.accept(session);
            log.trace((Object)"called action");
        }
        finally {
            log.trace((Object)"Session closed (AutoCloseable)");
        }
    }

    public static <F extends SessionFactory, S extends Session> void inTransaction(F factory, Consumer<S> action) {
        log.trace((Object)"#inTransaction(factory, action)");
        Hibernate.inSession(factory, session -> Hibernate.inTransaction(session, action));
    }

    public static <S extends Session> void inTransaction(S session, Consumer<S> action) {
        log.trace((Object)"inTransaction(session,action)");
        Transaction txn = session.beginTransaction();
        log.trace((Object)"Started transaction");
        try {
            log.trace((Object)"Calling action in txn");
            action.accept(session);
            log.trace((Object)"Called action - in txn");
            if (!txn.isActive()) {
                throw new TransactionManagementException(ACTION_COMPLETED_TXN);
            }
        }
        catch (Exception e) {
            if (!txn.isActive()) {
                log.warn((Object)ACTION_COMPLETED_TXN, (Throwable)e);
            } else {
                log.trace((Object)"Rolling back transaction due to action error");
                try {
                    txn.rollback();
                    log.trace((Object)"Rolled back transaction due to action error");
                }
                catch (Exception inner) {
                    log.trace((Object)"Rolling back transaction due to action error failed; throwing original error");
                }
            }
            throw e;
        }
        log.trace((Object)"Committing transaction after successful action execution");
        try {
            txn.commit();
            log.trace((Object)"Committing transaction after successful action execution - success");
        }
        catch (Exception e) {
            log.trace((Object)"Committing transaction after successful action execution - failure");
            throw e;
        }
    }

    public static class TransactionManagementException
    extends RuntimeException {
        TransactionManagementException(String message) {
            super(message);
        }
    }
}

