/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.Iterator;
import org.hibernate.CallbackException;
import org.hibernate.EntityMode;
import org.hibernate.Transaction;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public interface Interceptor {
    default public boolean onLoad(Object entity, Object id, Object[] state, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        return this.onLoad(entity, (Serializable)id, state, propertyNames, javaTypeDescriptors);
    }

    @Deprecated
    default public boolean onLoad(Object entity, Serializable id, Object[] state, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        return false;
    }

    default public boolean onFlushDirty(Object entity, Object id, Object[] currentState, Object[] previousState, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        return this.onFlushDirty(entity, (Serializable)id, currentState, previousState, propertyNames, javaTypeDescriptors);
    }

    @Deprecated
    default public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        return false;
    }

    default public boolean onSave(Object entity, Object id, Object[] state, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        return this.onSave(entity, (Serializable)id, state, propertyNames, javaTypeDescriptors);
    }

    @Deprecated
    default public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        return false;
    }

    default public void onDelete(Object entity, Object id, Object[] state, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
        this.onDelete(entity, (Serializable)id, state, propertyNames, javaTypeDescriptors);
    }

    @Deprecated
    default public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) throws CallbackException {
    }

    default public void onCollectionRecreate(Object collection, Object key) throws CallbackException {
        this.onCollectionRecreate(collection, (Serializable)key);
    }

    @Deprecated
    default public void onCollectionRecreate(Object collection, Serializable key) throws CallbackException {
    }

    default public void onCollectionRemove(Object collection, Object key) throws CallbackException {
        this.onCollectionRemove(collection, (Serializable)key);
    }

    @Deprecated
    default public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
    }

    default public void onCollectionUpdate(Object collection, Object key) throws CallbackException {
        this.onCollectionUpdate(collection, (Serializable)key);
    }

    @Deprecated
    default public void onCollectionUpdate(Object collection, Serializable key) throws CallbackException {
    }

    public void preFlush(Iterator var1) throws CallbackException;

    public void postFlush(Iterator var1) throws CallbackException;

    public Boolean isTransient(Object var1);

    default public int[] findDirty(Object entity, Object id, Object[] currentState, Object[] previousState, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) {
        return this.findDirty(entity, (Serializable)id, currentState, previousState, propertyNames, javaTypeDescriptors);
    }

    @Deprecated
    default public int[] findDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, JavaTypeDescriptor[] javaTypeDescriptors) {
        return null;
    }

    default public Object instantiate(String entityName, RepresentationMode modelRepresentation, Object id) throws CallbackException {
        return this.instantiate(entityName, EntityMode.fromRepresentation(modelRepresentation), (Serializable)id);
    }

    @Deprecated
    default public Object instantiate(String entityName, EntityMode entityMode, Serializable id) throws CallbackException {
        return null;
    }

    public String getEntityName(Object var1) throws CallbackException;

    default public Object getEntity(String entityName, Object id) throws CallbackException {
        return this.getEntity(entityName, (Serializable)id);
    }

    @Deprecated
    default public Object getEntity(String entityName, Serializable id) throws CallbackException {
        return null;
    }

    public void afterTransactionBegin(Transaction var1);

    public void beforeTransactionCompletion(Transaction var1);

    public void afterTransactionCompletion(Transaction var1);
}

