/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.model.domain.spi.VersionDescriptor;

public enum ReplicationMode {
    EXCEPTION{

        @Override
        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionDescriptor versionDescriptor) {
            throw new AssertionFailure("should not be called");
        }
    }
    ,
    IGNORE{

        @Override
        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionDescriptor versionDescriptor) {
            return false;
        }
    }
    ,
    OVERWRITE{

        @Override
        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionDescriptor versionDescriptor) {
            return true;
        }
    }
    ,
    LATEST_VERSION{

        @Override
        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionDescriptor versionDescriptor) {
            return versionDescriptor == null || versionDescriptor.getJavaTypeDescriptor().getComparator().compare(currentVersion, newVersion) <= 0;
        }
    };


    public abstract boolean shouldOverwriteCurrentVersion(Object var1, Object var2, Object var3, VersionDescriptor var4);
}

