/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Closeable;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.naming.Referenceable;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Metamodel;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.envers.internal.AuditReaderFactory;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.stat.Statistics;

public interface SessionFactory
extends EntityManagerFactory,
AuditReaderFactory,
Referenceable,
Serializable,
Closeable {
    public SessionFactoryOptions getSessionFactoryOptions();

    public HibernateCriteriaBuilder getCriteriaBuilder();

    public Metamodel getMetamodel();

    public SessionBuilder withOptions();

    public Session openSession() throws HibernateException;

    public Session getCurrentSession() throws HibernateException;

    public StatelessSessionBuilder withStatelessOptions();

    public StatelessSession openStatelessSession();

    public StatelessSession openStatelessSession(Connection var1);

    public Statistics getStatistics();

    @Override
    public void close() throws HibernateException;

    public boolean isClosed();

    public Cache getCache();

    public Set getDefinedFilterNames();

    public FilterDefinition getFilterDefinition(String var1) throws HibernateException;

    public boolean containsFetchProfileDefinition(String var1);

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> var1);

    default public void inSession(Consumer<Session> action) {
        try (Session session = this.openSession();){
            action.accept(session);
        }
    }
}

