/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public abstract class AbstractEntityInsertAction
extends EntityAction {
    private transient Object[] state;
    private final boolean isVersionIncrementDisabled;
    private boolean isExecuted;
    private boolean areTransientReferencesNullified;

    protected AbstractEntityInsertAction(Object id, Object[] state, Object instance, boolean isVersionIncrementDisabled, EntityTypeDescriptor entityDescriptor, SharedSessionContractImplementor session) {
        super(session, id, instance, entityDescriptor);
        this.state = state;
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
        this.isExecuted = false;
        this.areTransientReferencesNullified = false;
        if (id != null) {
            this.handleNaturalIdPreSaveNotifications();
        }
    }

    public Object[] getState() {
        return this.state;
    }

    public abstract boolean isEarlyInsert();

    public NonNullableTransientDependencies findNonNullableTransientEntities() {
        return ForeignKeys.findNonNullableTransientEntities(this.getEntityDescriptor().getEntityName(), this.getInstance(), this.getState(), this.isEarlyInsert(), this.getSession());
    }

    protected final void nullifyTransientReferencesIfNotAlready() {
        if (!this.areTransientReferencesNullified) {
            List persistentAttributes = this.getEntityDescriptor().getPersistentAttributes();
            Object[] state = this.getState();
            new ForeignKeys.Nullifier(this.getInstance(), false, this.isEarlyInsert(), this.getSession()).nullifyTransientReferences(state, persistentAttributes);
            new Nullability(this.getSession()).checkNullability(state, this.getEntityDescriptor(), false);
            this.areTransientReferencesNullified = true;
        }
    }

    public final void makeEntityManaged() {
        this.nullifyTransientReferencesIfNotAlready();
        Object version = Versioning.getVersion(this.getState(), this.getEntityDescriptor());
        this.getSession().getPersistenceContext().addEntity(this.getInstance(), this.getEntityDescriptor().getHierarchy().getMutabilityPlan().isMutable() ? Status.MANAGED : Status.READ_ONLY, this.getState(), this.getEntityKey(), version, LockMode.WRITE, this.isExecuted, this.getEntityDescriptor(), this.isVersionIncrementDisabled);
    }

    protected void markExecuted() {
        this.isExecuted = true;
    }

    protected abstract EntityKey getEntityKey();

    @Override
    public void afterDeserialize(SharedSessionContractImplementor session) {
        super.afterDeserialize(session);
        if (session != null) {
            EntityEntry entityEntry = session.getPersistenceContext().getEntry(this.getInstance());
            this.state = entityEntry.getLoadedState();
        }
    }

    protected void handleNaturalIdPreSaveNotifications() {
        this.getSession().getPersistenceContext().getNaturalIdHelper().manageLocalNaturalIdCrossReference(this.getEntityDescriptor(), this.getId(), this.state, null, CachedNaturalIdValueSource.INSERT);
    }

    public void handleNaturalIdPostSaveNotifications(Object generatedId) {
        if (this.isEarlyInsert()) {
            this.getSession().getPersistenceContext().getNaturalIdHelper().manageLocalNaturalIdCrossReference(this.getEntityDescriptor(), generatedId, this.state, null, CachedNaturalIdValueSource.INSERT);
        }
        this.getSession().getPersistenceContext().getNaturalIdHelper().manageSharedNaturalIdCrossReference(this.getEntityDescriptor(), generatedId, this.state, null, CachedNaturalIdValueSource.INSERT);
    }
}

