/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final Set<String> affectedTableSpaces;
    private final Set<EntityCleanup> entityCleanups = new HashSet<EntityCleanup>();
    private final Set<CollectionCleanup> collectionCleanups = new HashSet<CollectionCleanup>();
    private final Set<NaturalIdCleanup> naturalIdCleanups = new HashSet<NaturalIdCleanup>();

    public BulkOperationCleanupAction(SharedSessionContractImplementor session, List<EntityTypeDescriptor> affectedEntities) {
        SessionFactoryImplementor factory = session.getFactory();
        LinkedHashSet<String> spacesList = new LinkedHashSet<String>();
        for (EntityTypeDescriptor entityDescriptor : affectedEntities) {
            EntityDataAccess entityDataAccess;
            spacesList.addAll(entityDescriptor.getAffectedTableNames());
            EntityTypeDescriptor rootEntityDescriptor = entityDescriptor.getHierarchy().getRootEntityType();
            spacesList.addAll(rootEntityDescriptor.getAffectedTableNames());
            if (entityDescriptor.canWriteToCache() && (entityDataAccess = entityDescriptor.getHierarchy().getEntityCacheAccess()) != null) {
                this.entityCleanups.add(new EntityCleanup(entityDataAccess, session));
            }
            if (entityDescriptor.hasNaturalIdentifier() && entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess() != null) {
                this.naturalIdCleanups.add(new NaturalIdCleanup(entityDescriptor.getHierarchy().getNaturalIdDescriptor().getCacheAccess(), session));
            }
            for (PersistentCollectionDescriptor<?, ?, ?> collectionDescriptor : factory.getMetamodel().findCollectionsByEntityParticipant(entityDescriptor)) {
                if (!collectionDescriptor.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionDescriptor.getCacheAccess(), session));
            }
        }
        this.affectedTableSpaces = new HashSet<String>(spacesList);
    }

    public BulkOperationCleanupAction(SharedSessionContractImplementor session, Set tableSpaces) {
        LinkedHashSet spacesList = new LinkedHashSet();
        spacesList.addAll(tableSpaces);
        SessionFactoryImplementor factory = session.getFactory();
        factory.getMetamodel().visitEntityHierarchies(entityHierarchy -> {
            EntityTypeDescriptor rootEntityDescriptor = entityHierarchy.getRootEntityType();
            Set<String> affectedTableNames = rootEntityDescriptor.getAffectedTableNames();
            if (this.affectedEntity(tableSpaces, affectedTableNames)) {
                spacesList.addAll(affectedTableNames);
                if (rootEntityDescriptor.canWriteToCache()) {
                    this.entityCleanups.add(new EntityCleanup(entityHierarchy.getEntityCacheAccess(), session));
                }
                if (rootEntityDescriptor.hasNaturalIdentifier() && entityHierarchy.getNaturalIdDescriptor().getCacheAccess() != null) {
                    this.naturalIdCleanups.add(new NaturalIdCleanup(entityHierarchy.getNaturalIdDescriptor().getCacheAccess(), session));
                }
                for (PersistentCollectionDescriptor<?, ?, ?> collectionDescriptor : session.getFactory().getMetamodel().findCollectionsByEntityParticipant(rootEntityDescriptor)) {
                    if (!collectionDescriptor.hasCache()) continue;
                    this.collectionCleanups.add(new CollectionCleanup(collectionDescriptor.getCacheAccess(), session));
                }
            }
        });
        this.affectedTableSpaces = new HashSet<String>(spacesList);
    }

    private boolean affectedEntity(Set affectedTableSpaces, Serializable[] checkTableSpaces) {
        if (affectedTableSpaces == null || affectedTableSpaces.isEmpty()) {
            return true;
        }
        for (Serializable checkTableSpace : checkTableSpaces) {
            if (!affectedTableSpaces.contains(checkTableSpace)) continue;
            return true;
        }
        return false;
    }

    private boolean affectedEntity(Set affectedTableSpaces, Set checkTableSpaces) {
        if (affectedTableSpaces == null || affectedTableSpaces.isEmpty()) {
            return true;
        }
        for (Object checkTableSpace : checkTableSpaces) {
            if (!affectedTableSpaces.contains(checkTableSpace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getPropertySpaces() {
        return this.affectedTableSpaces;
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return new AfterTransactionCompletionProcess(){

            @Override
            public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) {
                for (Serializable cleanup : BulkOperationCleanupAction.this.entityCleanups) {
                    ((EntityCleanup)cleanup).release();
                }
                BulkOperationCleanupAction.this.entityCleanups.clear();
                for (Serializable cleanup : BulkOperationCleanupAction.this.naturalIdCleanups) {
                    ((NaturalIdCleanup)cleanup).release();
                }
                BulkOperationCleanupAction.this.entityCleanups.clear();
                for (Serializable cleanup : BulkOperationCleanupAction.this.collectionCleanups) {
                    ((CollectionCleanup)cleanup).release();
                }
                BulkOperationCleanupAction.this.collectionCleanups.clear();
            }
        };
    }

    @Override
    public void beforeExecutions() throws HibernateException {
    }

    @Override
    public void execute() throws HibernateException {
    }

    @Override
    public void afterDeserialize(SharedSessionContractImplementor session) {
    }

    private static class NaturalIdCleanup
    implements Serializable {
        private final NaturalIdDataAccess naturalIdCacheAccessStrategy;
        private final SoftLock cacheLock;

        public NaturalIdCleanup(NaturalIdDataAccess naturalIdCacheAccessStrategy, SharedSessionContractImplementor session) {
            this.naturalIdCacheAccessStrategy = naturalIdCacheAccessStrategy;
            this.cacheLock = naturalIdCacheAccessStrategy.lockRegion();
            naturalIdCacheAccessStrategy.removeAll(session);
        }

        private void release() {
            this.naturalIdCacheAccessStrategy.unlockRegion(this.cacheLock);
        }
    }

    private static class CollectionCleanup
    implements Serializable {
        private final CollectionDataAccess cacheAccess;
        private final SoftLock cacheLock;

        private CollectionCleanup(CollectionDataAccess cacheAccess, SharedSessionContractImplementor session) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll(session);
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }

    private static class EntityCleanup
    implements Serializable {
        private final EntityDataAccess cacheAccess;
        private final SoftLock cacheLock;

        private EntityCleanup(EntityDataAccess cacheAccess, SharedSessionContractImplementor session) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll(session);
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }
}

