/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.pretty.MessageHelper;

public abstract class CollectionAction
implements Executable,
Serializable,
Comparable {
    private transient PersistentCollectionDescriptor collectionDescriptor;
    private transient SharedSessionContractImplementor session;
    private final PersistentCollection collection;
    private final Object key;
    private final String collectionRole;
    private AfterTransactionCompletionProcess afterTransactionProcess;

    protected CollectionAction(PersistentCollectionDescriptor collectionDescriptor, PersistentCollection collection, Object key, SharedSessionContractImplementor session) {
        this.collectionDescriptor = collectionDescriptor;
        this.session = session;
        this.key = key;
        this.collectionRole = collectionDescriptor.getNavigableRole().getFullPath();
        this.collection = collection;
    }

    protected PersistentCollection getCollection() {
        return this.collection;
    }

    @Override
    public void afterDeserialize(SharedSessionContractImplementor session) {
        if (this.session != null || this.collectionDescriptor != null) {
            throw new IllegalStateException("already attached to a session.");
        }
        if (session != null) {
            this.session = session;
            this.collectionDescriptor = session.getFactory().getMetamodel().findCollectionDescriptor(this.collectionRole);
        }
    }

    @Override
    public final void beforeExecutions() throws CacheException {
        if (this.collectionDescriptor.hasCache()) {
            CollectionDataAccess cacheAccess = this.collectionDescriptor.getCacheAccess();
            Object ck = cacheAccess.generateCacheKey(this.key, this.collectionDescriptor, this.session.getFactory(), this.session.getTenantIdentifier());
            SoftLock lock = cacheAccess.lockItem(this.session, ck, null);
            this.afterTransactionProcess = new CacheCleanupProcess(this.key, this.collectionDescriptor, lock);
        }
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.afterTransactionProcess;
    }

    @Override
    public Set<String> getPropertySpaces() {
        return this.collectionDescriptor.getCollectionSpaces();
    }

    protected final PersistentCollectionDescriptor getPersistentCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    protected final Object getKey() {
        Object finalKey = this.key;
        if (!(this.key instanceof DelayedPostInsertIdentifier) || (finalKey = this.session.getPersistenceContext().getEntry(this.collection.getOwner()).getId()) == this.key) {
            // empty if block
        }
        return finalKey;
    }

    protected final SharedSessionContractImplementor getSession() {
        return this.session;
    }

    protected final void evict() throws CacheException {
        if (this.collectionDescriptor.hasCache()) {
            CollectionDataAccess cacheAccess = this.collectionDescriptor.getCacheAccess();
            Object ck = cacheAccess.generateCacheKey(this.key, this.collectionDescriptor, this.session.getFactory(), this.session.getTenantIdentifier());
            cacheAccess.remove(this.session, ck);
        }
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.collectionRole, this.key);
    }

    public int compareTo(Object other) {
        CollectionAction action = (CollectionAction)other;
        int roleComparison = this.collectionRole.compareTo(action.collectionRole);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.collectionDescriptor.getKeyJavaTypeDescriptor().getComparator().compare(this.key, action.key);
    }

    protected <T> EventListenerGroup<T> listenerGroup(EventType<T> eventType) {
        return this.getSession().getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(eventType);
    }

    protected EventSource eventSource() {
        return (EventSource)this.getSession();
    }

    private static class CacheCleanupProcess
    implements AfterTransactionCompletionProcess {
        private final Object key;
        private final PersistentCollectionDescriptor collectionDescriptor;
        private final SoftLock lock;

        private CacheCleanupProcess(Object key, PersistentCollectionDescriptor collectionDescriptor, SoftLock lock) {
            this.key = key;
            this.collectionDescriptor = collectionDescriptor;
            this.lock = lock;
        }

        @Override
        public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) {
            CollectionDataAccess cache = this.collectionDescriptor.getCacheAccess();
            Object ck = cache.generateCacheKey(this.key, this.collectionDescriptor, session.getFactory(), session.getTenantIdentifier());
            cache.unlockItem(session, ck, this.lock);
        }
    }
}

