/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection collection, PersistentCollectionDescriptor collectionDescriptor, Object collectionKey, SharedSessionContractImplementor session) {
        super(collectionDescriptor, collection, collectionKey, session);
    }

    @Override
    public void execute() throws HibernateException {
        PersistentCollection collection = this.getCollection();
        this.preRecreate();
        this.getPersistentCollectionDescriptor().recreate(collection, this.getKey(), this.getSession());
        this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postRecreate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatistics().recreateCollection(this.getPersistentCollectionDescriptor().getNavigableRole().getFullPath());
        }
    }

    private void preRecreate() {
        EventListenerGroup<PreCollectionRecreateEventListener> listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRecreateEvent event = new PreCollectionRecreateEvent(this.getPersistentCollectionDescriptor(), this.getCollection(), this.eventSource());
        for (PreCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPreRecreateCollection(event);
        }
    }

    private void postRecreate() {
        EventListenerGroup<PostCollectionRecreateEventListener> listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRecreateEvent event = new PostCollectionRecreateEvent(this.getPersistentCollectionDescriptor(), this.getCollection(), this.eventSource());
        for (PostCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPostRecreateCollection(event);
        }
    }
}

