/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.pretty.MessageHelper;

public final class CollectionUpdateAction
extends CollectionAction {
    private final boolean emptySnapshot;

    public CollectionUpdateAction(PersistentCollection collection, PersistentCollectionDescriptor collectionDescriptor, Object collectionKey, boolean emptySnapshot, SharedSessionContractImplementor session) {
        super(collectionDescriptor, collection, collectionKey, session);
        this.emptySnapshot = emptySnapshot;
    }

    @Override
    public void execute() throws HibernateException {
        Object id = this.getKey();
        SharedSessionContractImplementor session = this.getSession();
        PersistentCollectionDescriptor collectionDescriptor = this.getPersistentCollectionDescriptor();
        PersistentCollection collection = this.getCollection();
        boolean affectedByFilters = collectionDescriptor.isAffectedByEnabledFilters(session);
        this.preUpdate();
        if (!collection.wasInitialized()) {
            if (!collection.isDirty()) {
                throw new AssertionFailure("collection is not dirty");
            }
        } else if (!affectedByFilters && collection.empty()) {
            if (!this.emptySnapshot) {
                collectionDescriptor.remove(id, session);
            }
        } else if (collection.needsRecreate(collectionDescriptor)) {
            if (affectedByFilters) {
                throw new HibernateException("cannot recreate collection while filter is enabled: " + MessageHelper.collectionInfoString(collectionDescriptor, collection, id, session));
            }
            if (!this.emptySnapshot) {
                collectionDescriptor.remove(id, session);
            }
            collectionDescriptor.recreate(collection, id, session);
        } else {
            collectionDescriptor.deleteRows(collection, id, session);
            collectionDescriptor.updateRows(collection, id, session);
            collectionDescriptor.insertRows(collection, id, session);
        }
        this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postUpdate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatistics().updateCollection(this.getPersistentCollectionDescriptor().getNavigableRole().getFullPath());
        }
    }

    private void preUpdate() {
        EventListenerGroup<PreCollectionUpdateEventListener> listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionUpdateEvent event = new PreCollectionUpdateEvent(this.getPersistentCollectionDescriptor(), this.getCollection(), this.eventSource());
        for (PreCollectionUpdateEventListener listener : listenerGroup.listeners()) {
            listener.onPreUpdateCollection(event);
        }
    }

    private void postUpdate() {
        EventListenerGroup<PostCollectionUpdateEventListener> listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionUpdateEvent event = new PostCollectionUpdateEvent(this.getPersistentCollectionDescriptor(), this.getCollection(), this.eventSource());
        for (PostCollectionUpdateEventListener listener : listenerGroup.listeners()) {
            listener.onPostUpdateCollection(event);
        }
    }
}

