/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public abstract class EntityAction
implements Executable,
Serializable,
Comparable,
AfterTransactionCompletionProcess {
    private static final Logger LOG = Logger.getLogger(EntityAction.class);
    private final String entityName;
    private final Object id;
    private transient Object instance;
    private transient SharedSessionContractImplementor session;
    private transient EntityTypeDescriptor entityDescriptor;
    private transient boolean veto;

    protected EntityAction(SharedSessionContractImplementor session, Object id, Object instance, EntityTypeDescriptor entityDescriptor) {
        this.entityName = entityDescriptor.getEntityName();
        this.id = id;
        this.instance = instance;
        this.session = session;
        this.entityDescriptor = entityDescriptor;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public void setVeto(boolean veto) {
        this.veto = veto;
    }

    @Override
    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    @Override
    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return this.needsAfterTransactionCompletion() ? this : null;
    }

    protected abstract boolean hasPostCommitEventListeners();

    protected boolean needsAfterTransactionCompletion() {
        return this.entityDescriptor.canWriteToCache() || this.hasPostCommitEventListeners();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public final Object getId() {
        if (this.id instanceof DelayedPostInsertIdentifier) {
            EntityEntry entry = this.session.getPersistenceContext().getEntry(this.instance);
            Object eeId = entry == null ? null : entry.getId();
            return eeId instanceof DelayedPostInsertIdentifier ? null : eeId;
        }
        return this.id;
    }

    public final DelayedPostInsertIdentifier getDelayedId() {
        return DelayedPostInsertIdentifier.class.isInstance(this.id) ? (DelayedPostInsertIdentifier)DelayedPostInsertIdentifier.class.cast(this.id) : null;
    }

    public final Object getInstance() {
        return this.instance;
    }

    public final SharedSessionContractImplementor getSession() {
        return this.session;
    }

    public final EntityTypeDescriptor<?> getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public final Set<String> getPropertySpaces() {
        return this.entityDescriptor.getAffectedTableNames();
    }

    @Override
    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + MessageHelper.infoString(this.entityName, this.id);
    }

    public int compareTo(Object other) {
        EntityAction action = (EntityAction)other;
        int roleComparison = this.entityName.compareTo(action.entityName);
        if (roleComparison != 0) {
            return roleComparison;
        }
        return this.entityDescriptor.getIdentifierDescriptor().getJavaTypeDescriptor().getComparator().compare(this.id, action.id);
    }

    @Override
    public void afterDeserialize(SharedSessionContractImplementor session) {
        if (this.session != null || this.entityDescriptor != null) {
            throw new IllegalStateException("already attached to a session.");
        }
        if (session != null) {
            this.session = session;
            this.entityDescriptor = session.getFactory().getMetamodel().findEntityDescriptor(this.entityName);
            this.instance = session.getPersistenceContext().getEntity(session.generateEntityKey(this.id, this.entityDescriptor));
        }
    }

    protected <T> EventListenerGroup<T> listenerGroup(EventType<T> eventType) {
        return this.getSession().getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(eventType);
    }

    protected EventSource eventSource() {
        return (EventSource)this.getSession();
    }
}

