/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;

public final class EntityInsertAction
extends AbstractEntityInsertAction {
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Object id, Object[] state, Object instance, Object version, EntityTypeDescriptor descriptor, boolean isVersionIncrementDisabled, SharedSessionContractImplementor session) {
        super(id, state, instance, isVersionIncrementDisabled, descriptor, session);
        this.version = version;
    }

    @Override
    public boolean isEarlyInsert() {
        return false;
    }

    @Override
    protected EntityKey getEntityKey() {
        return this.getSession().generateEntityKey(this.getId(), this.getEntityDescriptor());
    }

    @Override
    public void execute() throws HibernateException {
        this.nullifyTransientReferencesIfNotAlready();
        EntityTypeDescriptor<?> entityDescriptor = this.getEntityDescriptor();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        Object id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            entityDescriptor.insert(id, this.getState(), instance, session);
            PersistenceContext persistenceContext = session.getPersistenceContext();
            EntityEntry entry = persistenceContext.getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            entry.postInsert(this.getState());
            if (entityDescriptor.hasInsertGeneratedProperties()) {
                entityDescriptor.processInsertGeneratedProperties(id, instance, this.getState(), session);
                if (entityDescriptor.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.getState(), entityDescriptor);
                }
                entry.postUpdate(instance, this.getState(), this.version);
            }
            persistenceContext.registerInsertedKey(entityDescriptor, this.getId());
        }
        SessionFactoryImplementor factory = session.getFactory();
        if (this.isCachePutEnabled(entityDescriptor, session)) {
            EntityDataAccess cacheAccess = factory.getCache().getEntityRegionAccess(entityDescriptor.getNavigableRole());
            CacheEntry ce = entityDescriptor.buildCacheEntry(instance, this.getState(), this.version, session);
            this.cacheEntry = entityDescriptor.getCacheEntryStructure().structure(ce);
            Object ck = cacheAccess.generateCacheKey(id, entityDescriptor.getHierarchy(), factory, session.getTenantIdentifier());
            boolean put = this.cacheInsert(entityDescriptor, ck);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatistics().entityCachePut(entityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
            }
        }
        this.handleNaturalIdPostSaveNotifications(id);
        this.postInsert();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatistics().insertEntity(this.getEntityDescriptor().getEntityName());
        }
        this.markExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheInsert(EntityTypeDescriptor descriptor, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        try {
            session.getEventListenerManager().cachePutStart();
            EntityTypeDescriptor rootDescriptor = descriptor.getHierarchy().getRootEntityType();
            boolean bl = session.getFactory().getCache().getEntityRegionAccess(rootDescriptor.getNavigableRole()).insert(session, ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
    }

    private void postInsert() {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getEntityDescriptor(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            listener.onPostInsert(event);
        }
    }

    private void postCommitInsert(boolean success) {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getEntityDescriptor(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            if (PostCommitInsertEventListener.class.isInstance(listener)) {
                if (success) {
                    listener.onPostInsert(event);
                    continue;
                }
                ((PostCommitInsertEventListener)listener).onPostInsertCommitFailed(event);
                continue;
            }
            listener.onPostInsert(event);
        }
    }

    private boolean preInsert() {
        boolean veto = false;
        EventListenerGroup<PreInsertEventListener> listenerGroup = this.listenerGroup(EventType.PRE_INSERT);
        if (listenerGroup.isEmpty()) {
            return veto;
        }
        PreInsertEvent event = new PreInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getEntityDescriptor(), this.eventSource());
        for (PreInsertEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws HibernateException {
        EntityTypeDescriptor<?> entityDescriptor = this.getEntityDescriptor();
        if (success && this.isCachePutEnabled(entityDescriptor, this.getSession())) {
            EntityDataAccess cache = entityDescriptor.getHierarchy().getEntityCacheAccess();
            SessionFactoryImplementor factory = session.getFactory();
            Object ck = cache.generateCacheKey(this.getId(), entityDescriptor.getHierarchy(), factory, session.getTenantIdentifier());
            boolean put = this.cacheAfterInsert(cache, ck);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                this.getSession().getFactory().getStatistics().entityCachePut(entityDescriptor.getNavigableRole(), cache.getRegion().getName());
            }
        }
        this.postCommitInsert(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheAfterInsert(EntityDataAccess cache, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        try {
            eventListenerManager.cachePutStart();
            boolean bl = cache.afterInsert(session, ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            eventListenerManager.cachePutEnd();
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostInsertEventListener> group = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        for (PostInsertEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getEntityDescriptor())) continue;
            return true;
        }
        return false;
    }

    private boolean isCachePutEnabled(EntityTypeDescriptor entityDescriptor, SharedSessionContractImplementor session) {
        return entityDescriptor.canWriteToCache() && !entityDescriptor.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

