/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityAction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitUpdateEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.type.internal.TypeHelper;

public final class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private final Object[] previousNaturalIdValues;
    private Object nextVersion;
    private Object cacheEntry;
    private SoftLock lock;

    public EntityUpdateAction(Object id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityTypeDescriptor entityDescriptor, SharedSessionContractImplementor session) {
        super(session, id, instance, entityDescriptor);
        this.state = state;
        this.previousState = previousState;
        this.previousVersion = previousVersion;
        this.nextVersion = nextVersion;
        this.dirtyFields = dirtyProperties;
        this.hasDirtyCollection = hasDirtyCollection;
        this.rowId = rowId;
        this.previousNaturalIdValues = this.determinePreviousNaturalIdValues(entityDescriptor, previousState, session, id);
        session.getPersistenceContext().getNaturalIdHelper().manageLocalNaturalIdCrossReference(entityDescriptor, id, state, this.previousNaturalIdValues, CachedNaturalIdValueSource.UPDATE);
    }

    private Object[] determinePreviousNaturalIdValues(EntityTypeDescriptor entityDescriptor, Object[] previousState, SharedSessionContractImplementor session, Object id) {
        if (entityDescriptor.getHierarchy().getNaturalIdDescriptor() == null) {
            return null;
        }
        if (previousState != null) {
            return session.getPersistenceContext().getNaturalIdHelper().extractNaturalIdValues(previousState, entityDescriptor);
        }
        return session.getPersistenceContext().getNaturalIdSnapshot(id, entityDescriptor);
    }

    @Override
    public void execute() throws HibernateException {
        EntityEntry entry;
        Object ck;
        Object id = this.getId();
        EntityTypeDescriptor<?> entityDescriptor = this.getEntityDescriptor();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preUpdate();
        SessionFactoryImplementor factory = session.getFactory();
        Object previousVersion = this.previousVersion;
        if (entityDescriptor.isVersionPropertyGenerated()) {
            previousVersion = entityDescriptor.getVersion(instance);
        }
        if (entityDescriptor.canWriteToCache()) {
            EntityDataAccess cache = entityDescriptor.getHierarchy().getEntityCacheAccess();
            ck = cache.generateCacheKey(id, entityDescriptor.getHierarchy(), factory, session.getTenantIdentifier());
            this.lock = cache.lockItem(session, ck, previousVersion);
        } else {
            ck = null;
        }
        if (!veto) {
            entityDescriptor.update(id, this.state, this.dirtyFields, this.hasDirtyCollection, this.previousState, previousVersion, instance, this.rowId, session);
        }
        if ((entry = session.getPersistenceContext().getEntry(instance)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        if (entry.getStatus() == Status.MANAGED || entityDescriptor.isVersionPropertyGenerated()) {
            TypeHelper.deepCopy(entityDescriptor, this.state, this.state, StateArrayContributor::isIncludedInDirtyChecking);
            if (entityDescriptor.hasUpdateGeneratedProperties()) {
                entityDescriptor.processUpdateGeneratedProperties(id, instance, this.state, session);
                if (entityDescriptor.isVersionPropertyGenerated()) {
                    this.nextVersion = Versioning.getVersion(this.state, entityDescriptor);
                }
            }
            entry.postUpdate(instance, this.state, this.nextVersion);
        }
        if (entityDescriptor.canWriteToCache()) {
            if (entityDescriptor.isCacheInvalidationRequired() || entry.getStatus() != Status.MANAGED) {
                entityDescriptor.getHierarchy().getEntityCacheAccess().remove(session, ck);
            } else if (session.getCacheMode().isPutEnabled()) {
                CacheEntry ce = entityDescriptor.buildCacheEntry(instance, this.state, this.nextVersion, this.getSession());
                this.cacheEntry = entityDescriptor.getCacheEntryStructure().structure(ce);
                boolean put = this.cacheUpdate(entityDescriptor, previousVersion, ck);
                if (put && factory.getStatistics().isStatisticsEnabled()) {
                    factory.getStatistics().entityCachePut(entityDescriptor.getNavigableRole(), entityDescriptor.getHierarchy().getEntityCacheAccess().getRegion().getName());
                }
            }
        }
        session.getPersistenceContext().getNaturalIdHelper().manageSharedNaturalIdCrossReference(entityDescriptor, id, this.state, this.previousNaturalIdValues, CachedNaturalIdValueSource.UPDATE);
        this.postUpdate();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatistics().updateEntity(this.getEntityDescriptor().getEntityName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheUpdate(EntityTypeDescriptor entityDescriptor, Object previousVersion, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        try {
            session.getEventListenerManager().cachePutStart();
            EntityTypeDescriptor rootDescriptor = entityDescriptor.getHierarchy().getRootEntityType();
            boolean bl = session.getFactory().getCache().getEntityRegionAccess(rootDescriptor.getNavigableRole()).update(session, ck, this.cacheEntry, this.nextVersion, previousVersion);
            return bl;
        }
        finally {
            session.getEventListenerManager().cachePutEnd();
        }
    }

    private boolean preUpdate() {
        boolean veto = false;
        EventListenerGroup<PreUpdateEventListener> listenerGroup = this.listenerGroup(EventType.PRE_UPDATE);
        if (listenerGroup.isEmpty()) {
            return veto;
        }
        PreUpdateEvent event = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getEntityDescriptor(), this.eventSource());
        for (PreUpdateEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreUpdate(event);
        }
        return veto;
    }

    private void postUpdate() {
        EventListenerGroup<PostUpdateEventListener> listenerGroup = this.listenerGroup(EventType.POST_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostUpdateEvent event = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getEntityDescriptor(), this.eventSource());
        for (PostUpdateEventListener listener : listenerGroup.listeners()) {
            listener.onPostUpdate(event);
        }
    }

    private void postCommitUpdate(boolean success) {
        EventListenerGroup<PostUpdateEventListener> listenerGroup = this.listenerGroup(EventType.POST_COMMIT_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostUpdateEvent event = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.dirtyFields, this.getEntityDescriptor(), this.eventSource());
        for (PostUpdateEventListener listener : listenerGroup.listeners()) {
            if (PostCommitUpdateEventListener.class.isInstance(listener)) {
                if (success) {
                    listener.onPostUpdate(event);
                    continue;
                }
                ((PostCommitUpdateEventListener)listener).onPostUpdateCommitFailed(event);
                continue;
            }
            listener.onPostUpdate(event);
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostUpdateEventListener> group = this.listenerGroup(EventType.POST_COMMIT_UPDATE);
        for (PostUpdateEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getEntityDescriptor())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws CacheException {
        SessionFactoryImplementor factory = session.getFactory();
        EntityTypeDescriptor<?> entityDescriptor = this.getEntityDescriptor();
        if (entityDescriptor.canWriteToCache()) {
            EntityDataAccess cacheAccess = entityDescriptor.getHierarchy().getEntityCacheAccess();
            Object ck = cacheAccess.generateCacheKey(this.getId(), entityDescriptor.getHierarchy(), factory, session.getTenantIdentifier());
            if (success && this.cacheEntry != null && !entityDescriptor.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled()) {
                boolean put = this.cacheAfterUpdate(cacheAccess, ck);
                if (put && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                    session.getFactory().getStatistics().entityCachePut(entityDescriptor.getNavigableRole(), entityDescriptor.getHierarchy().getEntityCacheAccess().getRegion().getName());
                }
            } else {
                cacheAccess.unlockItem(session, ck, this.lock);
            }
        }
        this.postCommitUpdate(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheAfterUpdate(EntityDataAccess cache, Object ck) {
        SharedSessionContractImplementor session = this.getSession();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        try {
            eventListenerManager.cachePutStart();
            boolean bl = cache.afterUpdate(session, ck, this.cacheEntry, this.nextVersion, this.previousVersion, this.lock);
            return bl;
        }
        finally {
            eventListenerManager.cachePutEnd();
        }
    }
}

