/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.OptimisticLockException;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.pretty.MessageHelper;

public class EntityVerifyVersionProcess
implements BeforeTransactionCompletionProcess {
    private final Object object;
    private final EntityEntry entry;

    public EntityVerifyVersionProcess(Object object, EntityEntry entry) {
        this.object = object;
        this.entry = entry;
    }

    @Override
    public void doBeforeTransactionCompletion(SessionImplementor session) {
        EntityTypeDescriptor entityDescriptor = this.entry.getDescriptor();
        if (!this.entry.isExistsInDatabase()) {
            return;
        }
        Object latestVersion = entityDescriptor.getCurrentVersion(this.entry.getId(), session);
        if (!this.entry.getVersion().equals(latestVersion)) {
            throw new OptimisticLockException(this.object, "Newer version [" + latestVersion + "] of entity [" + MessageHelper.infoString(this.entry.getEntityName(), this.entry.getId()) + "] found in database");
        }
    }
}

