/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.EntityMappingHierarchy;
import org.hibernate.boot.model.query.spi.NamedHqlQueryDefinition;
import org.hibernate.boot.model.query.spi.NamedNativeQueryDefinition;
import org.hibernate.boot.model.query.spi.NamedQueryDefinition;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.cfg.annotations.NamedProcedureCallDefinition;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;

public interface Metadata {
    public SessionFactoryBuilder getSessionFactoryBuilder();

    public SessionFactory buildSessionFactory();

    public UUID getUUID();

    public Database getDatabase();

    public Collection<EntityMappingHierarchy> getEntityHierarchies();

    @Deprecated
    public Collection<PersistentClass> getEntityBindings();

    default public Collection<EntityMapping> getEntityMappings() {
        return this.getEntityBindings().stream().collect(Collectors.toList());
    }

    public PersistentClass getEntityBinding(String var1);

    public Collection<org.hibernate.mapping.Collection> getCollectionBindings();

    public org.hibernate.mapping.Collection getCollectionBinding(String var1);

    public Map<String, String> getImports();

    public NamedHqlQueryDefinition getNamedHqlQueryDefinition(String var1);

    public Collection<NamedHqlQueryDefinition> getNamedHqlQueryDefinitions();

    @Deprecated
    default public NamedQueryDefinition getNamedQueryDefinition(String name) {
        return this.getNamedHqlQueryDefinition(name);
    }

    @Deprecated
    default public Collection<NamedQueryDefinition> getNamedQueryDefinitions() {
        return new ArrayList<NamedQueryDefinition>(this.getNamedHqlQueryDefinitions());
    }

    public NamedNativeQueryDefinition getNamedNativeQueryDefinition(String var1);

    public Collection<NamedNativeQueryDefinition> getNamedNativeQueryDefinitions();

    public Collection<NamedProcedureCallDefinition> getNamedProcedureCallDefinitions();

    public ResultSetMappingDefinition getResultSetMapping(String var1);

    public Map<String, ResultSetMappingDefinition> getResultSetMappingDefinitions();

    public Map<String, FilterDefinition> getFilterDefinitions();

    public FilterDefinition getFilterDefinition(String var1);

    public FetchProfile getFetchProfile(String var1);

    public Collection<FetchProfile> getFetchProfiles();

    public NamedEntityGraphDefinition getNamedEntityGraph(String var1);

    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs();

    public IdentifierGeneratorDefinition getIdentifierGenerator(String var1);

    public Collection<Table> collectTableMappings();

    public Collection<MappedTable> collectMappedTableMappings();

    public Map<String, SqmFunctionTemplate> getSqlFunctionMap();
}

