/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.SessionFactoryBuilderImpl;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.domain.EntityMapping;
import org.hibernate.boot.model.domain.EntityMappingHierarchy;
import org.hibernate.boot.model.domain.spi.EntityMappingImplementor;
import org.hibernate.boot.model.query.spi.NamedHqlQueryDefinition;
import org.hibernate.boot.model.query.spi.NamedNativeQueryDefinition;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.MappedNamespace;
import org.hibernate.boot.model.relational.MappedTable;
import org.hibernate.boot.model.resultset.spi.ResultSetMappingDefinition;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderFactory;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.cfg.annotations.NamedProcedureCallDefinition;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.envers.boot.spi.AuditMetadataBuilderImplementor;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.query.internal.NamedQueryRepositoryImpl;
import org.hibernate.query.named.spi.NamedCallableQueryMemento;
import org.hibernate.query.named.spi.NamedHqlQueryMemento;
import org.hibernate.query.named.spi.NamedNativeQueryMemento;
import org.hibernate.query.spi.NamedQueryRepository;
import org.hibernate.query.spi.ResultSetMappingDescriptor;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.type.spi.TypeConfiguration;

public class MetadataImpl
implements MetadataImplementor,
Serializable {
    private final UUID uuid;
    private final MetadataBuildingOptions metadataBuildingOptions;
    private final BootstrapContext bootstrapContext;
    private final Map<String, EntityMappingHierarchy> entityMappingHierarchies;
    private final Map<String, PersistentClass> entityBindingMap;
    private final Map<Class, MappedSuperclass> mappedSuperclassMap;
    private final Map<String, org.hibernate.mapping.Collection> collectionBindingMap;
    private final Map<String, FilterDefinition> filterDefinitionMap;
    private final Map<String, FetchProfile> fetchProfileMap;
    private final Map<String, String> imports;
    private final Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap;
    private final Map<String, NamedHqlQueryDefinition> namedHqlQueryMap;
    private final Map<String, NamedNativeQueryDefinition> namedNativeQueryMap;
    private final Map<String, NamedProcedureCallDefinition> namedProcedureCallMap;
    private final Map<String, ResultSetMappingDefinition> sqlResultSetMappingMap;
    private final Map<String, NamedEntityGraphDefinition> namedEntityGraphMap;
    private final Map<String, SqmFunctionTemplate> sqlFunctionMap;
    private final Database database;
    private final AuditMetadataBuilderImplementor auditMetadataBuilder;

    MetadataImpl(UUID uuid, MetadataBuildingOptions metadataBuildingOptions, Map<String, EntityMappingHierarchy> entityMappingHierarchies, Map<String, PersistentClass> entityBindingMap, Map<Class, MappedSuperclass> mappedSuperclassMap, Map<String, org.hibernate.mapping.Collection> collectionBindingMap, Map<String, FilterDefinition> filterDefinitionMap, Map<String, FetchProfile> fetchProfileMap, Map<String, String> imports, Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap, Map<String, NamedHqlQueryDefinition> namedHqlQueryMap, Map<String, NamedNativeQueryDefinition> namedNativeQueryMap, Map<String, NamedProcedureCallDefinition> namedProcedureCallMap, Map<String, ResultSetMappingDefinition> sqlResultSetMappingMap, Map<String, NamedEntityGraphDefinition> namedEntityGraphMap, Map<String, SqmFunctionTemplate> sqlFunctionMap, AuditMetadataBuilderImplementor auditMetadataBuilder, Database database, BootstrapContext bootstrapContext) {
        this.uuid = uuid;
        this.metadataBuildingOptions = metadataBuildingOptions;
        this.entityMappingHierarchies = entityMappingHierarchies;
        this.entityBindingMap = entityBindingMap;
        this.mappedSuperclassMap = mappedSuperclassMap;
        this.collectionBindingMap = collectionBindingMap;
        this.filterDefinitionMap = filterDefinitionMap;
        this.fetchProfileMap = fetchProfileMap;
        this.imports = imports;
        this.idGeneratorDefinitionMap = idGeneratorDefinitionMap;
        this.namedHqlQueryMap = namedHqlQueryMap;
        this.namedNativeQueryMap = namedNativeQueryMap;
        this.namedProcedureCallMap = namedProcedureCallMap;
        this.sqlResultSetMappingMap = sqlResultSetMappingMap;
        this.namedEntityGraphMap = namedEntityGraphMap;
        this.sqlFunctionMap = sqlFunctionMap;
        this.database = database;
        this.auditMetadataBuilder = auditMetadataBuilder;
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.metadataBuildingOptions;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.bootstrapContext.getTypeConfiguration();
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        SessionFactoryBuilderImpl defaultBuilder = new SessionFactoryBuilderImpl(this, this.bootstrapContext);
        ClassLoaderService cls = this.metadataBuildingOptions.getServiceRegistry().getService(ClassLoaderService.class);
        Collection<SessionFactoryBuilderFactory> discoveredBuilderFactories = cls.loadJavaServices(SessionFactoryBuilderFactory.class);
        SessionFactoryBuilder builder = null;
        ArrayList<String> activeFactoryNames = null;
        for (SessionFactoryBuilderFactory discoveredBuilderFactory : discoveredBuilderFactories) {
            SessionFactoryBuilder returnedBuilder = discoveredBuilderFactory.getSessionFactoryBuilder(this, defaultBuilder);
            if (returnedBuilder == null) continue;
            if (activeFactoryNames == null) {
                activeFactoryNames = new ArrayList<String>();
            }
            activeFactoryNames.add(discoveredBuilderFactory.getClass().getName());
            builder = returnedBuilder;
        }
        if (activeFactoryNames != null && activeFactoryNames.size() > 1) {
            throw new HibernateException("Multiple active SessionFactoryBuilderFactory definitions were discovered : " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)activeFactoryNames));
        }
        if (builder != null) {
            return builder;
        }
        return defaultBuilder;
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return this.getSessionFactoryBuilder().build();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Collection<EntityMappingHierarchy> getEntityHierarchies() {
        return this.entityMappingHierarchies.values();
    }

    @Override
    public Collection<PersistentClass> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public PersistentClass getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public Collection<org.hibernate.mapping.Collection> getCollectionBindings() {
        return this.collectionBindingMap.values();
    }

    @Override
    public org.hibernate.mapping.Collection getCollectionBinding(String role) {
        return this.collectionBindingMap.get(role);
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public NamedHqlQueryDefinition getNamedHqlQueryDefinition(String name) {
        return this.namedHqlQueryMap.get(name);
    }

    @Override
    public Collection<NamedHqlQueryDefinition> getNamedHqlQueryDefinitions() {
        return this.namedHqlQueryMap.values();
    }

    @Override
    public NamedNativeQueryDefinition getNamedNativeQueryDefinition(String name) {
        return this.namedNativeQueryMap.get(name);
    }

    @Override
    public Collection<NamedNativeQueryDefinition> getNamedNativeQueryDefinitions() {
        return this.namedNativeQueryMap.values();
    }

    @Override
    public Collection<NamedProcedureCallDefinition> getNamedProcedureCallDefinitions() {
        return this.namedProcedureCallMap.values();
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String name) {
        return this.sqlResultSetMappingMap.get(name);
    }

    @Override
    public Map<String, ResultSetMappingDefinition> getResultSetMappingDefinitions() {
        return this.sqlResultSetMappingMap;
    }

    @Override
    public Map<String, FilterDefinition> getFilterDefinitions() {
        return this.filterDefinitionMap;
    }

    @Override
    public FilterDefinition getFilterDefinition(String name) {
        return this.filterDefinitionMap.get(name);
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfileMap.get(name);
    }

    @Override
    public Collection<FetchProfile> getFetchProfiles() {
        return this.fetchProfileMap.values();
    }

    @Override
    public NamedEntityGraphDefinition getNamedEntityGraph(String name) {
        return this.namedEntityGraphMap.get(name);
    }

    @Override
    public Map<String, NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap;
    }

    @Override
    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        return this.idGeneratorDefinitionMap.get(name);
    }

    @Override
    public Map<String, SqmFunctionTemplate> getSqlFunctionMap() {
        return this.sqlFunctionMap;
    }

    @Override
    public Collection<Table> collectTableMappings() {
        return this.collectMappedTableMappings().stream().map(t -> (Table)t).collect(Collectors.toList());
    }

    @Override
    public Collection<MappedTable> collectMappedTableMappings() {
        ArrayList<MappedTable> tables = new ArrayList<MappedTable>();
        for (MappedNamespace namespace : this.database.getNamespaces()) {
            tables.addAll(namespace.getTables());
        }
        return tables;
    }

    @Override
    public NamedQueryRepository buildNamedQueryRepository(SessionFactoryImplementor sessionFactory) {
        return new NamedQueryRepositoryImpl(this.buildNamedHqlDescriptorMap(sessionFactory), this.buildNamedNativeDescriptorMap(sessionFactory), this.buildProcedureCallMementos(sessionFactory), this.buildSqlResultSetMappings(sessionFactory));
    }

    private Map<String, NamedHqlQueryMemento> buildNamedHqlDescriptorMap(SessionFactoryImplementor sessionFactory) {
        if (this.namedHqlQueryMap == null || this.namedHqlQueryMap.isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, NamedHqlQueryMemento> descriptorMap = new ConcurrentHashMap<String, NamedHqlQueryMemento>();
        for (Map.Entry<String, NamedHqlQueryDefinition> entry : this.namedHqlQueryMap.entrySet()) {
            descriptorMap.put(entry.getKey(), entry.getValue().resolve(sessionFactory));
        }
        return descriptorMap;
    }

    private Map<String, NamedNativeQueryMemento> buildNamedNativeDescriptorMap(SessionFactoryImplementor sessionFactory) {
        if (this.namedNativeQueryMap == null || this.namedNativeQueryMap.isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, NamedNativeQueryMemento> descriptorMap = new ConcurrentHashMap<String, NamedNativeQueryMemento>();
        for (Map.Entry<String, NamedNativeQueryDefinition> entry : this.namedNativeQueryMap.entrySet()) {
            descriptorMap.put(entry.getKey(), entry.getValue().resolve(sessionFactory));
        }
        return descriptorMap;
    }

    private Map<String, ResultSetMappingDescriptor> buildSqlResultSetMappings(SessionFactoryImplementor sessionFactory) {
        if (this.sqlResultSetMappingMap == null || this.sqlResultSetMappingMap.isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, ResultSetMappingDescriptor> converted = new ConcurrentHashMap<String, ResultSetMappingDescriptor>();
        for (Map.Entry<String, ResultSetMappingDefinition> bootEntry : this.sqlResultSetMappingMap.entrySet()) {
            converted.put(bootEntry.getKey(), bootEntry.getValue().resolve(sessionFactory));
        }
        return converted;
    }

    private Map<String, NamedCallableQueryMemento> buildProcedureCallMementos(SessionFactoryImplementor sessionFactory) {
        HashMap<String, NamedCallableQueryMemento> rtn = new HashMap<String, NamedCallableQueryMemento>();
        if (this.namedProcedureCallMap != null) {
            for (NamedProcedureCallDefinition procedureCallDefinition : this.namedProcedureCallMap.values()) {
                rtn.put(procedureCallDefinition.getRegisteredName(), procedureCallDefinition.toMemento(sessionFactory));
            }
        }
        return rtn;
    }

    @Override
    public void validate() throws MappingException {
        for (EntityMapping entityBinding : this.getEntityMappings()) {
            ((EntityMappingImplementor)entityBinding).validate();
        }
        for (org.hibernate.mapping.Collection collectionBinding : this.getCollectionBindings()) {
            collectionBinding.validate();
        }
    }

    @Override
    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return this.mappedSuperclassMap == null ? Collections.emptySet() : new HashSet<MappedSuperclass>(this.mappedSuperclassMap.values());
    }

    @Override
    public AuditMetadataBuilderImplementor getAuditMetadataBuilder() {
        return this.auditMetadataBuilder;
    }
}

