/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.model.type.spi.BasicTypeResolver;
import org.hibernate.boot.model.type.spi.TypeResolverTemplate;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.BasicTypeAdapter;
import org.hibernate.type.internal.BasicTypeMutabilityPlanAdapter;
import org.hibernate.type.internal.BasicTypeResolution;
import org.hibernate.type.internal.UserTypeAdapter;
import org.hibernate.type.internal.UserTypeMutabilityPlanAdapter;
import org.hibernate.type.internal.UserTypeResolution;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.ParameterizedType;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class TypeDefinition
implements TypeResolverTemplate,
Serializable {
    private final String name;
    private final Class typeImplementorClass;
    private final String[] registrationKeys;
    private final Map<String, String> parameters;
    private BasicTypeResolver typeResolver;
    private static final AtomicInteger nameCounter = new AtomicInteger();
    private BasicValueMapping.Resolution reusableResolution;

    public TypeDefinition(String name, Class typeImplementorClass, String[] registrationKeys, Map<String, String> parameters, TypeConfiguration typeConfiguration) {
        this.name = name;
        this.typeImplementorClass = typeImplementorClass;
        this.registrationKeys = registrationKeys;
        this.parameters = parameters == null ? Collections.emptyMap() : Collections.unmodifiableMap(parameters);
    }

    public TypeDefinition(String name, Class typeImplementorClass, String[] registrationKeys, Properties parameters, TypeConfiguration typeConfiguration) {
        this.name = name;
        this.typeImplementorClass = typeImplementorClass;
        this.registrationKeys = registrationKeys;
        this.parameters = parameters == null ? Collections.emptyMap() : this.extractStrings(parameters);
    }

    private Map<String, String> extractStrings(Properties properties) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
        return parameters;
    }

    public String getName() {
        return this.name;
    }

    public Class getTypeImplementorClass() {
        return this.typeImplementorClass;
    }

    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Properties getParametersAsProperties() {
        Properties properties = new Properties();
        properties.putAll(this.parameters);
        return properties;
    }

    public BasicValueMapping.Resolution resolve(BasicJavaDescriptor explicitJtd, SqlTypeDescriptor explicitStd, Map localConfigParameters, MutabilityPlan explicitMutabilityPlan, MetadataBuildingContext context) {
        if (CollectionHelper.isEmpty(localConfigParameters)) {
            if (this.reusableResolution == null) {
                ManagedBean typeBean = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(this.typeImplementorClass);
                Object typeInstance = typeBean.getBeanInstance();
                TypeDefinition.injectParameters(typeInstance, () -> this.parameters);
                this.reusableResolution = TypeDefinition.createReusableResolution(typeInstance, this.name, context);
            }
            return this.reusableResolution;
        }
        String name = this.name + ":" + nameCounter.getAndIncrement();
        ManagedBean typeBean = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(name, this.typeImplementorClass);
        Object typeInstance = typeBean.getBeanInstance();
        TypeDefinition.injectParameters(typeInstance, () -> TypeDefinition.mergeParameters(this.parameters, localConfigParameters));
        return TypeDefinition.createResolution(name, typeInstance, explicitJtd, explicitStd, explicitMutabilityPlan, context);
    }

    private static Map<String, String> mergeParameters(Map<String, String> parameters, Map<String, String> localConfigParameters) {
        HashMap<String, String> mergedParameters = new HashMap<String, String>(parameters);
        if (localConfigParameters != null && !localConfigParameters.isEmpty()) {
            mergedParameters.putAll(localConfigParameters);
        }
        return mergedParameters;
    }

    private static void injectParameters(Object customType, Supplier<Map> parameterSupplier) {
        if (customType instanceof ParameterizedType) {
            ((ParameterizedType)customType).setParameters(parameterSupplier.get());
        }
    }

    public static BasicValueMapping.Resolution createReusableResolution(Object namedTypeInstance, String name, MetadataBuildingContext metadataBuildingContext) {
        if (namedTypeInstance instanceof UserType) {
            UserType userType = (UserType)namedTypeInstance;
            return new UserTypeResolution(new UserTypeAdapter(userType, name, metadataBuildingContext), new UserTypeMutabilityPlanAdapter(userType));
        }
        if (namedTypeInstance instanceof org.hibernate.type.BasicType) {
            org.hibernate.type.BasicType basicType = (org.hibernate.type.BasicType)namedTypeInstance;
            return new BasicTypeResolution(new BasicTypeAdapter(basicType, name), new BasicTypeMutabilityPlanAdapter(basicType));
        }
        throw new IllegalArgumentException("Named type [" + namedTypeInstance + "] did not implement BasicType nor UserType");
    }

    public static BasicValueMapping.Resolution createLocalResolution(String name, Class typeImplementorClass, BasicJavaDescriptor explicitJtd, SqlTypeDescriptor explicitStd, MutabilityPlan explicitMutabilityPlan, Map localTypeParams, ResolutionContext resolutionContext) {
        name = name + ':' + nameCounter.getAndIncrement();
        ManagedBean typeBean = resolutionContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(name, typeImplementorClass);
        Object typeInstance = typeBean.getBeanInstance();
        TypeDefinition.injectParameters(typeInstance, () -> localTypeParams);
        return TypeDefinition.createResolution(name, typeInstance, explicitJtd, explicitStd, explicitMutabilityPlan, resolutionContext.getMetadataBuildingContext());
    }

    private static BasicValueMapping.Resolution createResolution(String name, Object namedTypeInstance, BasicJavaDescriptor explicitJtd, SqlTypeDescriptor explicitStd, MutabilityPlan explicitMutabilityPlan, MetadataBuildingContext metadataBuildingContext) {
        if (namedTypeInstance instanceof UserType) {
            return new UserTypeResolution((UserType)namedTypeInstance, name, explicitJtd, explicitStd, explicitMutabilityPlan, metadataBuildingContext);
        }
        if (namedTypeInstance instanceof org.hibernate.type.BasicType) {
            return new BasicTypeResolution((org.hibernate.type.BasicType)namedTypeInstance, name, explicitJtd, explicitStd, explicitMutabilityPlan, metadataBuildingContext);
        }
        throw new IllegalArgumentException("Named type [" + name + " : " + namedTypeInstance + "] did not implement BasicType nor UserType");
    }

    @Override
    public BasicTypeResolver resolveTypeResolver(Map<String, String> localConfigParameters) {
        if (localConfigParameters.isEmpty()) {
            if (this.typeResolver == null) {
                this.typeResolver = this.buildTypeResolver(this.parameters);
            }
            return this.typeResolver;
        }
        HashMap<String, String> mergedParameters = new HashMap<String, String>(this.parameters);
        mergedParameters.putAll(localConfigParameters);
        return this.buildTypeResolver(mergedParameters);
    }

    private BasicTypeResolver buildTypeResolver(final Map<String, String> parameters) {
        return new BasicTypeResolver(){
            private BasicType basicType;

            @Override
            public <T> BasicType<T> resolveBasicType(ResolutionContext context) {
                if (this.basicType == null) {
                    this.basicType = this.instantiateBasicType();
                    this.injectParameters(this.basicType, parameters);
                }
                return this.basicType;
            }

            private <T> BasicType<T> instantiateBasicType() {
                BasicType basicType;
                try {
                    basicType = (BasicType)TypeDefinition.this.typeImplementorClass.newInstance();
                }
                catch (Exception e) {
                    throw new MappingException("Unable to instantiate custom type: " + TypeDefinition.this.typeImplementorClass.getName(), e);
                }
                return basicType;
            }

            private void injectParameters(Type<?> type, Map<String, String> parameters2) {
                if (parameters2 != null && !parameters2.isEmpty() && ParameterizedType.class.isInstance(type)) {
                    ((ParameterizedType)((Object)type)).setParameters(parameters2);
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.typeImplementorClass, that.typeImplementorClass) && Arrays.equals(this.registrationKeys, that.registrationKeys) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.typeImplementorClass != null ? this.typeImplementorClass.hashCode() : 0);
        result = 31 * result + (this.registrationKeys != null ? Arrays.hashCode(this.registrationKeys) : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeDefinition{name='" + this.name + '\'' + ", typeImplementorClass=" + this.typeImplementorClass + ", registrationKeys=" + Arrays.toString(this.registrationKeys) + ", parameters=" + this.parameters + '}';
    }
}

