/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.domain.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.metamodel.Type;
import org.hibernate.boot.model.domain.JavaTypeMapping;
import org.hibernate.boot.model.domain.ManagedJavaTypeMapping;
import org.hibernate.boot.model.domain.ManagedTypeMapping;
import org.hibernate.boot.model.domain.PersistentAttributeMapping;
import org.hibernate.boot.model.domain.spi.ManagedTypeMappingImplementor;
import org.hibernate.metamodel.model.domain.RepresentationMode;
import org.jboss.logging.Logger;

public abstract class AbstractManagedTypeMapping
implements ManagedTypeMappingImplementor {
    private static final Logger log = Logger.getLogger(AbstractManagedTypeMapping.class);
    private ManagedJavaTypeMapping javaTypeMapping;
    private ManagedTypeMapping superTypeMapping;
    private TreeMap<String, PersistentAttributeMapping> declaredAttributeMappings;

    @Override
    public JavaTypeMapping getJavaTypeMapping() {
        return this.javaTypeMapping;
    }

    protected void setJavaTypeMapping(ManagedJavaTypeMapping javaTypeMapping) {
        this.javaTypeMapping = javaTypeMapping;
    }

    @Override
    public String getName() {
        return this.getJavaTypeMapping().getTypeName();
    }

    @Override
    public void addDeclaredPersistentAttribute(PersistentAttributeMapping attribute) {
        log.debugf("Adding PersistentAttributeMapping [%s] to ManagedTypeMapping [%s]", (Object)attribute.getName(), (Object)this.getName());
        if (this.declaredAttributeMappings == null) {
            this.declaredAttributeMappings = new TreeMap();
        } else assert (!this.declaredAttributeMappings.containsKey(attribute.getName()));
        this.declaredAttributeMappings.put(attribute.getName(), attribute);
    }

    @Override
    public List<PersistentAttributeMapping> getDeclaredPersistentAttributes() {
        return this.declaredAttributeMappings == null ? Collections.emptyList() : new ArrayList<PersistentAttributeMapping>(this.declaredAttributeMappings.values());
    }

    @Override
    public List<PersistentAttributeMapping> getPersistentAttributes() {
        ArrayList<PersistentAttributeMapping> attributes = new ArrayList<PersistentAttributeMapping>();
        attributes.addAll(this.getDeclaredPersistentAttributes());
        if (this.getSuperManagedTypeMapping() != null) {
            attributes.addAll(this.getSuperManagedTypeMapping().getPersistentAttributes());
        }
        return attributes;
    }

    @Override
    public PersistentAttributeMapping getDeclaredPersistentAttribute(String attributeName) {
        return this.declaredAttributeMappings.get(attributeName);
    }

    @Override
    public boolean hasDeclaredPersistentAttribute(String name) {
        return this.declaredAttributeMappings.containsKey(name);
    }

    @Override
    public boolean hasPersistentAttribute(String name) {
        for (ManagedTypeMapping managedType = this; managedType != null; managedType = managedType.getSuperManagedTypeMapping()) {
            if (!this.hasDeclaredPersistentAttribute(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ManagedTypeMapping getSuperManagedTypeMapping() {
        return this.superTypeMapping;
    }

    @Override
    public void setSuperManagedType(ManagedTypeMapping superTypeMapping) {
        this.superTypeMapping = superTypeMapping;
    }

    @Override
    public void setExplicitRepresentationMode(RepresentationMode mode) {
        throw new UnsupportedOperationException("Support for ManagedType-specific explicit RepresentationMode not yet implemented");
    }

    @Override
    public RepresentationMode getExplicitRepresentationMode() {
        return null;
    }

    @Override
    public List<ManagedTypeMapping> getSuperManagedTypeMappings() {
        ArrayList<ManagedTypeMapping> managedTypeMappings = new ArrayList<ManagedTypeMapping>();
        for (ManagedTypeMapping superType = this.superTypeMapping; superType != null; superType = superType.getSuperManagedTypeMapping()) {
            managedTypeMappings.add(superType);
        }
        return managedTypeMappings;
    }

    protected ManagedTypeMapping getSuperManagedTypeMappingOfType(Type.PersistenceType persistenceType) {
        if (this.superTypeMapping.getPersistenceType() == persistenceType) {
            return this.superTypeMapping;
        }
        return null;
    }
}

