/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.domain.internal;

import org.hibernate.boot.model.domain.EmbeddableJavaTypeMapping;
import org.hibernate.boot.model.domain.NotYetResolvedException;
import org.hibernate.boot.model.domain.internal.AbstractManagedJavaTypeMapping;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.java.internal.EmbeddableJavaDescriptorImpl;
import org.hibernate.type.descriptor.java.spi.EmbeddableJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;

public class EmbeddableJavaTypeMappingImpl<T>
extends AbstractManagedJavaTypeMapping<T>
implements EmbeddableJavaTypeMapping<T> {
    private final String roleName;
    private final String componentClassName;

    public EmbeddableJavaTypeMappingImpl(MetadataBuildingContext buildingContext, String roleName, String componentClassName, EmbeddableJavaTypeMapping<? super T> superJavaTypeMapping) {
        super(buildingContext, superJavaTypeMapping);
        this.roleName = roleName;
        this.componentClassName = componentClassName;
    }

    @Override
    public String getTypeName() {
        return this.componentClassName;
    }

    @Override
    public EmbeddableJavaTypeMapping<? super T> getSuperType() {
        return (EmbeddableJavaTypeMapping)super.getSuperType();
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() throws NotYetResolvedException {
        String name;
        BootstrapContext bootstrapContext = this.getMetadataBuildingContext().getBootstrapContext();
        JavaTypeDescriptorRegistry registry = bootstrapContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        EmbeddableJavaDescriptorImpl javaDescriptor = (EmbeddableJavaDescriptorImpl)registry.getDescriptor(name = this.roleName != null ? this.roleName : this.componentClassName);
        if (javaDescriptor == null) {
            Class javaType = StringHelper.isEmpty(this.componentClassName) ? null : bootstrapContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(this.componentClassName);
            javaDescriptor = new EmbeddableJavaDescriptorImpl(name, javaType, null);
            registry.addDescriptor(javaDescriptor);
        } else if (!(javaDescriptor instanceof EmbeddableJavaDescriptor)) {
            javaDescriptor = new EmbeddableJavaDescriptorImpl(name, javaDescriptor.getJavaType(), null);
        }
        return javaDescriptor;
    }
}

