/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.domain.internal;

import org.hibernate.boot.model.domain.EntityJavaTypeMapping;
import org.hibernate.boot.model.domain.IdentifiableJavaTypeMapping;
import org.hibernate.boot.model.domain.NotYetResolvedException;
import org.hibernate.boot.model.domain.internal.AbstractIdentifiableJavaTypeMapping;
import org.hibernate.boot.model.source.internal.SourceHelper;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.internal.ImmutableEntityEntryFactory;
import org.hibernate.engine.internal.MutableEntityEntryFactory;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.internal.EntityJavaDescriptorImpl;
import org.hibernate.type.descriptor.java.internal.EntityMutabilityPlanImpl;
import org.hibernate.type.descriptor.java.spi.IdentifiableJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class EntityJavaTypeMappingImpl<T>
extends AbstractIdentifiableJavaTypeMapping<T>
implements EntityJavaTypeMapping<T> {
    private PersistentClass persistentClass;

    public EntityJavaTypeMappingImpl(MetadataBuildingContext buildingContext, PersistentClass persistentClass, IdentifiableJavaTypeMapping<? super T> superJavaTypeMapping) {
        super(buildingContext, superJavaTypeMapping);
        this.persistentClass = persistentClass;
    }

    @Override
    public String getTypeName() {
        return StringHelper.isNotEmpty(this.persistentClass.getClassName()) ? this.persistentClass.getClassName() : this.persistentClass.getEntityName();
    }

    @Override
    public String getEntityName() {
        return this.persistentClass.getEntityName();
    }

    @Override
    public String getJpaEntityName() {
        return this.persistentClass.getJpaEntityName();
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() throws NotYetResolvedException {
        String name = this.getTypeName();
        BootstrapContext bootstrapContext = this.getMetadataBuildingContext().getBootstrapContext();
        return SourceHelper.resolveJavaDescriptor(name, bootstrapContext.getTypeConfiguration(), () -> new EntityJavaDescriptorImpl(this.getTypeName(), this.getEntityName(), SourceHelper.resolveJavaType(name, bootstrapContext), this.getSuperType() == null ? null : (IdentifiableJavaDescriptor)this.getSuperType().getJavaTypeDescriptor(), this.getMutabilityPlan(), null));
    }

    private MutabilityPlan getMutabilityPlan() {
        if (this.persistentClass.isMutable()) {
            return new EntityMutabilityPlanImpl(MutableEntityEntryFactory.INSTANCE, this.persistentClass.getEntityName(), true);
        }
        return new EntityMutabilityPlanImpl(ImmutableEntityEntryFactory.INSTANCE, this.persistentClass.getEntityName(), false);
    }
}

