/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.domain.internal;

import org.hibernate.boot.model.domain.IdentifiableJavaTypeMapping;
import org.hibernate.boot.model.domain.MappedSuperclassJavaTypeMapping;
import org.hibernate.boot.model.domain.internal.AbstractIdentifiableJavaTypeMapping;
import org.hibernate.boot.model.source.internal.SourceHelper;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.type.descriptor.java.internal.MappedSuperclassJavaDescriptorImpl;
import org.hibernate.type.descriptor.java.spi.IdentifiableJavaDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;

public class MappedSuperclassJavaTypeMappingImpl<T>
extends AbstractIdentifiableJavaTypeMapping<T>
implements MappedSuperclassJavaTypeMapping<T> {
    private final String typeName;

    public MappedSuperclassJavaTypeMappingImpl(MetadataBuildingContext buildingContext, String typeName, IdentifiableJavaTypeMapping<? super T> superJavaTypeMapping) {
        super(buildingContext, superJavaTypeMapping);
        this.typeName = typeName;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public IdentifiableJavaDescriptor<T> getJavaTypeDescriptor() {
        BootstrapContext bootstrapContext = this.getMetadataBuildingContext().getBootstrapContext();
        JavaTypeDescriptorRegistry registry = bootstrapContext.getTypeConfiguration().getJavaTypeDescriptorRegistry();
        MappedSuperclassJavaDescriptorImpl javaDescriptor = (MappedSuperclassJavaDescriptorImpl)registry.getDescriptor(this.typeName);
        if (javaDescriptor == null) {
            javaDescriptor = new MappedSuperclassJavaDescriptorImpl(this.typeName, SourceHelper.resolveJavaType(this.typeName, bootstrapContext), this.getSuperType() == null ? null : (IdentifiableJavaDescriptor)this.getSuperType().getJavaTypeDescriptor(), null, null);
            registry.addDescriptor(javaDescriptor);
        }
        return javaDescriptor;
    }
}

