/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.domain.internal;

import java.util.function.Function;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.domain.BasicValueMapping;
import org.hibernate.boot.model.domain.ResolutionContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.metamodel.model.domain.spi.BasicValueMapper;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class NamedConverterResolution<J>
implements BasicValueMapping.Resolution<J>,
BasicValueMapper<J> {
    private final String name;
    private final BasicJavaDescriptor domainJtd;
    private final BasicType basicType;
    private final BasicValueConverter valueConverter;
    private final MutabilityPlan mutabilityPlan;

    public static NamedConverterResolution from(String name, Function<TypeConfiguration, BasicJavaDescriptor<?>> explicitJtdAccess, Function<TypeConfiguration, SqlTypeDescriptor> explicitStdAccess, JpaAttributeConverterCreationContext converterCreationContext, MutabilityPlan explicitMutabilityPlan, SqlTypeDescriptorIndicators sqlTypeIndicators, ResolutionContext resolutionContext) {
        assert (name.startsWith("converted::"));
        String converterClassName = name.substring("converted::".length());
        StandardServiceRegistry serviceRegistry = resolutionContext.getBootstrapContext().getServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        Class converterClass = classLoaderService.classForName(converterClassName);
        ClassBasedConverterDescriptor converterDescriptor = new ClassBasedConverterDescriptor(converterClass, resolutionContext.getBootstrapContext().getClassmateContext());
        JpaAttributeConverter converter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
        BasicJavaDescriptor<?> explicitJtd = explicitJtdAccess != null ? explicitJtdAccess.apply(resolutionContext.getBootstrapContext().getTypeConfiguration()) : null;
        BasicJavaDescriptor<Object> domainJtd = explicitJtdAccess != null ? explicitJtd : converter.getDomainJavaDescriptor();
        SqlTypeDescriptor explicitStd = explicitStdAccess != null ? explicitStdAccess.apply(resolutionContext.getBootstrapContext().getTypeConfiguration()) : null;
        BasicJavaDescriptor relationalJtd = converter.getRelationalJavaDescriptor();
        SqlTypeDescriptor relationalStd = explicitStd != null ? explicitStd : relationalJtd.getJdbcRecommendedSqlType(sqlTypeIndicators);
        return new NamedConverterResolution(name, domainJtd, new BasicTypeImpl(relationalJtd, relationalStd, relationalStd.getSqlExpressableType(relationalJtd, resolutionContext.getBootstrapContext().getTypeConfiguration())), converter, explicitMutabilityPlan != null ? explicitMutabilityPlan : converter.getDomainJavaDescriptor().getMutabilityPlan());
    }

    private NamedConverterResolution(String name, BasicJavaDescriptor domainJtd, BasicType basicType, JpaAttributeConverter valueConverter, MutabilityPlan mutabilityPlan) {
        this.name = name;
        this.domainJtd = domainJtd;
        this.basicType = basicType;
        this.valueConverter = valueConverter;
        this.mutabilityPlan = mutabilityPlan;
    }

    @Override
    public BasicType getBasicType() {
        return this.basicType;
    }

    @Override
    public BasicValueMapper<J> getValueMapper() {
        return this;
    }

    @Override
    public BasicJavaDescriptor<J> getDomainJavaDescriptor() {
        return this.domainJtd;
    }

    @Override
    public BasicJavaDescriptor<?> getRelationalJavaDescriptor() {
        return this.basicType.getJavaTypeDescriptor();
    }

    @Override
    public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
        return this.basicType.getSqlTypeDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public SqlExpressableType getSqlExpressableType() {
        return this.basicType.getSqlExpressableType();
    }

    public String toString() {
        return "NamedConverterResolution(" + this.name + ')';
    }
}

