/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.query.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.ParameterMode;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.boot.model.query.spi.NamedQueryDefinition;
import org.hibernate.boot.model.query.spi.ParameterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.named.spi.ParameterMemento;

public abstract class AbstractNamedQueryDefinition
implements NamedQueryDefinition {
    private final String name;
    private final List<ParameterDefinition> parameterDescriptors;
    private final Boolean cacheable;
    private final String cacheRegion;
    private final CacheMode cacheMode;
    private final FlushMode flushMode;
    private final Boolean readOnly;
    private final LockOptions lockOptions;
    private final Integer timeout;
    private final Integer fetchSize;
    private final String comment;
    private final Map<String, Object> hints;

    public AbstractNamedQueryDefinition(String name, List<ParameterDefinition> parameterDescriptors, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, Object> hints) {
        this.name = name;
        this.parameterDescriptors = parameterDescriptors == null ? new ArrayList<ParameterDefinition>() : new ArrayList<ParameterDefinition>(parameterDescriptors);
        this.cacheable = cacheable;
        this.cacheRegion = cacheRegion;
        this.cacheMode = cacheMode;
        this.flushMode = flushMode;
        this.readOnly = readOnly;
        this.lockOptions = lockOptions;
        this.timeout = timeout;
        this.fetchSize = fetchSize;
        this.comment = comment;
        this.hints = hints == null ? new HashMap<String, Object>() : new HashMap<String, Object>(hints);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    protected List<ParameterMemento> resolveParameterDescriptors(SessionFactoryImplementor factory) {
        ArrayList<ParameterMemento> descriptors = new ArrayList<ParameterMemento>();
        this.parameterDescriptors.forEach(parameterDefinition -> descriptors.add(parameterDefinition.resolve(factory)));
        return descriptors;
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder> {
        private final String name;
        private List<ParameterDefinition> parameterDescriptors;
        private Set<String> querySpaces;
        private Boolean cacheable;
        private String cacheRegion;
        private CacheMode cacheMode;
        private FlushMode flushMode;
        private Boolean readOnly;
        private LockOptions lockOptions;
        private Integer timeout;
        private Integer fetchSize;
        private String comment;
        private Map<String, Object> hints;

        public AbstractBuilder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        protected abstract T getThis();

        public T addParameter(Class javaType, ParameterMode mode) {
            return this.addParameter(this.createPositionalParameter(this.parameterDescriptors.size() + 1, javaType, mode));
        }

        protected abstract ParameterDefinition createPositionalParameter(int var1, Class var2, ParameterMode var3);

        public T addParameter(ParameterDefinition parameterDefinition) {
            if (this.parameterDescriptors == null) {
                this.parameterDescriptors = new ArrayList<ParameterDefinition>();
            }
            this.parameterDescriptors.add(parameterDefinition);
            return this.getThis();
        }

        public T addParameter(String name, Class javaType, ParameterMode mode) {
            if (this.parameterDescriptors == null) {
                this.parameterDescriptors = new ArrayList<ParameterDefinition>();
            }
            this.parameterDescriptors.add(this.createNamedParameter(name, javaType, mode));
            return this.getThis();
        }

        protected abstract ParameterDefinition createNamedParameter(String var1, Class var2, ParameterMode var3);

        public T addQuerySpaces(Set<String> querySpaces) {
            if (querySpaces == null || querySpaces.isEmpty()) {
                return this.getThis();
            }
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.addAll(querySpaces);
            return this.getThis();
        }

        public T addQuerySpace(String space) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.add(space);
            return this.getThis();
        }

        public T setCacheable(Boolean cacheable) {
            this.cacheable = cacheable;
            return this.getThis();
        }

        public T setCacheRegion(String cacheRegion) {
            this.cacheRegion = cacheRegion;
            return this.getThis();
        }

        public T setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            return this.getThis();
        }

        public T setLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this.getThis();
        }

        public T setTimeout(Integer timeout) {
            this.timeout = timeout;
            return this.getThis();
        }

        public T setFlushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
            return this.getThis();
        }

        public T setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this.getThis();
        }

        public T setFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this.getThis();
        }

        public T setComment(String comment) {
            this.comment = comment;
            return this.getThis();
        }

        public Set<String> getQuerySpaces() {
            return this.querySpaces;
        }

        public Boolean getCacheable() {
            return this.cacheable;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public FlushMode getFlushMode() {
            return this.flushMode;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public Integer getFetchSize() {
            return this.fetchSize;
        }

        public String getComment() {
            return this.comment;
        }

        protected List<ParameterDefinition> getParameterDescriptors() {
            return this.parameterDescriptors;
        }

        public void addHint(String name, Object value) {
            if (this.hints == null) {
                this.hints = new HashMap<String, Object>();
            }
            this.hints.put(name, value);
        }

        public Map<String, Object> getHints() {
            return this.hints;
        }
    }
}

